package com.gtis.plat.service.impl;

import com.gtis.plat.form.FormInstance;
import com.gtis.plat.form.FormInstanceFactory;
import com.gtis.plat.form.FormXmlBuilder;
import com.gtis.plat.service.FormDataService;
import com.gtis.plat.service.SysMenuService;
import com.gtis.plat.vo.PfResourceVo;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Document;
import org.dom4j.Element;

import java.util.HashMap;
import java.util.Map;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 11-3-17
 */
public class FormDataServiceImpl implements FormDataService {

    private SysMenuService sysMenuService;

    private FormInstanceFactory instanceFactory;

    public void setSysMenuService(SysMenuService sysMenuService) {
        this.sysMenuService = sysMenuService;
    }

    public void setInstanceFactory(FormInstanceFactory instanceFactory) {
        this.instanceFactory = instanceFactory;
    }

    public Map<String, String> getData(String code, String proId) {
        PfResourceVo res = sysMenuService.getResourceByCode(code);
        Map<String, String> map = new HashMap<String, String>();
        if (res != null) {
            FormInstance formInstance = instanceFactory
                    .createFormInstance(res.getResourceId());
            formInstance.setProId(proId);
            Document doc = FormXmlBuilder.buildFormXml(formInstance);
            for (Object obj : doc.selectNodes("//DataSet/ElementData")) {
                Element el = (Element) obj;
                String value = el.getText();
                if (StringUtils.isNotEmpty(value))
                    map.put(el.attributeValue("Id"), value);
            }
        }
        return map;
    }
}
