/*
 * Author: xyang
 *
 * Project: egov
 *
 * File: PortalManager.java
 *
 * LastModified: 2009-11-30 07:38:14
 *
 * Copyright (c) 2009 gtis. All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent or the
 * registration of a utility model, design or code.
 *
 * Issued by gtis Ltd.
 */

package com.gtis.plat.portal;

import com.gtis.plat.portal.model.PortletApp;
import com.gtis.plat.portal.model.PortletEntity;
import com.gtis.plat.portal.model.Site;
import com.gtis.plat.service.CountProvider;

import java.util.Collection;
import java.util.List;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 2009-11-30
 */
public interface PortalManager {

    PortletApp getPortletApp(String name);

    List<PortletApp> getPortletApps();

    PortletEntity getPortletEntity(String id);

    Collection<PortletEntity> getPortletEntities();

    PortletEntity savePortletEntity(PortletEntity portletEntity);

    void removePortletEntity(String id);

    Site getSite(String owner);

    Site saveSite(Site site);

    void removeSite(String owner);

    List<CountProvider> getCountProviders();

    void resetUserSite();
}
