package com.gtis.plat.form.print.xmlutil;


import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.apache.struts2.ServletActionContext;


public class DynamicSignVoXml {
	private Object vo=null;

	public DynamicSignVoXml(Object vo) {
		this.vo=vo;
	}
	
	public String getXMLData()
	{
		String retvalue=getXML();
		return retvalue;
	}

	/**
	 * 获取对象所有的字段
	 * @return
	 */
	private List getFields()
	{
		List list=new ArrayList();
		Field[] ffields= vo.getClass().getDeclaredFields();
		int fieldcount= ffields.length;
		for (int i=0;i<fieldcount;i++)
		{
			Field aField=ffields[i];
			String fieldname= aField.getName();
			/**将字段前字母小写更新为大写**/
			fieldname=fieldname.substring(0,1).toUpperCase()+fieldname.substring(1);
			list.add(fieldname);
		}
		return list;
	}
	
	/**将VO中的数据转换成XML格式**/
	private String getXML()
	{
		
		StringBuffer sb=new StringBuffer();
		List list=getFields();
		Iterator it= list.iterator();
		while (it.hasNext())
		{
			String fieldname=(String)it.next();
			String methodname="get"+fieldname;
			Method method=getMethod(methodname);
			/**如果方法存在，则进行下一步处理**/
			if (method!=null)
			{
				String datastr="";
				String fieldtype=getFiledType(method);
				
				if(methodname.equalsIgnoreCase("getProid")){
					String proid = getValue(method,fieldtype.trim());
				}
				if(methodname.equalsIgnoreCase("getUserId")){
					String userid = getValue(method,fieldtype.trim());
				}
				if(fieldname.equalsIgnoreCase("UserSign")){
					String proid = getValue(getMethod("getProId"),"String");
					String userid = getValue(getMethod("getUserId"),"String");
					String host = ServletActionContext.getRequest().getRemoteHost();
					String port =   ServletActionContext.getRequest().getServerPort() + "";
					String context = ServletActionContext.getRequest().getContextPath();
					String httpurl = "http://" + host +":"+ port + context;
					String url = "<![CDATA["+httpurl +"/dynamicsign!getSignImage.action?proid="+proid+"&userId="+userid+"]]>";
					datastr="<data name=\"UserSign\" type=\"image\">"+url+"</data>\n";
					
				}
				else{
				  datastr="<data name=\""+fieldname.trim()+"\" type=\""+fieldtype.trim()+"\">"+getValue(method,fieldtype.trim())+"</data>\n";
				}
				sb.append(datastr);
			}
		}
		
		return sb.toString();
	}
	
	/**获取方法**/
	private Method getMethod(String methodName)
	{
		Method method=null;
		try {
			method =vo.getClass().getDeclaredMethod(methodName,new Class[]{});
		} catch (Exception e) {
			method=null;
			e.printStackTrace();
		}
		return method;
	}
	
	/**获取值**/
	private String getValue(Method method,String fieldtype)
	{
		String retvalue=null;
		Object retobj=null;
		try {
			
			retobj=method.invoke(vo,null);
		} catch (Exception e) {
			e.printStackTrace();
		}

		
		if (retobj==null)
			retvalue="";
		else if (fieldtype.equalsIgnoreCase("String"))
			retvalue=(String)retobj;
		else if (fieldtype.equals("int"))
		{
			int temp=(Integer)retobj;
			retvalue=Integer.toString(temp);
		}else if (fieldtype.equalsIgnoreCase("Boolean"))
		{
			Boolean temp=(Boolean)retobj;
			retvalue=Boolean.toString(temp);
		}else if (fieldtype.equalsIgnoreCase("float"))
		{
			float temp=(Float)retobj;
			retvalue=Float.toString(temp);
		}else if (fieldtype.equalsIgnoreCase("double"))
		{
			double temp=(Double)retobj;
			retvalue=Double.toString(temp);
		}else if (fieldtype.equals("BigDecimal"))
		{
			BigDecimal temp=(BigDecimal)retobj;
			retvalue=temp.toString();
		}else if (fieldtype.equals("long"))
		{
			long temp=(Long)retobj;
			retvalue=Long.toString(temp);
		}else if (fieldtype.equalsIgnoreCase("short"))
		{
			short temp=(Short)retobj;
			retvalue=Short.toString(temp);
		}else if (fieldtype.equals("byte"))
		{
			byte temp=(Byte)retobj;
			retvalue=Byte.toString(temp);
		}else if (fieldtype.equalsIgnoreCase("Integer")){
			Integer tempInt = (Integer)retobj;
			retvalue = String.valueOf(tempInt.intValue());
		}else if(fieldtype.equalsIgnoreCase("Date")){
			Date temp = (Date)retobj;
			retvalue=(temp.getYear()+1900)+"年"+(temp.getMonth()+1)+"月"+temp.getDate()+"日";
		}
		else{   
			retvalue = "";
		}
		return retvalue;
	}
	
	/**获取字段类型**/
	private String getFiledType(Method method)
	{
		String fieldtype=method.getReturnType().toString();
		int pos=fieldtype.lastIndexOf(".");
		if (pos>0){
			fieldtype=fieldtype.substring(pos+1);
			
		}
		return fieldtype;
	}
}
