package com.gtis.plat.form;


import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang.StringUtils;
import org.dom4j.Document;
import org.dom4j.Element;

import com.gtis.common.util.UUIDGenerator;
import com.gtis.util.DataSourceManager;
import com.gtis.web.old.FormDefintion;


public class GroupDefine {
	String groupId = "";
	String groupName = "";
	String fkTable = "";
	String pkField = "";
	String fkField = "";

	FormChild formChild = null;
	/**
	 * 定义了子表中每个元素的属性，包括ID,name,type等内容
	 */
	List lstDeine = new ArrayList();

	public GroupDefine(Map requestMap,Element groupNode) {
		if (groupNode != null) {
			groupId = groupNode.valueOf("@Id");
			fkTable = groupNode.valueOf("@FkTable");
			pkField = groupNode.valueOf("@PkField");
			fkField = groupNode.valueOf("@FkField");
			List lstChild = groupNode.selectNodes("ElementDefine");
			for (int i = 0; i < lstChild.size(); i++) {
				Element child = (Element) lstChild.get(i);
				FormElement element = new FormElement(child);
				AddChildElement(element);
			}
			formChild = new FormChild();
			for (Iterator j = groupNode.elementIterator(); j.hasNext();) {
				Element elementDefine = (Element) j.next();
				String elementId = elementDefine.valueOf("@Id");
				//System.out.println("-----------elementId="+elementId);
				formChild.addFieldValues(requestMap, elementId);
			}
            formChild.addFieldValues(requestMap,groupId+"_id");
		}
	}
	


	public void AddChildElement(FormElement childElement) {
		lstDeine.add(childElement);
	}


	/**
	 * 更新grid子表数据
	 * @param fkValue
	 * @param conn
	 * @throws SQLException
	 */
	public void updateGridForm2(String fkValue, Connection conn) throws SQLException {

        //当grid 为diable时候，提交所有的列的数据都没有，这个时候不要保存包括删除；
        if (formChild.getSize()==0){
            return;
        }
		StringBuffer delSql = new StringBuffer();
		delSql.append("delete from "+fkTable+" where "+fkField+"='"+fkValue+"'");
		Statement stmt = conn.createStatement();
		stmt.executeUpdate(delSql.toString());
		
		StringBuffer sql = new StringBuffer();
		StringBuffer values = new StringBuffer();
		
		
		for (int k = 0;k < formChild.getSize();k++){
			boolean needUpdate = false;
			sql.delete(0,sql.length());
			values.delete(0, values.length());
			sql.append("insert into " + fkTable + " (");
			
			for (int i = 0; i < lstDeine.size(); i++) {
				
				FormElement childElement = (FormElement) lstDeine.get(i);
				String value = formChild.getFieldValue(childElement.getElementId(), k);
				if (!value.trim().equals("")) {
					needUpdate = true;
					sql.append(eraseGroupIdOfElementId(childElement.getElementId()) + ",");
					if (childElement.elementType.startsWith("Date")) {
						values.append("to_date('" + value + "','yyyy-MM-dd'),");
					} else {
						values.append("'" + value + "',");
					}
				}
			}		
			if (!needUpdate) continue;
			String newId = UUIDGenerator.generate();
			sql.append(pkField + "," + fkField);
			sql.append(") values (");
			sql.append(values.toString() + "'" + newId + "','" + fkValue + "'");
			sql.append(" )");
			stmt.executeUpdate(sql.toString());
		}
	}

    public void updateGridForm(String fkValue, Connection conn) throws SQLException {
        //当grid 为diable时候，提交所有的列的数据都没有，这个时候不要保存包括删除；
        if (formChild.getSize()==0){
            return;
        }
		List<String> pkValues= getChildGrid(fkValue,conn);

		for (int k = 0;k < formChild.getSize();k++){
			StringBuffer sql = new StringBuffer();
		    StringBuffer values = new StringBuffer();
            String pkValue = formChild.getFieldValue(groupId+"_id", k);
            if (StringUtils.isBlank(pkValue) || !pkValues.contains(pkValue)) {
                boolean needUpdate = false;
                sql.append("insert into " + fkTable + " (");
                for (int i = 0; i < lstDeine.size(); i++) {

                    FormElement childElement = (FormElement) lstDeine.get(i);
                    String value = formChild.getFieldValue(childElement.getElementId(), k);
                    if (!value.trim().equals("")) {
                        needUpdate = true;
                        sql.append(eraseGroupIdOfElementId(childElement.getElementId()) + ",");
                        if (childElement.elementType.startsWith("Date")) {
                            values.append("to_date('" + value + "','yyyy-MM-dd'),");
                        } else {
                            values.append("'" + value + "',");
                        }
                    }
                }
                if (!needUpdate) continue;
                String newId = UUIDGenerator.generate();
                sql.append(pkField + "," + fkField);
                sql.append(") values (");
                sql.append(values.toString() + "'" + newId + "','" + fkValue + "'");
                sql.append(" )");
                updateChildGrid(conn,sql.toString());
            }else{
                sql.append("update " + fkTable + " set ");
                for (int i = 0; i < lstDeine.size(); i++) {

                    FormElement childElement = (FormElement) lstDeine.get(i);
                    String value = formChild.getFieldValue(childElement.getElementId(), k);
                    if (StringUtils.isNotBlank(value)) {
                        sql.append(eraseGroupIdOfElementId(childElement.getElementId()) +"=");
                        if (childElement.elementType.startsWith("Date")) {
                            sql.append("to_date('" + value + "','yyyy-MM-dd'),");
                        } else {
                            sql.append("'" + value + "',");
                        }
                    }
                }
                sql.append(fkField +  "='" +fkValue +"' "+" where " + pkField + "='" +pkValue +"'");
                updateChildGrid(conn,sql.toString());
                pkValues.remove(pkValue);
            }
		}
        //删除剩下的
        for(String delValue:pkValues){
            delChildGrid(delValue,conn);
        }
    }

    private void updateChildGrid(Connection conn,String updateSql)throws SQLException {
        Statement stmt = conn.createStatement();
        try{
		     stmt.executeUpdate(updateSql);
        }finally {
            if (stmt!=null) stmt.close();
        }
    }
    /**
     * 获取子表主键的集合
     * @param fkValue
     * @param conn
     * @return
     * @throws SQLException
     */
    private List<String> getChildGrid(String fkValue, Connection conn)throws SQLException {
        Statement stmt = conn.createStatement();
        ResultSet rs=null;
        List<String> result=new ArrayList<String>();
        try{
             String sql="select "+pkField+" from "+fkTable+" where "+fkField+"='"+fkValue+"'";
		     rs=stmt.executeQuery(sql);
            while (rs.next()){
                result.add(rs.getString(1));
            }
        }finally {
            if (rs!=null) rs.close();
            if (stmt!=null) stmt.close();
        }
        return result;
    }

    /**
     * 删除子表记录,根据主键
     * @param pkValue
     * @param conn
     * @throws SQLException
     */
    private void delChildGrid(String pkValue, Connection conn)throws SQLException {
        Statement stmt = conn.createStatement();
        try{
             String sql="delete from "+fkTable+" where "+pkField+"='"+pkValue+"'";
		     stmt.executeUpdate(sql);
        }finally {
            if (stmt!=null) stmt.close();
        }
    }

	/**
	 * 为了避免和主表里面的元素ID，在进行Grid动态表单设计时，每个元素的ID都加了groupid(groupid.elementId形式),因此保存之前要去掉groupid
	 * @param elementId
	 * @return
	 */
	public static String eraseGroupIdOfElementId(String elementId){
		String resultId = "";
		if (elementId == null || elementId.length() ==0){
			return resultId;
		}
		if (elementId.indexOf(".") >=0){
			resultId = elementId.substring(elementId.indexOf(".")+1,elementId.length());
		}else{
			resultId=elementId;
		}
		
		return resultId;
		
	}
	

	public String getFkField() {
		return fkField;
	}

	public void setFkField(String fkField) {
		this.fkField = fkField;
	}

	public String getFkTable() {
		return fkTable;
	}

	public void setFkTable(String fkTable) {
		this.fkTable = fkTable;
	}

	public String getGroupId() {
		return groupId;
	}

	public void setGroupId(String groupId) {
		this.groupId = groupId;
	}

	public String getGroupName() {
		return groupName;
	}

	public void setGroupName(String groupName) {
		this.groupName = groupName;
	}

	public String getPkField() {
		return pkField;
	}

	public void setPkField(String pkField) {
		this.pkField = pkField;
	}


}
