package com.gtis.plat.form;

import com.gtis.common.util.FreeMarkerTemplateUtils;
import com.gtis.plat.wf.WorkFlowXmlUtil;
import com.gtis.web.SessionUtil;
import freemarker.template.Configuration;
import freemarker.template.Template;
import org.apache.commons.lang.StringUtils;

import java.io.StringReader;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Pattern;

/**
 * Created with IntelliJ IDEA.
 * User: JIBO
 * Date: 12-10-23
 * Time: 上午10:30
 * To change this template use File | Settings | File Templates.
 */
public class FormSqlProcessor {
    private static final Pattern PATTERN = Pattern.compile("#([^#]+)#");
    protected Configuration freeMarkerConfigurer;
    private WorkFlowXmlUtil workFlowXmlUtil;


    public void setWorkFlowXmlUtil(WorkFlowXmlUtil workFlowXmlUtil) {
        this.workFlowXmlUtil = workFlowXmlUtil;
    }

    public void setFreeMarkerConfigurer(Configuration freeMarkerConfigurer) {
        this.freeMarkerConfigurer = freeMarkerConfigurer;
    }

    /**
     * 将sql语句中的#proid#替换为freemark的语法${proid}
     *
     * @param tpl
     * @return
     */
    private static String rewriteTpl(String tpl) {
        return PATTERN.matcher(tpl).replaceAll("\\${$1}");
    }

//    private static String trimBlank(String s) {
//        return s.replaceAll("(?is)^\\s*(.*?)\\s*$", "$1");
//    }

    /**
     * 加入些必须的常量
     *
     * @param paramMap
     * @return
     */
    private static Map buildMapConstant(Map paramMap) {

        Map paramMapNew = new HashMap();
        if (paramMap != null) {
            Iterator it = paramMap.keySet().iterator();
            while (it.hasNext()) {
                Object key = it.next();
                Object value = paramMap.get(key);
                if (value == null) {
                    paramMapNew.put(key.toString().toUpperCase(), "null");
                } else if (value instanceof String) {
                    if (StringUtils.isBlank(value.toString()))
                        paramMapNew.put(key.toString().toUpperCase(), "null");
                    else
                        paramMapNew.put(key.toString().toUpperCase(), "'" + value + "'");
                } else if (value instanceof String[] && ((String[]) value).length > 0)
                    paramMapNew.put(key.toString().toUpperCase(), "'" + ((String[]) value)[0].toString() + "'");
                else if (value instanceof Date || value instanceof java.sql.Date) {
                    java.text.DateFormat df = new java.text.SimpleDateFormat(
                            "yyyy-MM-dd");
                    paramMapNew.put(key.toString().toUpperCase(), "to_date('" + df.format(value) + "','yyyy-mm-dd')");
                } else
                    paramMapNew.put(key.toString().toUpperCase(), value);
            }
        }
        if (StringUtils.isNotBlank(SessionUtil.getCurrentUserId())) {
            paramMapNew.put("USERID", "'" + SessionUtil.getCurrentUserId() + "'");
            paramMapNew.put("USERNAME", "'" + SessionUtil.getCurrentUser().getUsername() + "'");
        }
        paramMapNew.put("SYSDATE", "(select sysdate  from dual)");
        return paramMapNew;
    }

    public String processor(String sql, String proId, Map formMap) throws Exception {
        HashMap<String, Object> paramMap = workFlowXmlUtil.getGobalValByProId(proId);
        if (paramMap == null) paramMap = new HashMap();
        paramMap.put("proid", proId);
        if (formMap != null)
            paramMap.putAll(formMap);
        return processor(sql, paramMap);
    }

    public String processor(String sql, String proId) throws Exception {
        HashMap<String, Object> paramMap = workFlowXmlUtil.getGobalValByProId(proId);
        if (paramMap == null) paramMap = new HashMap();
        paramMap.put("proid", proId);
        return processor(sql, paramMap);
    }

    public String processor(String sql, String key, String value) throws Exception {
        HashMap<String, String> mapParam = new HashMap<String, String>();
        mapParam.put(key.toUpperCase(), "'" + value + "'");
        return processor(sql, mapParam);
    }

    public String processor(String sql, Map mapParam) throws Exception {
        String sqlNew = rewriteTpl(sql);

        mapParam = buildMapConstant(mapParam);
        Template tpl = new Template(null, new StringReader(sqlNew), freeMarkerConfigurer);
        return FreeMarkerTemplateUtils.processTemplateIntoString(tpl, mapParam);
    }

    public static void main(String[] args) {
        System.out.println(rewriteTpl("ads '#assdd#' #asssdas12123ddd# #asssdas12我123ddd# asd"));
    }
}
