package com.gtis.plat.form;

import java.text.DecimalFormatSymbols;
import java.text.MessageFormat;
import java.util.*;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import com.gtis.spring.Container;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.Node;
import com.gtis.util.StaticParamHelper;

public class FormSqlBuilder {
	
	private final static String SQL_INDEX="#";
	private static  Log log = LogFactory.getLog("FormSqlBuilder");


//    /**
//     * 把sql中的"PROID"替换为具体的proId的值。
//     * @param sql
//     * @param proId
//     * @return
//     */
//	public static String replaceProIdSql(String sql,String proId){
//
//			return replaceText(sql,"proid","'"+proId+"'");
//	}

//    /**
//     * 把sql中的"USERID"替换为具体的USERID的值。
//     * @param sql
//     * @param userId
//     * @return
//     */
//    public static String replaceUserIdSql(String sql,String userId){
//		return replaceText(sql,"userId","'"+userId+"'");
//	}
//
//    /***
//     * 把sql中的"USERNAME"替换为具体的USERNAME的值。
//     * @param sql
//     * @param userName
//     * @return
//     */
//    public static String replaceUserName(String sql,String userName){
//        return replaceText(sql,"userName","'" + userName + "'");
//    }
//
//	public static String replaceDateSql(String sql){
//		return replaceText(sql,"sysdate","(select sysdate  from dual)");
//	}
	
	@SuppressWarnings("unchecked")
	public static List<String> buildUpdateSql(FormInstance formInstance,Map mapValue,Map selectMap) throws Exception{
		Log log = LogFactory.getLog("FormSqlBuilder");
        FormSqlProcessor formSqlProcessor = (FormSqlProcessor) Container
                .getBean("FormSqlProcessor");
		List<String> resultList = new Vector<String>();
		String updateSql=formInstance.getFormDefineVo().getUpdateCommand();
//		updateSql=replaceProIdSql(updateSql,formInstance.getProId());
        if (selectMap==null) selectMap=new HashMap();
        selectMap.putAll(mapValue);

        //////
        Iterator it = formInstance.getElementMap().keySet().iterator();
        while (it.hasNext()){
            Object key= it.next();
            Object value=selectMap.get(key.toString().toUpperCase());
            if (value instanceof String[]) value=((String[])value)[0];

            if (selectMap.containsKey(key.toString().toUpperCase())){
                FormElement ele=formInstance.getElementMap().get(key);
                if (ele.getElementDataType().startsWith("Date") && value!=null && StringUtils.isNotBlank(value.toString())){
                    java.text.DateFormat df2 = new java.text.SimpleDateFormat("yyyy-MM-dd");
                    selectMap.put(key.toString().toUpperCase(),df2.parse(value.toString()));
                }else if (ele.getElementDataType().startsWith("Integer") || ele.getElementDataType().startsWith("Number")){
                    if (value!=null  && StringUtils.isNotBlank(value.toString())){
                        selectMap.put(key.toString().toUpperCase(),Double.parseDouble(value.toString()));
                    }else{
                        selectMap.put(key.toString().toUpperCase(),null);
                    }
                }
            }

        }

        updateSql=formSqlProcessor.processor(updateSql,formInstance
                .getProId(),selectMap);
		if (updateSql==null || updateSql.trim().length() ==0){
			return resultList;
		}
		//updateSql = updateSql.replaceAll("\n", " ");
		//updateSql = updateSql.replaceAll("\r", " ");
		List<String> updateSqlList = new Vector<String>();
		String sqlWorkStr = updateSql;
		while(sqlWorkStr.indexOf(StaticParamHelper.SQL_SEPARATOR)>=0){
			String childUpdateSql = sqlWorkStr.substring(0,sqlWorkStr.indexOf(StaticParamHelper.SQL_SEPARATOR));
			updateSqlList.add(childUpdateSql);
			sqlWorkStr = sqlWorkStr.substring(sqlWorkStr.indexOf(StaticParamHelper.SQL_SEPARATOR)+StaticParamHelper.SQL_SEPARATOR.length(), sqlWorkStr.length());
		}
		updateSqlList.add(sqlWorkStr);

//		for (int i=0;i <updateSqlList.size();i++ ){
//			String tempUpdate = updateSqlList.get(i);
//			tempUpdate=castUpdateFieldValue(formInstance,mapValue,tempUpdate);
////			System.out.println("-updateSql-" + tempUpdate);
//			if (tempUpdate.trim().length() ==0 ){
//				continue;
//			}
//			resultList.add(tempUpdate);
//
//		}
		//updateSql=removeNullUpdateField(updateSql);
		return updateSqlList;
	}
	
	
	/**
	 * 对updateSql里面的内容进行替换处理
	 * @param pageParamMap
	 * @param updateSql 需要替换的sql，必须是大写
	 * @return
	 */
	public static String castUpdateFieldValue(FormInstance formInstance,Map pageParamMap,String updateSql){
		StringBuffer newSqlBuf = new StringBuffer();
		Map<String ,FormElement> elementMap = formInstance.getElementMap();
		
		newSqlBuf.append(updateSql.substring(0,updateSql.indexOf(" SET ")+5));
		String setContent = updateSql.substring(updateSql.indexOf(" SET ")+5,updateSql.indexOf(" WHERE "));
		StringBuffer setContenBuf = new StringBuffer();
		String[] fieldMapArray = setContent.split(",");
		for (int i=0;i < fieldMapArray.length;i++){
			if (fieldMapArray[i] != null&& fieldMapArray[i].trim().length()>0){
				String[] fieldMap =  fieldMapArray[i].split("=");
				if (fieldMap !=null && fieldMap.length >=2){
					if (fieldMap[0] == null || fieldMap[0].trim().length() == 0
							|| fieldMap[1] == null
							|| fieldMap[1].trim().length() == 0){
						continue;
					}

					String fieldKey = fieldMap[0].trim();
					String castKey = fieldMap[1].trim();
					 
					if(castKey.indexOf("#")<0){      //wanghao    2009-6-16  
						setContenBuf.append(fieldKey);
						setContenBuf.append("=");
						setContenBuf.append(castKey);
						setContenBuf.append(",");
					}
					else{
					    String keyName= castKey.replaceAll("#","");
						Object[] tempFieldValueObjArray = (String[])pageParamMap.get(keyName);
						
						if (tempFieldValueObjArray == null || tempFieldValueObjArray.length < 1){
							continue;
						}
						String value = (String)tempFieldValueObjArray[0];
						//if (value!=null && value.length() >0){wanghao  2009-6-16 
							setContenBuf.append(fieldKey);
							setContenBuf.append("=");
							//String newValue =replaceText(castKey,fieldKey,value); //wanghao  一定要repalcText??
							FormElement tempElement = elementMap.get(keyName);
							setContenBuf.append(convertFieldValueFormat(value,tempElement.getElementDataType()));//wanghao 2009-06-17  newValue --> value
							setContenBuf.append(",");
						//}wanghao
					}
				}
			}
		}
		if (setContenBuf.length() <1){
			//需要更新的数据为空，直接返回。
			return "";
		}
		setContenBuf.deleteCharAt(setContenBuf.length()-1);
		newSqlBuf.append(setContenBuf.toString());
		newSqlBuf.append(updateSql.substring(updateSql.indexOf(" WHERE "),updateSql.length()));

		log.info("update SQL ="+newSqlBuf.toString());
		return newSqlBuf.toString();
		
	}
	
	/**
	 * 根据字段的数据类型，自动转换为对应的sql语法。
	 * @param fieldValue
	 * @param fieldDataType
	 * @return
	 */
	private static String convertFieldValueFormat(String fieldValue,String fieldDataType) {
		String newValue = "";
		if (fieldDataType == null ) 
			fieldDataType ="";
		try{
			if (fieldDataType.startsWith("String")) {
				newValue = "'" + handleSQLSpecialStr(fieldValue) + "'";
			} else if (fieldDataType.startsWith("Integer")) {
				if (!fieldValue.equals(""))
					newValue = String.valueOf(Integer.parseInt(fieldValue));
				else
					newValue = "null";
			} else if (fieldDataType.startsWith("Number")) {
				if (!fieldValue.equals(""))
					newValue = String.valueOf(Double.parseDouble(fieldValue));
				else
					newValue = "null";
			} else if (fieldDataType.startsWith("Date")) {
				if (!fieldValue.equals(""))
					newValue = "to_date('" + fieldValue + "','yyyy-mm-dd')";
				else
					newValue = "null";
			} else {
				newValue = "'" + handleSQLSpecialStr(fieldValue) + "'";
			}
		}catch(Exception ex){
			ex.printStackTrace();
			newValue = "'" + fieldValue + "'";
		}
		return newValue;
	}
	
	/**
	 * 处理字符串中的一些Sql敏感字符,如单引号等。
	 * @param inStr
	 * @return
	 */
	private static String handleSQLSpecialStr(String inStr){
		String resultStr = "";
		//处理单引号
		resultStr = inStr.replaceAll("'", "''");
		return resultStr;
	}

	public static String replaceText(String sql,String value,String newValue){
		value=SQL_INDEX+ value.trim().toUpperCase()+ SQL_INDEX;
		return sql.replaceAll(value, newValue);
	}
	
	@SuppressWarnings("unchecked")
	private static String getFieldValue(Node elementDefine,Map mapValue){
		String result=null;
		try {
			String eleId=elementDefine.valueOf("@Id");
			String eleType=elementDefine.valueOf("@DataType");
			String eleDefaultValue=elementDefine.valueOf("@DefaultValue");
			if (mapValue.get(eleId)!=null){
				Object[] obj=(Object[])mapValue.get(eleId);
				result=obj[0].toString();
			}
			if (result!=null){
				if (eleType.startsWith("String")){
					result="'" + result + "'";
				}else if (eleType.startsWith("Integer")){
					if (!result.equals(""))
						result=String.valueOf(Integer.parseInt(result));
					else
						result="null";
				}else if  (eleType.startsWith("Number")){
					if (!result.equals(""))
						result=String.valueOf(Double.parseDouble(result));
					else
						result="null";
				}else if  (eleType.startsWith("Date")){
					if (!result.equals(""))
						result="to_date('" + result + "','yyyy-mm-dd')";
					else
						result="null";
				}else{
					result="'" + result + "'";
				}
			}else{
				if (eleDefaultValue!=null && !eleDefaultValue.equals(""))
					result=eleDefaultValue;
			}
		} catch (Exception e) {
			// TODO: handle exception
		}
		return result;
	}
	
	private static String removeNullUpdateField(String sql){
		String result=sql;
		//从,开始 一个以上字符 =  一个以上字符   #结束  （\\w+表示一个以上字符a-zA-Z_0-9]。
		Pattern p = Pattern.compile ("\\,\\s*\\w+\\s*\\=\\s*\\#\\w+\\#");
		Matcher m = p.matcher (sql);
		result=m.replaceAll(" ");
		
	
		p = Pattern.compile ("\\#\\w+\\#");
		m = p.matcher (result);
		while (m.find()){

			Pattern p2 = Pattern.compile ("\\w+\\s*\\=\\s*\\#\\w+\\#\\s*\\,");
//			Pattern p2 = Pattern.compile ("\\w+\\s*\\=\\s*\\#\\w+\\#");
			Matcher m2 = p2.matcher (result);
			result=m2.replaceAll(" ");
			m.reset();
			m = p.matcher (result);
		}
		return result;
	}
	
	public static void main(String[] argv){
		String temp = "UPDATE  BM_YWBLLCD   SET BH= #BH#, DJ_RQ= #DJ_RQ# , FJ_BMPJ_FHRQ= #FJ_BMPJ_FHRQ# , FJ_BMPJ_ZSBM= #FJ_BMPJ_ZSBM# , FJ_BMPJ_ZSRQ= #FJ_BMPJ_ZSRQ# , FJ_DWSQ_FHRQ= #FJ_DWSQ_FHRQ# , FJ_DWSQ_ZSBM= #FJ_DWSQ_ZSBM# , FJ_DWSQ_ZSRQ= #FJ_DWSQ_ZSRQ# , FJ_FYJ_FHRQ= #FJ_FYJ_FHRQ# , FJ_FYJ_ZSBM= #FJ_FYJ_ZSBM# , FJ_FYJ_ZSRQ= #FJ_FYJ_ZSRQ# , JZMJ= #JZMJ# , JZPZ_RQ= #JZPZ_RQ# , NBYJ= #NBYJ# , QSXZ= #QSXZ# , RQ= #RQ# , SBZF_RQ= #SBZF_RQ# , TC_RQ= #TC_RQ# , TCRR= #TCRR# , XMMC= #XMMC# , YDDW= #YDDW# , YDMJ= #YDMJ# , YSYJ= #YSYJ# , ZDWZ= #ZDWZ# , ZFPZ_RQ= #ZFPZ_RQ#  WHERE   LCD_ID ='0121cdf7be8021cdf7be000a40288162'@![SEPARATOR]!@";
		temp=temp+"   UPDATE BM_RMZFSQSPTDFW SET XMMC= #XMMC# ,YDMJ= #YDMJ# WHERE LCD_ID ='0121cdf7be8021cdf7be000a40288162'";
		String sqlWorkBuf = temp;
		System.out.println(sqlWorkBuf.indexOf("@![SEPARATOR]!@"));
		while(sqlWorkBuf.indexOf(StaticParamHelper.SQL_SEPARATOR)>=0){
			String kkl = sqlWorkBuf.substring(0,temp.indexOf(StaticParamHelper.SQL_SEPARATOR));
			System.out.println(kkl);
			sqlWorkBuf = sqlWorkBuf.substring(temp.indexOf(StaticParamHelper.SQL_SEPARATOR)+StaticParamHelper.SQL_SEPARATOR.length(), sqlWorkBuf.length());
		}
	}
}
