package com.gtis.plat.form;


import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import com.gtis.plat.vo.PfFormDefineVo;

public class FormModel {
	
	Document definitionXml;
	Document definitionShell;
	PfFormDefineVo formDefineVo;
	private static final org.apache.commons.logging.Log log = LogFactory
	.getLog(FormModel.class);
	public Document getDefinitionXml() {
		return definitionXml;
	}

	public void setDefinitionXml(Document definitionXml) {
		this.definitionXml = definitionXml;
	}

	public Document getDefinitionShell() {
		return definitionShell;
	}

	public void setDefinitionShell(Document definitionShell) {
		this.definitionShell = definitionShell;
	}

	public PfFormDefineVo getFormDefineVo() {
		return formDefineVo;
	}

	public void setFormDefineVo(PfFormDefineVo formDefineVo) {
		this.formDefineVo = formDefineVo;
	}

	public void parseVo(PfFormDefineVo vo){
		this.formDefineVo=vo;
		
		String formXml = vo.getDefinitionXml();
		if (formXml != null && !formXml.equals("")) {
			try {
				this.definitionXml = DocumentHelper.parseText(formXml);
			} catch (Exception e) {
				log.error("---解析工作流XML失败---",e);
			}
		}
		
		String shellXml = vo.getDefinitionShell();
		if (shellXml != null && !shellXml.equals("")) {
			try {
				this.definitionShell = DocumentHelper.parseText(shellXml);
			} catch (Exception e) {
				log.error("---解析工作流脚本---",e);
			}
		}
	}
}
