package com.gtis.plat.datasource;

import java.util.HashMap;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.sql.DataSource;

import org.apache.commons.dbcp.BasicDataSource;

import com.gtis.plat.vo.PfBusinessVo;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BusinessDataSource {

    private static String ORACLE_CLASSNAME = "oracle.jdbc.driver.OracleDriver";
    private static String SQL_CLASSNAME = "oracle.jdbc.driver.OracleDriver";

    public static HashMap<String, DataSource> businessDsMap;
    static Log log = LogFactory.getLog(BusinessDataSource.class);

    public static DataSource getDataSourceByBusiness(PfBusinessVo businessVo) {
        DataSource ds = getDataSourceFromMap(businessVo.getBusinessId());
        if (ds == null) {
            ds = createDataSource(businessVo);
        }
        return ds;
    }

    private static DataSource getDataSourceFromMap(String businessId) {
        if (businessDsMap == null)
            businessDsMap = new HashMap<String, DataSource>();
        return businessDsMap.get(businessId);
    }

    private static DataSource createDataSource(PfBusinessVo businessVo) {
        DataSource ds = null;
        try {
            if (businessVo.getDsUrl().indexOf("java:/comp/env") > -1) {
                Context initContext = new InitialContext();
                Context envContext = (Context) initContext.lookup("java:/comp/env");
                ds = (DataSource) envContext.lookup(businessVo.getDsUrl().replaceAll("java:/comp/env/", ""));
            } else {
                if (businessVo.getDsType().startsWith("SQL")) {
                    ds = createSqlDataSource(businessVo);
                } else {
                    ds = createOracleDataSource(businessVo);
                }
            }
            businessDsMap.put(businessVo.getBusinessId(), ds);
        } catch (Exception ex) {
            log.error("", ex.getCause());
        }
        return ds;
    }

    private static DataSource createOracleDataSource(PfBusinessVo businessVo) {
        BasicDataSource ds = new BasicDataSource();
        ds.setDriverClassName(ORACLE_CLASSNAME);
        ds.setUrl(businessVo.getDsUrl());
        ds.setUsername(businessVo.getDsUser());
        ds.setPassword(businessVo.getDsUserPass());
        businessDsMap.put(businessVo.getBusinessId(), ds);
        return ds;
    }

    private static DataSource createSqlDataSource(PfBusinessVo businessVo) {
        BasicDataSource ds = new BasicDataSource();
        ds.setDriverClassName(SQL_CLASSNAME);
        ds.setUrl(businessVo.getDsUrl());
        ds.setUsername(businessVo.getDsUser());
        ds.setPassword(businessVo.getDsUserPass());
        businessDsMap.put(businessVo.getBusinessId(), ds);
        return ds;
    }
}
