package com.gtis.plat.dao;

import com.gtis.plat.vo.PfUserVo;
import com.gtis.plat.vo.PfWorkFlowInstanceRelVo;
import com.gtis.plat.vo.PfWorkFlowInstanceVo;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.orm.ibatis.support.SqlMapClientDaoSupport;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SysWorkFlowInstanceRelDao extends SqlMapClientDaoSupport {
	private static final Log log = LogFactory.getLog(SysWorkFlowInstanceRelDao.class);

    /**
     *   获得任务关联的其他项目列表
     * @param workflowIntanceId
     * @return
     */
	public List<PfWorkFlowInstanceVo> getWorkFlowRelList(String workflowIntanceId) {
        return super.getSqlMapClientTemplate().queryForList("getWorkFlowRelList", workflowIntanceId);
	}

    /**
     * 插入项目的管理关系
     * @param workFlowInstanceRelVo
     */
    public void insertWorkFlowRel(PfWorkFlowInstanceRelVo workFlowInstanceRelVo){
        super.getSqlMapClientTemplate().insert("insertWorkFlowRel", workFlowInstanceRelVo);
    }

    /**
     * 删除管理关系
     * @param workFlowInstanceRelVo
     */
    public void deleteWorkFlowRel(PfWorkFlowInstanceRelVo workFlowInstanceRelVo){
        super.getSqlMapClientTemplate().delete("deleteWorkFlowRel", workFlowInstanceRelVo);
    }
}
