package com.gtis.plat.dao;

import com.gtis.plat.vo.PfUserVo;
import com.gtis.plat.vo.PfWorkFlowInstanceVo;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.orm.ibatis.support.SqlMapClientDaoSupport;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SysWorkFlowInstanceDao extends SqlMapClientDaoSupport {
	private static final Log log = LogFactory.getLog(SysWorkFlowInstanceDao.class);
	/**
	 * 更新实例备注
	 * 
	 * @param intanceVo
	 */
	public void updateWorkFlowInstanceRemark(PfWorkFlowInstanceVo intanceVo) {
		super.getSqlMapClientTemplate().update("updateWorkFlowInstanceRemark",
				intanceVo);
	}

	/**
	 * 获取流程实例
	 * @return
	 */
	public PfWorkFlowInstanceVo getWorkflowInstance(String workflowIntanceId) {
		return (PfWorkFlowInstanceVo) super.getSqlMapClientTemplate()
				.queryForObject("getWorkflowInstance", workflowIntanceId);
	}
	
	public PfWorkFlowInstanceVo getWorkflowInstanceByProId(String proId) {
		return (PfWorkFlowInstanceVo) super.getSqlMapClientTemplate()
				.queryForObject("getWorkflowInstanceByProId", proId);
	}

	public PfWorkFlowInstanceVo getWorkflowInstanceByMonitor(String monitorId) {
		return (PfWorkFlowInstanceVo) super.getSqlMapClientTemplate()
				.queryForObject("getWorkflowInstanceByMonitor", monitorId);
	}

	/**
	 * 获取流程定义的描述XML
	 * @return
	 */
    @Cacheable(value="WorkFlowInstanceCache",key="#workflowIntanceId+'WorkflowInstanceXmlById'")
	public String getWorkflowInstanceXml(String workflowIntanceId) {
		return super.getSqlMapClientTemplate().queryForObject(
				"getWorkflowInstanceXml", workflowIntanceId).toString();
	}

	/**
	 * 创建工作流实例
	 * 
	 * @param intanceVo
	 */
	public void createWorkFlowIntance(PfWorkFlowInstanceVo intanceVo) {
		super.getSqlMapClientTemplate().insert("createWorkFlowIntance",
				intanceVo);
	}

	/**
	 * 更新工作流实例状态
	 */
    public void updateWorkFlowIntanceStadus(PfWorkFlowInstanceVo intanceVo){
        super.getSqlMapClientTemplate().update("updateWorkFlowIntanceStadus", intanceVo);
    }
	
	/**
	 * 删除工作流实例
	 */
	public void deleteWorkFlowIntance(String workflowIntanceId) {
		super.getSqlMapClientTemplate().delete("deleteWorkFlowIntance",workflowIntanceId);
	}
	
	/**
	 * 计算工作日
	 */
	public void updateWorkFlowHandleDay() {
		log.debug("--------开始计算工作流工作日------");
		super.getSqlMapClientTemplate().update("PF_HANDLEDAY_CAL");
	}
	//zzz
	public List<HashMap> getWorkflowStatusList(HashMap<String,String> map){
		List<HashMap>  resultList= super.getSqlMapClientTemplate().queryForList("getWorkflowStatusList", map);
		return resultList;
				
	}
	
//	public List<PfWorkFlowInstanceStatResultVo> getWorkflowInstanceByWFD_ID(HashMap<String,String> map){
//		
//		return super.getSqlMapClientTemplate().queryForList(
//				"getWorkflowInstanceByWFD_ID",map);
//	}
	public List<HashMap> getWorkflowActivityStatusList(HashMap<String,String> map){
		
		return (List<HashMap>) super.getSqlMapClientTemplate().queryForList(
				"getWorkflowActivityStatusList",map);
	}
	
	public void updateWorkFlowIntanceName(PfWorkFlowInstanceVo intanceVo){
        super.getSqlMapClientTemplate().update("updateWorkFlowIntanceName", intanceVo);
    }
	


    /**
     * 获取待办任务个数，通过多个userid（可能存在代理任务），jibo修改 2012.02.04
     * 如果userid为空，就放回所有的任务，管理员用
     * @param map
     * @return
     */
	public String getTaskCount(HashMap<String,String> map){
		Object result=super.getSqlMapClientTemplate().queryForObject("getTaskList_COUNT", map);
		return result.toString();
	}

    /**
     * 统计全部任务情况，返回为一个map对象
     * @param paraMap
     * @return
     */
    public Map<String,Integer> statTaskCountMap(HashMap<String,String> paraMap){
        Map<String,Integer>  taskCountMap= new HashMap<String,Integer>();
      	List<Map> resultList = super.getSqlMapClientTemplate().queryForList("statTaskCountMap",paraMap);
        if (resultList != null){
            for (int i=0;i<resultList.size();i++){
                Map rowMap = resultList.get(i);
                String userId =(String) rowMap.get("USER_ID");
                BigDecimal taskCount =   (BigDecimal) rowMap.get("TASK_COUNT");
                taskCountMap.put(userId,new Integer(taskCount.intValue()));
            }
        }
        return  taskCountMap;
    }

    /**
     * 统计工作流指定工作流的任务数
     * @param wiid
     * @return
     */
    public int statTaskCountByWiid(String wiid){
        return super.getSqlMapClientTemplate().queryForList("statTaskCountByWiid",wiid).size();
    }

	//获取已办任务个数(本周)
	public String getTaskOverCount(HashMap<String,String> map){
		
		return "" + super.getSqlMapClientTemplate().queryForObject("statTaskOvercount", map);
	}
	
	//获取超期任务个数
//	public String getTaskExtendedCount(HashMap<String,String> map){
//		return (String)super.getSqlMapClientTemplate().queryForObject("statTaskExtendedcount", map);
//	}
	
	public String getWorkFlowVals(String workflowIntanceId) {
		Object obj=super.getSqlMapClientTemplate().queryForObject("getWorkFlowGobalVals",
				workflowIntanceId);
		if (obj!=null)
			return obj.toString();
		else
			return "";
	}
	
	public void updateWorkFlowVals(String workflowIntanceId,String vals) {
		HashMap<String,String> map=new HashMap<String, String>();
		map.put("VALS", vals);
		map.put("WORKFLOW_INSTANCE_ID", workflowIntanceId);
		super.getSqlMapClientTemplate().update("updateWorkFlowGobalVals",
				map);
	}
	

	/**
	 * 根据查询条件查询工作流实例
	 * @param workFlowDefineId
	 * @param fromDate
	 * @param toDate
	 * @return
	 */
    public List<PfWorkFlowInstanceVo> getWorkFlowInstanceList(String workFlowDefineId,String fromDate,String toDate) {
    	Map paraMap = new HashMap();
    	if (workFlowDefineId != null && workFlowDefineId.trim().length()>0){
    		paraMap.put("WORKFLOW_DEFINITION_ID", workFlowDefineId);
    	}
    	if (fromDate != null && fromDate.length() > 0){
    		paraMap.put("FROM_DATE", fromDate);
    	}
    	if (toDate != null && fromDate.trim().length() > 0){
    		paraMap.put("TO_DATE", toDate);
    	}
    	return super.getSqlMapClientTemplate().queryForList("getWorkFlowInstanceList",paraMap);
    }

    public PfUserVo getWorkFlowLastUser(String wiid){
        return (PfUserVo)super.getSqlMapClientTemplate().queryForObject("getWorkFlowLastUser",wiid);
    }

    public List<PfWorkFlowInstanceVo> getWorkFlowsInstanceByDefine(String wdId,int state){
        Map paraMap = new HashMap();
        paraMap.put("wdId",wdId);
        paraMap.put("state",state);
        return (List<PfWorkFlowInstanceVo>)super.getSqlMapClientTemplate().queryForObject("getWorkFlowsInstanceByDefine",paraMap);
    }


    public void UpdateWorkFlowInstanceMonitor(String wiid,String monitorId){
        Map paraMap = new HashMap();
        paraMap.put("WORKFLOW_INSTANCE_ID",wiid);
        paraMap.put("MONITOR_ID",monitorId);
        super.getSqlMapClientTemplate().update("UpdateWorkFlowInstanceMonitor",paraMap);
    }

    /**
     * 更新工作流紧急程度
     *
     * @param intanceVo
     */
    public void updateWorkFlowIntancePriority(PfWorkFlowInstanceVo intanceVo) {
        super.getSqlMapClientTemplate().update("updateWorkFlowIntancePriority",
                intanceVo);
    }

}
