package com.gtis.plat.dao;

import com.gtis.plat.vo.PfTaskVo;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.cache.annotation.Caching;
import org.springframework.orm.ibatis.support.SqlMapClientDaoSupport;

import java.util.HashMap;
import java.util.List;

/**
 * Created with IntelliJ IDEA.
 * User: jibo
 * Date: 14-2-19
 * Time: 上午6:35
 * To change this template use File | Settings | File Templates.
 */
public class SysTaskHistoryDao extends SqlMapClientDaoSupport {

    /**
     * 获取历史任务
     *
     * @param taskId
     * @return
     */
    @Cacheable(value="TaskHistoryCache",key="#taskId+'HistoryTask'")
    public PfTaskVo getHistoryTask(String taskId) {
        return (PfTaskVo) super.getSqlMapClientTemplate().queryForObject(
                "getHistoryTask", taskId);
    }

    /**
     * 根据活动获取任务
     * @param activityId
     * @return
     */
    @Cacheable(value="TaskHistoryCache",key="#activityId+'HistoryTasksListByActivity'")
    public List<PfTaskVo> getHistoryTasksListByActivity(String activityId) {
        return super.getSqlMapClientTemplate().queryForList(
                "getHistoryTaskListByActivity", activityId);
    }

    /**
     * 复制任务到任务历史表
     *
     * @param taskVo
     */
    @Caching(evict={
            @CacheEvict(value="TaskHistoryCache",key = "#taskVo.taskId + 'HistoryTask'"),
            @CacheEvict(value="TaskHistoryCache",key = "#taskVo.activityId + 'HistoryTasksListByActivity'")
    })
    public void insertTaskHistory(PfTaskVo taskVo) {
        super.getSqlMapClientTemplate().insert("insertTaskHistory", taskVo);
    }

    /**
     * 更新历史任务 意见和是否同意
     *
     * @param taskVo
     */
    @Caching(evict={
            @CacheEvict(value="TaskHistoryCache",key = "#taskVo.taskId + 'HistoryTask'"),
            @CacheEvict(value="TaskHistoryCache",key = "#taskVo.activityId + 'HistoryTasksListByActivity'")
    })
    public void updateTaskHistory(PfTaskVo taskVo) {
        super.getSqlMapClientTemplate().update("updateTaskHistory", taskVo);
    }

    @Caching(evict={
            @CacheEvict(value="TaskHistoryCache",key = "#taskVo.taskId + 'HistoryTask'"),
            @CacheEvict(value="TaskHistoryCache",key = "#taskVo.activityId + 'HistoryTasksListByActivity'")
    })
    public void deleteHistoryTask(PfTaskVo taskVo) {
        super.getSqlMapClientTemplate().delete("deleteHistoryTask", taskVo.getTaskId());
    }

}
