package com.gtis.plat.dao;

import java.util.HashMap;
import java.util.List;

import org.springframework.dao.DataAccessException;
import org.springframework.orm.ibatis.support.SqlMapClientDaoSupport;

public class SysStuffDao extends SqlMapClientDaoSupport {

	public HashMap<String,String> getStuffConfigByStuffId(String stuffConfigId){
		HashMap<String,String> stuffConfig = (HashMap<String,String>)super.getSqlMapClientTemplate().queryForObject("getStuffConfigByStuffId",stuffConfigId);
		return stuffConfig;
	}
	
//	public List<HashMap<String, String>> getFileByStuffIdProId(HashMap map) {
//		List<HashMap<String, String>> fileList = (List<HashMap<String, String>>)super
//				.getSqlMapClientTemplate().queryForList(
//						"getFileByStuffIdProId", map);
//		return fileList;
//	}
	
	public List<HashMap<String, String>> getStuffConfig() {
		List<HashMap<String, String>> stuffConfigList = (List<HashMap<String, String>>) super
				.getSqlMapClientTemplate().queryForList("getStuffConfig");
		return stuffConfigList;
	}

	public List<HashMap<String, String>> getStuffConfigByProId(String proId) {
		List<HashMap<String, String>> stuffConfigList = (List<HashMap<String, String>>) super
				.getSqlMapClientTemplate().queryForList(
						"getStuffConfigByProId", proId);
		return stuffConfigList;
	}

//	public List<HashMap<String, String>> getFileByStuffId(String stuffId) {
//		List<HashMap<String, String>> fileList = (List<HashMap<String, String>>) super
//				.getSqlMapClientTemplate().queryForList(
//						"getStuffFileByStuffConfigId", stuffId);
//		return fileList;
//	}

//	public HashMap<String, String> getFileById(String fileId) {
//		HashMap<String, String> file = (HashMap<String, String>) super
//				.getSqlMapClientTemplate().queryForObject("getStuffFileById",
//						fileId);
//		return file;
//	}

//	public HashMap<String, byte[]> getFileContentById(String fileId) {
//		HashMap<String, byte[]> file = (HashMap<String, byte[]>) super
//				.getSqlMapClientTemplate().queryForObject(
//						"getStuffContentById", fileId);
//		return file;
//	}

//	public void deleteFileById(String id) {
//		super.getSqlMapClientTemplate().delete("deleteFileById", id);
//	}

	public void deleteConfigById(String stuffId) {
		super.getSqlMapClientTemplate().delete("deleteConfigById",stuffId);
	}
	
//	public boolean insertStuffFile(HashMap stuffFile) {
//		boolean isok = true;
//		try {
//			super.getSqlMapClientTemplate()
//					.insert("insertStuffFile", stuffFile);
//		} catch (DataAccessException e) {
//			e.printStackTrace();
//			isok = false;
//		}
//		return isok;
//	}

//	public boolean updateStuffFile(HashMap stuffFile) {
//		boolean isok = true;
//		try {
//			super.getSqlMapClientTemplate()
//					.update("updateStuffFile", stuffFile);
//		} catch (DataAccessException e) {
//			e.printStackTrace();
//			isok = false;
//		}
//		return isok;
//	}
	
	public boolean insertStuffConfig(HashMap stuffConfig) {
		boolean isok = true;
		try {
			super.getSqlMapClientTemplate().insert("insertStuffConfig",stuffConfig);
		} catch (DataAccessException e) {
			e.printStackTrace();
			isok = false;
		}
		return isok;
	}
	
	public void deleteConfigByProId(String proId){
		super.getSqlMapClientTemplate().delete("deleteConfigByProId", proId);
	}
	
	public List<String> getStuffIdByProId(String proId) {
		return super.getSqlMapClientTemplate().queryForList("getStuffIdByProId",proId);
	}
	
//	public List<String> getFileIdByProId(String proId) {
//		return super.getSqlMapClientTemplate().queryForList("getFileIdByProId",proId);
//	}
	
	//<!-- 获取StuffId -->
	public String getStuffIdbyWorkflowDefinitionIdAndStuffName(String workflowDefinitionId, String stuffName){
		HashMap<String, String> map = new HashMap<String, String>();
		map.put("StuffName", stuffName);
		map.put("WorkflowDefinitionId", workflowDefinitionId);
		return (String) super.getSqlMapClientTemplate().queryForObject("getStuffIdbyWorkflowDefinitionIdAndStuffName", map);
	}
	
	//<!-- 根据ProId与StuffId获取附件List -->
//	@SuppressWarnings("unchecked")
//	public List<HashMap<String, String>> getStuffFileByProIdAndStuffId(String proid, String stuffId){
//
//		HashMap<String, String> map = new HashMap<String, String>();
//		map.put("ProId", proid);
//		map.put("StuffId", stuffId);
//		List<HashMap<String, String>> queryForList = (List<HashMap<String, String>>)super.getSqlMapClientTemplate().queryForList("getStuffFileByProIdAndStuffId", map);
//		return queryForList;
//	}
}
