package com.gtis.plat.dao;

import com.gtis.plat.vo.PfSmsVo;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpStatus;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.simple.ParameterizedRowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;

import javax.sql.DataSource;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Random;

/**
 * @(#)SysSmsDao.java 2010-4-8 11:35:22
 * Copy Right Information	: 南京国图
 * Project 					:
 * JDK version used		    : jdk1.5.0_20
 * Comments					: 短信持久层服务
 * Version					:
 * CreateAuthor             : ShiHui
 */
public class SysSmsGatewayDao {
    private static final Logger logger = LoggerFactory.getLogger(SysSmsGatewayDao.class);

    /** 短信猫系统表或短信猫日志表-数据源 */
    private SimpleJdbcTemplate jdbcTemplate;
    /** 短信短信网关表-数据源 */
    private SimpleJdbcTemplate jdbcGatewayTemplate;
    /** 插入语句 */
    private String insertSmsSQL;
    /** 发送状态查询语句 */
    private String stateSql;
    /** 用户发送短信语句 */
    private String getSmsListByUserSQL;
    /** 获得短信发送集合语句 */
    private String getSmsListSQL;
    /** 发送单位 */
    private String sendUnit;

    /**
     * 插入短信记录
     * @param sms
     * @return
     * @throws java.io.IOException
     */
    public String insertSms(PfSmsVo sms) throws IOException{
        String content = sms.getContent();
//        sms.setContent(content + " \n " + sendUnit);
        sms.setContent(content);
        sms.setSmsId(buildIndex());
        //其他短信中间件发送
        jdbcGatewayTemplate.update(insertSmsSQL,createSmsParameterSource(sms));
        sms.setSn(sms.getSmsId());
        logger.debug("insert sms ({}) success", sms);

        return sms.getSn() ;
    }

    /**                       z
     * 记录工作日志
     * @param sms
     * @return
     */
    public void insertSmsLog(PfSmsVo sms){
        final String insertLogSQL = "insert into PF_MOBILE_LOG(LOG_ID,SENDER,RECEIVE,CONTENT,TIME,NO,SN) values(:id,:sender,:receive,:content,:sendDate,:no,:sn)";
        jdbcTemplate.update(insertLogSQL,createSmsParameterSource(sms));
    }

    /**
     * 发送状态
     * @param msgNo
     * @return
     * @throws java.io.IOException
     */
    public String msgState(String msgNo) throws IOException{
        if(StringUtils.isNotBlank(stateSql)){
             String[] msg=new String[1];
            msg[0]= msgNo;
            List result= jdbcGatewayTemplate.queryForList(stateSql,msgNo);
            if (result.size()>0)
                return "1";
            else
                return "0";
        }
        return "1";
    }

    /**
     * 获得短信列表
     * @return
     */
    public List<PfSmsVo> getSmsList(){
        return jdbcGatewayTemplate.query(getSmsListSQL,new SmsRowMapper());
    }

    private MapSqlParameterSource createSmsParameterSource(PfSmsVo sms){
        Random random=new Random();
        String randomNo=String.valueOf(random.nextInt(1000));
        MapSqlParameterSource mapSqlParameterSource = new MapSqlParameterSource()
                .addValue("id",sms.getSmsId())
                .addValue("no", sms.getMobileNo())
//                .addValue("content", sms.getContent() + "--" + randomNo + "--")
                .addValue("content", sms.getContent())
                .addValue("sender",sms.getSender())
                .addValue("receive",sms.getReceive())
                .addValue("sendDate",sms.getSendDate())
                .addValue("sn",sms.getSn())
                .addValue("sendEndDate",(new Date(System.currentTimeMillis() + 24*3600*1000)))
                .addValue("requestTime", (new Timestamp(System.currentTimeMillis())));
        return mapSqlParameterSource;
    }
    
    private class SmsRowMapper implements ParameterizedRowMapper<PfSmsVo> {
        public PfSmsVo mapRow(ResultSet rs, int rownum) throws SQLException {
            PfSmsVo sms = new PfSmsVo();

            sms.setSmsId(rs.getString("SMSINDEX"));
            sms.setMobileNo(rs.getString("MOBILENO"));
            sms.setContent(rs.getString("MSGTEXT"));
            sms.setSender(rs.getString("USERNAME"));
            sms.setSendDate(rs.getDate("DATEANDTIME"));
            
            return sms;
        }
    }

    private static int index = 1;
    public static String buildIndex(){
        Calendar calCurrent=Calendar.getInstance();
        int intDay=calCurrent.get(Calendar.DATE);
        int intMonth=calCurrent.get(Calendar.MONTH)+1;
        int intYear=calCurrent.get(Calendar.YEAR);
        String now = "" + intYear + intMonth + intDay;
        now=Integer.toHexString(Integer.parseInt(now) + Integer.parseInt(RandomStringUtils.randomNumeric(5)));
        if (index>9000) index=1;
        now += index;
        index++;
        return now;
    }

    public void setJdbcTemplate(DataSource dataSource) {
        this.jdbcTemplate = new SimpleJdbcTemplate(dataSource);
    }

    public void setInsertSmsSQL(String insertSmsSQL) {
        this.insertSmsSQL = insertSmsSQL;
    }

    public void setGetSmsListSQL(String getSmsListSQL) {
        this.getSmsListSQL = getSmsListSQL;
    }

    public void setGetSmsListByUserSQL(String getSmsListByUserSQL) {
        this.getSmsListByUserSQL = getSmsListByUserSQL;
    }

    public void setStateSql(String stateSql) {
        this.stateSql = stateSql;
    }

    public void setSendUnit(String sendUnit) {
        this.sendUnit = sendUnit;
    }

    public void setJdbcGatewayTemplate(DataSource dataSource) {
        this.jdbcGatewayTemplate = new SimpleJdbcTemplate(dataSource);
    }
}
