package com.gtis.plat.dao;

import com.gtis.plat.vo.PfSignVo;
import org.apache.commons.collections.map.HashedMap;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.cache.annotation.Caching;
import org.springframework.orm.ibatis.support.SqlMapClientDaoSupport;

import java.util.Date;
import java.util.HashMap;
import java.util.List;


public class SysSignDAO extends SqlMapClientDaoSupport {

    /**
     * 获得签名
     *
     * @param signId   签名主键
     * @param signKey  签名标识符
     * @param signName 用户名
     * @param signType 签名类型
     * @param proId
     * @param userId   用户主键
     * @return
     */
    public List<PfSignVo> getSignList(String signId, String signKey, String signName, String signType, String proId, String userId) {
        PfSignVo signVo = new PfSignVo();
        signVo.setSignId(signId);
        signVo.setSignKey(signKey);
        signVo.setSignName(signName);
        signVo.setSignType(signType);
        signVo.setProId(proId);
        signVo.setUserId(userId);
        return (List<PfSignVo>) super.getSqlMapClientTemplate().queryForList("getSignList", signVo);
    }

    @Cacheable(value="SignCache",key="#signId+'SignById'")
    public PfSignVo getSignNoImage(String signId) {
        return (PfSignVo) super.getSqlMapClientTemplate().queryForObject("getSignNoImage", signId);
    }

    /**
     * 从签名表中读取签名图片
     * @param signId
     * @return
     */
    @Cacheable(value="SignCache",key="#signId+'SignImageById'")
    public PfSignVo getSignImage(String signId) {
        return (PfSignVo) super.getSqlMapClientTemplate().queryForObject("getSignImage", signId);
    }

    /**
     * 从用户表中读取预设签名图片
     * @param signId
     * @return
     */
    @Cacheable(value="SignCache",key="#signId+'UserSignImageById'")
    public PfSignVo getUserSignImage(String signId) {
        return (PfSignVo) super.getSqlMapClientTemplate().queryForObject("getUserSignImage", signId);
    }

    /**
     * 插入签名图片此时图片字段为null
     * @param signVo
     * @return
     */
    public Object insertSign(PfSignVo signVo) {
        return super.getSqlMapClientTemplate().insert("insertSign", signVo);
    }

    /**
     * 更新签名的属性，不更新图形
     * @param signVo
     * @return
     */
    @Caching(evict={
            @CacheEvict(value="SignCache",key = "#signVo.signId + 'SignImageById'"),
            @CacheEvict(value="SignCache",key = "#signVo.signId + 'SignById'")
    })
    public Object updateSign(PfSignVo signVo) {
        return super.getSqlMapClientTemplate().insert("updateSign", signVo);
    }

    /**
     * 更新签名图片，设置图片字段为null
     * @param signId
     * @return
     */
    @Caching(evict={
            @CacheEvict(value="SignCache",key = "#signId + 'SignImageById'"),
            @CacheEvict(value="SignCache",key = "#signId + 'SignById'")
    })
    public Object updateSignNullPic(String signId) {
        return super.getSqlMapClientTemplate().insert("updateSignNullPic", signId);
    }

    /**
     * 更新签名图片，设置图片字段为empty_blob()
     * @param signId
     * @return
     */
    @Caching(evict={
            @CacheEvict(value="SignCache",key = "#signId + 'SignImageById'"),
            @CacheEvict(value="SignCache",key = "#signId + 'SignById'")
    })
    public Object updateSignEmptyPic(String signId) {
        return super.getSqlMapClientTemplate().insert("updateSignEmptyPic", signId);
    }

    @Caching(evict={
            @CacheEvict(value="SignCache",key = "#signVo.signId + 'SignImageById'"),
            @CacheEvict(value="SignCache",key = "#signVo.signId + 'SignById'")
    })
    public Object updateSignPic(PfSignVo signVo) {
        return super.getSqlMapClientTemplate().insert("updateSignPic", signVo);
    }
    /**
     * 删除签名
     * @param signId
     * @return
     */
    @Caching(evict={
            @CacheEvict(value="SignCache",key = "#signId + 'SignImageById'"),
            @CacheEvict(value="SignCache",key = "#signId + 'SignById'")
    })
    public Object deleteSign(String signId) {
        return super.getSqlMapClientTemplate().delete("deleteSign", signId);
    }

    /**
     * 按某字段排序获得签名
     *
     * @param map   查询条件
     * @return
     */
    public List<PfSignVo> getSignListOrderfield(HashMap map) {
        return (List<PfSignVo>) super.getSqlMapClientTemplate().queryForList("getSignListOrderfield", map);
    }
}