package com.gtis.plat.dao;

import java.util.HashMap;
import java.util.List;
import org.springframework.orm.ibatis.support.SqlMapClientDaoSupport;
import com.gtis.plat.vo.EcExceptionVo;

public class SysExceptionDAO extends SqlMapClientDaoSupport {
	public List<EcExceptionVo> getEcExceptionVoList() {
		return super.getSqlMapClientTemplate().queryForList(
			"getEcExceptionVoList");
	}
	
	/**
	 * 获得活动异常信息
	 * @param workflowInstanceId
	 * @return
	 */
	public List<HashMap> getActivityExceptionList(String workflowInstanceId){
		return super.getSqlMapClientTemplate().queryForList("getActivityExceptionList",workflowInstanceId);
	}
	
	/**
	 * 获得异常列表
	 */
	public List<HashMap> getEcExceptionList(HashMap paramsMap){
		return super.getSqlMapClientTemplate().queryForList("getEcExceptionList",paramsMap);
	}
	
	//根据instanceID获取EXCEPTION信息
	public List<EcExceptionVo>getEcExceptionByInstanceId(String instanceId){
		return super.getSqlMapClientTemplate().queryForList("getEcExceptionByInstanceId", instanceId);
	};
	//保存异常信息
	public void saveException(EcExceptionVo exception)
	{
		super.getSqlMapClientTemplate().insert("saveEcExceptionVo", exception);
	}
	//更新异常信息
	public void updateException(EcExceptionVo exception){
		HashMap hashmap=new HashMap();
		hashmap.put("DESC_XML",exception.getDescXML());
		hashmap.put("EXCEPTION_REC_TIME",exception.getExceptionRecTime());
		hashmap.put("EXCEPTION_ID",exception.getExceptionId());
		super.getSqlMapClientTemplate().update("updateEcExceptionVo", hashmap);
	};
	//根据activityID获取EXCEPTION信息
	public List<EcExceptionVo>getEcExceptionByActivityId(String activityId){
		return super.getSqlMapClientTemplate().queryForList("getEcExceptionByActivityId", activityId);
	};
	
	//根据人员统计
	public List<HashMap> statUserException(HashMap map){
		return super.getSqlMapClientTemplate().queryForList("statUserException",map);
	}
	
	//根据部门 统计
	public List<HashMap> statOrganException(HashMap map){
		return super.getSqlMapClientTemplate().queryForList("statOrganException",map);
	}
	//查询所有部门ID 和部门NAME
	public List<HashMap> queryOrgan(){
		return super.getSqlMapClientTemplate().queryForList("queryOrgan");
	}
	//统计详细
	public List<HashMap> getDetailStat(HashMap condition){
		return super.getSqlMapClientTemplate().queryForList("getDetailStat",condition);
	}
	
	/**
	 * 删除异常
	 * @param exceptionId 异常Id
	 */
	public void updateExceptionStatus(HashMap statusMap){
		super.getSqlMapClientTemplate().update("updateExceptionStatus",statusMap);
	}
}
