package com.gtis.plat.dao;

import com.gtis.plat.vo.EcExceptionVo;
import org.apache.commons.lang.StringUtils;
import org.springframework.orm.ibatis.support.SqlMapClientDaoSupport;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by IntelliJ IDEA.
 * User: Administrator
 * Date: 12-7-12
 * Time: 上午10:57
 * To change this template use File | Settings | File Templates.
 */
public class SysDzjcDAO extends SqlMapClientDaoSupport {

    public List<Map> QueryDZJCProjectList(Map<String,Object> paramMap,int startNum,int endNum){
        if (paramMap!=null && startNum>-1 && endNum>0){
            paramMap.put("startNum", String.valueOf(startNum));
            paramMap.put("endNum",String.valueOf(endNum));
        }
        return super.getSqlMapClientTemplate().queryForList("QueryDZJCProjectList", paramMap);
    }

    public int QueryDZJCProjectListCount(Map<String,Object> paramMap){
        return Integer.parseInt(super.getSqlMapClientTemplate().queryForObject("QueryDZJCProjectListCount", paramMap).toString());
    }
    
    public List<EcExceptionVo> QueryExceptionList(String wiid){
        return super.getSqlMapClientTemplate().queryForList("QueryExceptionList");
    }

    public List<Map> QueryRiskList(Map<String,Object> paramMap,int startNum,int endNum){
        if (paramMap!=null && startNum>-1 && endNum>0){
            paramMap.put("startNum", String.valueOf(startNum));
            paramMap.put("endNum",String.valueOf(endNum));
        }
        return super.getSqlMapClientTemplate().queryForList("QueryRiskList",paramMap);
    }

    public int QueryRiskListCount(Map<String,Object> paramMap){
        return Integer.parseInt(super.getSqlMapClientTemplate().queryForObject("QueryRiskListCount", paramMap).toString());
    }

    public List<Map> QueryUserList(Map<String,Object> paramMap,int startNum,int endNum){
        if (paramMap!=null && startNum>-1 && endNum>0){
            paramMap.put("startNum", String.valueOf(startNum));
            paramMap.put("endNum",String.valueOf(endNum));
        }
        return super.getSqlMapClientTemplate().queryForList("QueryUserList",paramMap);
    }

    public int QueryUserListCount(Map<String,Object> paramMap){
        return Integer.parseInt(super.getSqlMapClientTemplate().queryForObject("QueryUserListCount", paramMap).toString());
    }

    public List<Map> QueryOrganList(Map<String,Object> paramMap,int startNum,int endNum){
        if (paramMap!=null && startNum>-1 && endNum>0){
            paramMap.put("startNum", String.valueOf(startNum));
            paramMap.put("endNum",String.valueOf(endNum));
        }
        return super.getSqlMapClientTemplate().queryForList("QueryOrganList",paramMap);
    }

    public int QueryOrganListCount(Map<String,Object> paramMap){
        return Integer.parseInt(super.getSqlMapClientTemplate().queryForObject("QueryOrganListCount", paramMap).toString());
    }

    public Map<String,String> StatUserDZJC(String userId,Date beginDate,Date endDate){
        Map<String,String> result=new HashMap<String, String>();
        Map<String,Object> paramMap=new HashMap<String, Object>();
        paramMap.put("USER_ID", userId);
        paramMap.put("beginDate",beginDate);
        paramMap.put("endDate",endDate);
        List<Map> queryResult= super.getSqlMapClientTemplate().queryForList("StatUserDZJC",paramMap);
        for(Map resultMap:queryResult){
            if (resultMap.get("EXCEPTION_TYPE")!=null && StringUtils.isNotBlank(resultMap.get("EXCEPTION_TYPE").toString()))
                result.put(resultMap.get("EXCEPTION_TYPE").toString(),resultMap.get("COUNT").toString());
            else
                result.put("ALL",resultMap.get("COUNT").toString());
        }
        return result;
    }

    public Map<String,String> StatOrganDZJC(String organId,Date beginDate,Date endDate){
        Map<String,String> result=new HashMap<String, String>();
        Map<String,Object> paramMap=new HashMap<String, Object>();
        paramMap.put("ORGAN_ID", organId);
        paramMap.put("beginDate",beginDate);
        paramMap.put("endDate",endDate);
        List<Map> queryResult= super.getSqlMapClientTemplate().queryForList("StatOrganDZJC",paramMap);
        for(Map resultMap:queryResult){
            if (resultMap.get("EXCEPTION_TYPE")!=null && StringUtils.isNotBlank(resultMap.get("EXCEPTION_TYPE").toString()))
                result.put(resultMap.get("EXCEPTION_TYPE").toString(),resultMap.get("COUNT").toString());
            else
                result.put("ALL",resultMap.get("COUNT").toString());
        }
        return result;
    }

    public int QuerySuperVisorCount(String userId,Date beginDate,Date endDate){
        Map<String,String> result=new HashMap<String, String>();
        Map<String,Object> paramMap=new HashMap<String, Object>();
        paramMap.put("USER_ID", userId);
        paramMap.put("beginDate",beginDate);
        paramMap.put("endDate",endDate);
        return Integer.parseInt(super.getSqlMapClientTemplate().queryForObject("QuerySuperVisorCount", paramMap).toString());
    }

    public int QueryRiskCount(String userId,Date beginDate,Date endDate){
        Map<String,String> result=new HashMap<String, String>();
        Map<String,Object> paramMap=new HashMap<String, Object>();
        paramMap.put("USER_ID", userId);
        paramMap.put("beginDate",beginDate);
        paramMap.put("endDate",endDate);
        return Integer.parseInt(super.getSqlMapClientTemplate().queryForObject("QueryRiskCount", paramMap).toString());
    }

    public int QuerySuperVisorOrganCount(String organId,Date beginDate,Date endDate){
        Map<String,String> result=new HashMap<String, String>();
        Map<String,Object> paramMap=new HashMap<String, Object>();
        paramMap.put("ORGAN_ID", organId);
        paramMap.put("beginDate",beginDate);
        paramMap.put("endDate",endDate);
        return Integer.parseInt(super.getSqlMapClientTemplate().queryForObject("QuerySuperVisorOrganCount", paramMap).toString());
    }

    public int QueryRiskOrganCount(String organId,Date beginDate,Date endDate){
        Map<String,String> result=new HashMap<String, String>();
        Map<String,Object> paramMap=new HashMap<String, Object>();
        paramMap.put("ORGAN_ID", organId);
        paramMap.put("beginDate",beginDate);
        paramMap.put("endDate",endDate);
        return Integer.parseInt(super.getSqlMapClientTemplate().queryForObject("QueryRiskOrganCount", paramMap).toString());
    }
}
