package com.gtis.plat.dao;

import java.util.HashMap;
import java.util.List;

import org.springframework.orm.ibatis.support.SqlMapClientDaoSupport;

import com.gtis.plat.vo.PfDictionaryVo;

public class SysDictionaryDao  extends SqlMapClientDaoSupport {
	
	/**
	根据分类代码获取字典表中字典表中类型为参数节点的参数值列表
	*/
	public List<PfDictionaryVo> getLeafParamListByClassCode(String classCode){
		return  super.getSqlMapClientTemplate().queryForList("getLeafParamListByClassCode",classCode);
	}
	
	/**
	根据classCode获取字典表中的参数值
	*/
	public String getParamValueByClassCode (String classCode){
		
		return  (String)super.getSqlMapClientTemplate().queryForObject("getParamValueByClassCode",classCode);
	}

	/**
	 * 根据classCode设置字典表中的参数值
	 */
	@SuppressWarnings("unchecked")
	public void updateParamValueByClassCode(HashMap paraMap){
		super.getSqlMapClientTemplate().update("updateParamValueByClassCode",paraMap);
	}
}
