package com.gtis.plat.dao;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

import org.apache.commons.lang.StringUtils;
import org.springframework.orm.ibatis.support.SqlMapClientDaoSupport;

/**
 * @文件名 SjdDaoImpl.java
 * @作者 卢向伟
 * @创建日期 2013-1-7
 * @创建时间 上午8:51:21 
 * @版本号 V 1.0
 */
public class SjdDaoImpl extends SqlMapClientDaoSupport implements BaseDao {
	private String selectIbatisName = "get_PF_SJD";
	private String insertIbatisName = "insert_PF_SJD";
	private String updateIbatisName = "update_PF_SJD";
	private String deleteIbatisName = "delete_PF_SJD";
	private String mainIdField = "SJDID";
	private String errorStr = "******************************************\n" +
			"********信息错误，没有传递相关Ibatis所需要的表名称！*********\n" +
			"***********************************************";
	/**
	 * 获取单个对象
	 * @param 参数
	 * @return
	 */
	public <T> T getObject(HashMap param) {
		if (StringUtils.isNotBlank(selectIbatisName)) {
			return (T)getSqlMapClientTemplate().queryForObject(selectIbatisName,param);
		}else {
			System.out.println(errorStr);
			return null;
		}
		
	}
	/**
	 * 获取单个对象
	 * @proid 项目id
	 * @idFieldName 主键id名称
	 * @return
	 */
	public <T> T getObject(String proid) {
		HashMap param = new HashMap();
		param.put(mainIdField, proid);
		return getObject(param);
	}
	/**
	 * 获取单个对象
	 * @proid 项目id
	 * @idFieldName 主键id名称
	 * @return
	 */
	public <T> T getObject(String proid,String idFieldName) {
		HashMap param = new HashMap();
		param.put(idFieldName, proid);
		return getObject(param);
	}
	/**
	 * 获取对象List
	 * @param 参数
	 * @return
	 */
	public <T> List<T> getObjectList(HashMap param) {
		if (StringUtils.isNotBlank(selectIbatisName)) {
			return (List<T>)getSqlMapClientTemplate().queryForList(selectIbatisName,param);
		}else {
			System.out.println(errorStr);
			return null;
		}
	}

	public boolean insertObject(Object obj) {
		boolean isok = false;
		if (StringUtils.isNotBlank(insertIbatisName)) {
			getSqlMapClientTemplate().insert(insertIbatisName, obj);
			isok = true;
		}else {
			System.out.println(errorStr);
		}
		return isok;
	}

	public boolean updateObject(Object obj) {
		boolean isok = false;
		if (StringUtils.isNotBlank(updateIbatisName)) {
			getSqlMapClientTemplate().update(updateIbatisName, obj);
			isok = true;
		}else {
			System.out.println(errorStr);
		}
		return isok;
	}
	/**
	 * 删除对象，包含文件中心信息
	 * @param参数
	 */
	public boolean deleteObject(HashMap param) {
		boolean isok = false;
		if (StringUtils.isNotBlank(deleteIbatisName)) {
			if (param != null) {
				Collection values = param.values();
				for (Iterator iterator = values.iterator(); iterator.hasNext();) {
					Object value = iterator.next();
					if (value == null || "".equals(String.valueOf(value))) {
						isok = true;
					}
				}
				getSqlMapClientTemplate().delete(deleteIbatisName, param);
				isok = true;
			}
		}else {
			System.out.println(errorStr);
		}
		return isok;
	}
	/**
	 * 删除对象
	 * @proid 项目id
	 * @idFieldName 主键id名称
	 * @return
	 */
	public boolean deleteObject(String proid){
		boolean isok = false;
		if (StringUtils.isNotBlank(deleteIbatisName)) {
			if (StringUtils.isNotBlank(proid)) {
				HashMap param = new HashMap();
				param.put(mainIdField, proid);
				getSqlMapClientTemplate().delete(deleteIbatisName, param);
				isok = true;
			}
		}else {
			System.out.println(errorStr);
		}
		return isok;
	}
	/**
	 * 根据参数和ibatis配置id获取对象
	 * @param param
	 * @param ibatisStr
	 * @return
	 */
	public <T> T getObjectByIbatisStr(HashMap param,String ibatisStr){
		if (StringUtils.isNotBlank(ibatisStr)) {
			return (T)this.getSqlMapClientTemplate().queryForObject(ibatisStr,param);
		}
		return null;
	}
	/**
	 * 根据参数和ibatis配置id获取对象集合
	 * @param param
	 * @param ibatisStr
	 * @return
	 */
	public <T> List<T> getObjectListByIbatisStr(HashMap param,String ibatisStr){
		if (StringUtils.isNotBlank(ibatisStr)) {
			return (List<T>)this.getSqlMapClientTemplate().queryForList(ibatisStr,param);
		}
		return null;
	}
	/**
	 * 根据参数和ibatis配置id获取对象
	 * @param param
	 * @param ibatisStr
	 * @return
	 */
	public HashMap getHashMapByIbatisStr(HashMap param,String ibatisStr){
		if (StringUtils.isNotBlank(ibatisStr)) {
			return (HashMap)this.getSqlMapClientTemplate().queryForObject(ibatisStr,param);
		}
		return null;
	}
	/**
	 * 根据参数和ibatis配置id获取对象集合
	 * @param param
	 * @param ibatisStr
	 * @return
	 */
	public List<HashMap> getHashMapListByIbatisStr(HashMap param,String ibatisStr){
		if (StringUtils.isNotBlank(ibatisStr)) {
			return (List<HashMap>)this.getSqlMapClientTemplate().queryForList(ibatisStr,param);
		}
		return null;
	}
	/**
	 * 根据对象和ibatis配置进行插入数据
	 * @param obj
	 * @param ibatisStr
	 */
	public boolean insertObjectByIbatisStr(Object obj,String ibatisStr) {
		boolean isok = false;
		if (StringUtils.isNotBlank(ibatisStr)) {
			getSqlMapClientTemplate().insert(ibatisStr, obj);
			isok = true;
		}
		return isok;
	}
	/**
	 * 根据对象和ibatis配置进行更新数据
	 * @param obj
	 * @param ibatisStr
	 */
	public boolean updateObjectByIbatisStr(Object obj,String ibatisStr) {
		boolean isok = false;
		if (StringUtils.isNotBlank(ibatisStr)) {
			getSqlMapClientTemplate().update(ibatisStr, obj);
			isok = true;
		}
		return isok;
	}
	/**
	 * 删除对象，根据对象和ibatis配置
	 * @param参数
	 */
	public boolean deleteObjectByIbatisStr(HashMap param,String ibatisStr) {
		boolean isok = false;
		if (StringUtils.isNotBlank(ibatisStr)) {
			if (param != null) {
				Collection values = param.values();
				for (Iterator iterator = values.iterator(); iterator.hasNext();) {
					Object value = iterator.next();
					if (value == null || "".equals(String.valueOf(value))) {
						isok = true;
					}
				}
				getSqlMapClientTemplate().delete(ibatisStr, param);
				isok = true;
			}
		}
		return isok;
	}
}

