package com.gtis.plat.aop;

import com.gtis.plat.service.LogManager;
import com.gtis.plat.service.SysWorkFlowInstanceService;
import com.gtis.plat.vo.Log;
import com.gtis.plat.vo.PfWorkFlowInstanceVo;
import com.gtis.plat.vo.UserInfo;
import org.aspectj.lang.JoinPoint;

public class LogAspect {
    LogManager logManager;
    SysWorkFlowInstanceService workFlowInstanceService;

    public void setWorkFlowInstanceService(SysWorkFlowInstanceService workFlowInstanceService) {
        this.workFlowInstanceService = workFlowInstanceService;
    }

    public void setLogManager(LogManager logManager) {
        this.logManager = logManager;
    }

    /**
     * 登陆日志
     *
     * @param jp
     */
    public void loginAfter(JoinPoint jp, Object userInfo) {
        Log log = Log.instance();
        UserInfo user = (UserInfo) userInfo;
        log.setUserId(user.getId());
        log.setAction("登陆");
        log.setContent(user.getUsername() + "用户登陆");
        logManager.log(log);
    }


    /**
     * 转发日志
     *
     * @param jp
     */
    public void turnAfter(JoinPoint jp) {
        Object taskId = jp.getArgs()[1];

        logManager.log("转发", "用户转发" + taskId.toString());
    }

    /**
     * 删除日志
     *
     * @param jp
     */
    public void delAfter(JoinPoint jp) {
        Object workflowIntanceId = jp.getArgs()[1];
        PfWorkFlowInstanceVo workFlowInstanceVo=workFlowInstanceService.getWorkflowInstance(workflowIntanceId.toString());
        if (workFlowInstanceVo!=null)
            logManager.log("删除", "用户删除" + workFlowInstanceVo.getWorkflowIntanceName() + "编号："+ workflowIntanceId.toString() + "备注：" + workFlowInstanceVo.getRemark());
        else
            logManager.log("删除", "用户删除" + workflowIntanceId.toString());
    }
}
