/*
 * Author: xyang
 *
 * Project: egov
 *
 * File: Portal.js
 *
 * LastModified: 2009-12-07 03:58:45
 *
 * Copyright (c) 2009 gtis. All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent or the
 * registration of a utility model, design or code.
 *
 * Issued by gtis Ltd.
 */
Ext.ns('Portal', 'Portal.app', 'Portal.lib');

var $import = function() {
    var el = {};
    var head = document.getElementsByTagName("head")[0];
    return function() {
        var type, len = arguments.length;
        if (len == 0)
            return;
        var sType = arguments[len - 1].toLowerCase();
        if (sType != 'js' && sType != 'css')
            sType = null;
        else
            len--;
        for (var i = 0; i < len; i++) {
            var path = arguments[i];
            if (sType)
                type = sType;
            else {
                var n = path.lastIndexOf("?");
                n = n > -1 ? n : path.length;
                type = path.substring(path.lastIndexOf(".", n) + 1, n)
                        .toLowerCase();
            }
            if (type == "js") {
                if (el[path])
                    continue;
                document.write('<s' + 'cript type="text/javascript" src="'
                        + path + '"><\/s' + 'cript>');
                el[path] = true;
            } else if (type == "css") {
                if (el[path])
                    continue;
                var s = document.createElement("link");
                s.rel = "stylesheet";
                s.type = "text/css";
                s.href = path;
                el[path] = true;
                s.disabled = false;
                head.appendChild(s);
            }
        }
    };
}();

Portal.Site = Ext.extend(Ext.Component, {
    initComponent:function() {
        Portal.Site.superclass.initComponent.call(this);
        this.items = new Ext.util.MixedCollection(false, this.getComponentId);
        this.columns = new Ext.util.MixedCollection(false);
    },
    onRender : function(ct, position) {
        Portal.Site.superclass.onRender.call(this, ct, position);
        this.initContainer();
        this.loadSite();
        if (!this.readOnly)
            this.dd = new Portal.Site.DropZone(this);
        this.initPortletResize();
        this.initAutoRefresh();
    },
    initAutoRefresh:function() {
        setInterval(this.autoRefresh.createDelegate(this), 1000);
    },
    initPortletResize:function() {
        Ext.EventManager.onWindowResize(this.onSiteResize, this);
    },
    onSiteResize:function() {
        this.items.each(function(portlet) {
            portlet.fireEvent('bodyresize', this);
        }, this);
    },
    autoRefresh:function() {
        var key = Ext.util.Cookies.get('portlet_key');
        if (key) {
            this.items.each(function(portlet) {
                var url = portlet.preferences['url'];
                if (url && url.indexOf(key) > -1)
                    portlet.onRefresh();
            }, this);
            this.loadLinkMenuCount();
            Ext.util.Cookies.set('portlet_key', '');
        }
    },
    initContainer:function() {
        this.initMenu();
        this.initSaveTip();
        this.initLayouts();
        this.initApps();
        this.initColumns();
    },
    initSaveTip:function() {
        this.saveTip = Ext.DomHelper.append(this.container, '<div id="portal-save-tip" style="display:none;">您的首页已经被修改，若要应用更改，请单击保存按钮。<button class="save">保存</button>&nbsp;&nbsp;<button class="cancel">还原</button></div>', true);
        this.saveTip.select('.save').on('click', function() {
            this.saveSite();
        }, this);
        this.saveTip.select('.cancel').on('click', function() {
            Ext.MessageBox.confirm('确认', '确定要取消更改吗?', function(btn) {
                if (btn != 'yes')
                    return;
                this.cancelChange();
            }, this);
        }, this);
    },
    cancelChange:function() {
        this.items.each(function(portlet) {
            portlet.destroy();
            this.items.remove(portlet);
        }, this);
        this.loadSite();
        this.setSaveTipVisible(false);
        this.apps.setVisibilityMode(Ext.Element.DISPLAY).hide();
        this.layouts.setVisibilityMode(Ext.Element.DISPLAY).hide();
    },
    resetSite:function() {
        Ext.Ajax.request({
            url:this.basePath + '/portal!reset.action',
            success:function(response) {
                this.cancelChange();
            },
            scope:this
        });
    },
    initApps:function() {
        this.apps = Ext.DomHelper.append(this.container, '<div id="portlet-list" class="clearfix" style="display:none;"></div>', true);
    },
    initLayouts:function() {
        var html = ['<div id="layout-list" class="clearfix" style="display:none;"><div id="tabLayout-columns">布局：<button>1</button><button>2</button><button>3</button><button>4</button><button>重置</button></div><ul class="option" id="tabLayout-galery">'];
        Ext.each(['1-0','2-0','3-0','3-1','3-2','4-0','4-1','4-2','4-3','4-4','4-5','4-6'], function(layout) {
            html.push('<li><a href="#" id="layout-');
            html.push(layout);
            html.push('"></a></li>');
        });
        html.push('</ul></div>');
        this.layouts = Ext.DomHelper.append(this.container, html.join(''), true);
        this.layouts.select('button').on('click', function(e, t) {
            if (t.innerHTML == '重置') {
                Ext.MessageBox.confirm('确认', '确定要恢复至初始状态吗?', function(btn) {
                    if (btn != 'yes')
                        return;
                    this.resetSite();
                }, this);
            } else {
                this.showLayout(t.innerHTML);
            }
        }, this);
        var self = this;
        this.layouts.select('a').on('click', function(e, t) {
            this.layouts.select('a').each(function(el) {
                if (el.dom == t) {
                    if (!el.hasClass('selected')) {
                        el.addClass('selected');
                        self.setLayout(t.id.split('-').slice(1));
                        self.setSaveTipVisible(true);
                    }
                } else {
                    if (el.hasClass('selected'))
                        el.removeClass('selected');
                }
            });
        }, this);
    },
    initMenu:function() {
        var menu = Ext.DomHelper.append(this.container, '<div id="portal-menu" class="clearfix"><div class="link-menu"></div><ul class="opt-menu"><li><a href="#" class="appA">应用</a></li><li><a href="#" class="layoutA">布局</a></li></ul></div>', true);
        if (this.readOnly) {
            menu.select('.opt-menu').setVisibilityMode(Ext.Element.DISPLAY).hide();
        } else {
            menu.select('.appA').on('click', function(e, t) {
                Ext.fly(t).toggleClass('up');
                this.apps.setVisibilityMode(Ext.Element.DISPLAY).toggle(true);
                this.loadApps();
            }, this);
            menu.select('.layoutA').on('click', function(e, t) {
                Ext.fly(t).toggleClass('up');
                this.layouts.setVisibilityMode(Ext.Element.DISPLAY).toggle(true);
            }, this);
        }
        this.initQuickStart(menu.first());
    },
    initQuickStart:function(ct) {
        if (this.menu) {
            for (var i = 0; i < this.menu.length; i++) {
                var m = this.menu[i];
                var a = Ext.DomHelper.append(ct, ['<a class="item" href="#"><div class="inner-item"><div class="item-icon',m.iconCls ? ' ' + m.iconCls : '','"',m.width ? 'style="width:' + m.width + 'px"' : '','><div class="count"><div class="inner-count"',m.name ? ' id="count' + m.name + '"' : '','></div></div><div class="text">',m.text,'</div></div></div></a>'].join(''), true);
                a.on('click', m.handle);
            }
            this.loadLinkMenuCount();
            setInterval(this.loadLinkMenuCount.createDelegate(this), 20000);
        }
    },
    loadLinkMenuCount:function() {
        Ext.Ajax.request({
            url:this.basePath + '/portal!count.action',
            success:function(response) {
                var counts = Ext.decode(response.responseText);
                for (var name in counts) {
                    var countEl = Ext.get('count' + name);
                    if (countEl) {
                        var count = counts[name];
                        if (count > 0) {
                            countEl.parent().show();
                            countEl.dom.innerHTML = (name == 'taskover')? '(本周)' + count:count;
                        } else {
                            countEl.parent().hide();
                        }
                    }
                }
            },
            scope:this
        });
    },
    initColumns:function() {
        var html = ['<div id="portal-portlets"><div id="columns">'];
        for (var i = 1; i < 5; i++) {
            html.push('<div class="gripper" id="gripper-0' + i + '"></div><div class="column resizable" id="column0' + i + '"></div>');
        }
        html.push('<div class="gripper" id="gripper-05"></div></div></div>');
        Ext.DomHelper.append(this.container, html.join(''));
        this.columnsCt = Ext.get('columns');
        for (i = 1; i < 5; i++) {
            this.columns.add(Ext.get('column0' + i));
        }
        if (!this.readOnly)
            new Portal.Site.Resizable({site:this});
    },
    appsTpl:new Ext.XTemplate('<ul><tpl for="."><li><div title="{description}"><img src="{icon}" alt=""/><em>{name}</em></div><button id="btn{id}">添加</button></li></tpl></ul>'),
    loadApps:function() {
        Ext.Ajax.request({
            url:this.basePath + '/portalEntity!list.action',
            success:function(response) {
                var res = response.responseText;
                if (res.substr(0, 1) == '[') {
                    var json = Ext.decode(response.responseText);
                    var apps = this.appsTpl.overwrite(this.apps, json, true);
                    apps.select('button').on('click', function(e, t) {
                        for (var i = 0; i < json.length; i++) {
                            if (t.id.indexOf(json[i].id) > -1)
                                this.addPortlet({entity:json[i]}, t);
                        }
                    }, this);
                } else {
                    Ext.MessageBox.alert('错误', '读取应用列表出错');
                }
            },
            scope:this
        });
    },
    loadSite:function() {
        Ext.Ajax.request({
            url:this.basePath + '/portal!site.action',
            params:{owner:this.owner},
            success:function(response) {
                var res = response.responseText;
                if (res.substr(0, 1) == '{') {
                    var site = Ext.decode(response.responseText);
                    this.pages = site['site']['pages'];
                    this.renderSite();
                } else {
                    Ext.MessageBox.alert('错误', '加载portal出错，请联系管理员');
                }
            },
            scope:this
        });
    },
    renderSite:function() {
        this.renderTab();
        this.currentPage = this.pages[0];
        this.renderPage(this.currentPage);
    },
    renderTab:function() {
        //todo:now only one page
    },
    renderPage:function(page) {
        var layout = page['layout'].split('-');
        this.setLayout(layout);
        this.showLayout(layout[0]);
        Ext.fly('layout-' + page['layout']).addClass('selected');
        this.renderFragments(page['fragments']);
    },
    renderFragments:function(fragments) {
        for (var i = 0; i < fragments.length; i++) {
            var fragment = fragments[i];
            var width = fragment['width'];
            var column = this.columns.itemAt(i);
            if (width)
                column.setStyle('width', width);
            for (var j = 0; j < fragment['portlets'].length; j++) {
                this.renderPortlet(fragment['portlets'][j], column);
            }
        }
    },
    renderPortlet:function(portletConfig, column, pos) {
        var cfg = this.readPortletConfig(portletConfig);
        cfg.site = this;
        //$import.apply(this, cfg.resources);
        if (!this.readOnly)
            cfg.draggable = true;
        var portlet = new (Ext.decode(cfg['className']))(cfg);
        portlet.render(column, pos);
        this.items.add(portlet);
    },
    readPortletConfig:function(cfg) {
        var entity = cfg['entity'];
        var app = entity['app'];
        return {
            basePath:this.basePath,
            icon:entity['icon'],
            title:cfg['name'] || entity['name'],
            entityId:entity['id'],
            className:app['className'],
            resources:app['resources'],
            preferences:Ext.apply(app['config'] || {}, cfg['preferences'], entity['preferences']),
            Personalpreferences:cfg['preferences'] || {}};
    },
    removePortlet:function(id) {
        var portlet = this.items.get(id);
        portlet.destroy();
        this.items.remove(portlet);
        this.setSaveTipVisible(true);
    },
    showPortlets:function(el) {
        Ext.fly(el).toggleClass('up');
        Ext.fly('portlet-list').setVisibilityMode(Ext.Element.DISPLAY).toggle(true);
    },
    showLayouts:function(el) {
        Ext.fly(el).toggleClass('up');
        Ext.fly('layout-list').setVisibilityMode(Ext.Element.DISPLAY).toggle(true);
    },
    showLayout:function(layout) {
        var self = this;
        this.layouts.select('button').each(function(el) {
            if (el.dom.innerHTML == layout) {
                if (!el.hasClass('pressed')) {
                    el.addClass('pressed');
                    self.layouts.select('a').each(function(a) {
                        a.parent().setVisibilityMode(Ext.Element.DISPLAY).setVisible(a.dom.id.indexOf(layout + '-') > -1);
                    });
                }
            } else {
                if (el.hasClass('pressed'))
                    el.removeClass('pressed');
            }
        });
    },
    setLayout:function(layout) {
        this.columnsCt.dom.className = 'layout-' + layout.join('-');
        if (this.layout != null)
            this.movePortlets(this.layout[0], layout[0]);
        this.layout = layout;
    },
    movePortlets:function(s, t) {
        s = parseInt(s) - 1;
        t = parseInt(t) - 1;
        this.columns.each(function(col) {
            col.setStyle('width', '');
        });
        var tColumn = this.columns.itemAt(t);
        if (t < s) {
            for (; s > t; s--) {
                var sColumn = this.columns.itemAt(s);
                this.items.each(function(p) {
                    if (p.container.id == sColumn.id) {
                        tColumn.appendChild(p.el);
                        p.container = p.el.parent();

                    }
                });
            }
        }
    },
    addPortlet:function(cfg, btn) {
        this.renderPortlet(cfg, this.columns.first(), 0);
        var msg = Ext.DomHelper.insertAfter(btn, '<p class="ok">成功</p>', true);
        Ext.fly(btn).setVisibilityMode(Ext.Element.DISPLAY).hide();
        setTimeout(function() {
            msg.remove();
            Ext.fly(btn).setVisibilityMode(Ext.Element.DISPLAY).show();
        }, 3000);
        this.setSaveTipVisible(true);
    },
    serializeSite:function() {
        var width = this.columnsCt.getWidth(true);
        var page = {name:this.currentPage.name,layout:this.layout.join('-'),fragments:[]};
        this.columns.each(function(col) {
            var w = (parseInt(col.getWidth(true) / width * 10000) / 100) + '%';
            var portlets = [];
            col.select('>.portlet').each(function(p) {
                portlets.push(this.items.get(p.dom.id).serialize());
            }, this);
            page.fragments.push({width:w,portlets:portlets});
        }, this);
        return Ext.encode(page);
    },
    saveSite:function() {
        var site = this.serializeSite();
        Ext.Ajax.request({
            url:this.basePath + '/portal!save.action',
            params:{page:site,owner:this.owner},
            success:function() {
                this.setSaveTipVisible(false);
                this.apps.setVisibilityMode(Ext.Element.DISPLAY).hide();
                this.layouts.setVisibilityMode(Ext.Element.DISPLAY).hide();
            },
            scope:this
        });
    },
    setSaveTipVisible:function(state) {
        this.saveTip.setVisibilityMode(Ext.Element.DISPLAY).setVisible(state);
    }
});

Portal.Site.DropZone = function(site, cfg) {
    this.site = site;
    var container = site.container;
    Ext.dd.ScrollManager.register(container);
    container.ddScrollConfig = this.ddScrollConfig;
    Portal.Site.DropZone.superclass.constructor.call(this, container, cfg);
};

Portal.Site.DropZone = function(site, cfg) {
    this.site = site;
    var container = site.container;
    Ext.dd.ScrollManager.register(container);
    Portal.Site.DropZone.superclass.constructor.call(this, container, cfg);
    container.ddScrollConfig = this.ddScrollConfig;
};

Ext.extend(Portal.Site.DropZone, Ext.dd.DropTarget, {
    ddScrollConfig : {
        vthresh: 50,
        hthresh: -1,
        animate: true,
        increment: 200
    },

    notifyOver : function(dd, e) {
        var xy = e.getXY(),site = this.site,items = this.site.items,px = dd.proxy,min = 10e10,i,col,p,index = -1,pIndex = -1;
        if (!this.columnsBoxs)
            this.columnsBoxs = this.getColumnsBoxs();
        for (i = 0; i < this.columnsBoxs.length; i++) {
            col = this.columnsBoxs[i];
            if (xy[0] > col.x && xy[0] < col.right && xy[1] > col.y && xy[1] < col.bottom) {
                index = i;
                break;
            }
        }
        if (index == -1) {
            for (i = 0; i < this.columnsBoxs.length; i++) {
                col = this.columnsBoxs[i];
                var d = this.getDistance(col, xy);
                if (min > d) {
                    min = d;
                    index = i;
                }
            }
        }
        col = site.columns.itemAt(index).dom;
        min = 10e10;
        for (i = 0; i < items.getCount(); i++) {
            p = items.itemAt(i);
            if (p.container.id == col.id) {
                if (p.el.getHeight() == 0)
                    continue;
                d = p.el.getY() - xy[1];
                if (d > 0 && min > d) {
                    min = d;
                    pIndex = i;
                }
            }
        }
        if (this.lastPos && this.lastPos.col == col && this.lastPos.pIndex == pIndex)
            return;
        this.lastPos = {col:col,pIndex:pIndex};
        px.getProxy().setWidth('auto');
        if (pIndex == -1) {
            px.moveProxy(col, null);
        } else {
            p = items.itemAt(pIndex);
            px.moveProxy(col, p.el.dom);
        }
        this.scrollPos = site.container.getScroll();
        delete this.columnsBoxs;
    },

    notifyOut : function() {
        delete this.columnsBoxs;
    },

    notifyDrop : function(dd, e) {
        delete this.columnsBoxs;
        if (!this.lastPos) {
            return;
        }
        this.site.setSaveTipVisible(true);
        var proxy = dd.proxy.getProxy().dom;
        var p = dd.panel;
        proxy.parentNode.replaceChild(p.el.dom, proxy);
        p.container = p.el.parent();
        var st = this.scrollPos.top;
        if (st) {
            var d = this.site.container.dom;
            setTimeout(function() {
                d.scrollTop = st;
            }, 10);
        }
    },
    getColumnsBoxs:function() {
        var boxs = [];
        this.site.columns.each(function(column) {
            boxs.push(column.getBox());
        });
        return boxs;
    },
    getDistance:function(box, xy) {
        return Math.pow(box.x + box.width / 2 - xy[0], 2) + Math.pow(box.y + box.height / 2 - xy[1], 2);
    }
});

Portal.Site.Resizable = function(config) {
    Ext.apply(this, config);
    this.container = this.site.columnsCt;
    this.columns = this.site.columns.items;
    this.resizing = false;
    this.init();
};

Portal.Site.Resizable.prototype = {
    init:function() {
        this.container.select('.gripper').on({
            'mouseenter':function(e, el) {
                e.getTarget(null, null, true).addClass('hover');
                this.gripper = Ext.get(el);
                this.container.on('mousedown', this.initResize, this);
            },
            'mouseleave':function(e) {
                if (!this.resizing) {
                    e.getTarget(null, null, true).removeClass('hover');
                    this.container.un('mousedown', this.initResize, this);
                }
            },
            scope:this
        });
    },
    initResize:function(e) {
        var ctWidth = this.container.getWidth(true);
        this.resizing = true;
        this.x = e.getXY()[0];
        this.prev = this.gripper.prev();
        this.next = this.gripper.next();
        this.prevWidth = this.prev.getWidth() / ctWidth;
        this.nextWidth = this.next.getWidth() / ctWidth;
        if (this.site.layout[0] == '4') {
            this.rate3 = this.columns[2].getWidth() / (this.columns[2].getWidth() + this.columns[3].getWidth());
            if (this.site.layout[1] == '4') {
                this.col0Width = this.columns[0].getWidth() / ctWidth;
            }
        }
        this.container.on({
            mousemove: this.onResize,
            mouseup: this.onFinish,
            scope: this
        });
    },
    fireSiteResize:function() {
        this.site.onSiteResize();
    },
    onResize:function(e) {
        if (!this.resizeTask)
            this.resizeTask = new Ext.util.DelayedTask();
        this.resizeTask.delay(100, this.fireSiteResize, this);
        var ctWidth = this.container.getWidth(true);
        var minColWidth = 100 / ctWidth;
        var offset = (e.getXY()[0] - this.x) / ctWidth;
        if (this.site.layout[0] != '4' || this.site.layout[1] != '4') {
            if (this.nextWidth - offset < minColWidth || this.prevWidth + offset < minColWidth)
                return;
            this.setWidth(this.prev, this.prevWidth + offset);
            this.setWidth(this.next, this.nextWidth - offset);
        }
        if (this.site.layout[0] == '4') {
            if (this.site.layout[1] == '1' && this.gripper.id.indexOf('2') > -1) {
                this.setWidth(this.columns[2], (this.prevWidth + offset - .01) * this.rate3);
                this.setWidth(this.columns[3], (this.prevWidth + offset - .01) * (1 - this.rate3));
            }
            if (this.site.layout[1] == '4') {
                if (this.gripper.id.indexOf('3') > -1) {
                    if (this.col0Width - offset < minColWidth || this.prevWidth + offset < minColWidth)
                        return;
                    this.setWidth(this.columns[0], this.col0Width - offset);
                    this.setWidth(this.columns[1], this.prevWidth + offset);
                    this.setWidth(this.columns[2], (this.col0Width - offset - .01) * (1 - this.rate3));
                    this.setWidth(this.columns[3], (this.col0Width - offset - .01) * this.rate3);
                } else {
                    if (this.nextWidth + offset < minColWidth || this.prevWidth - offset < minColWidth)
                        return;
                    this.setWidth(this.next, this.nextWidth + offset);
                    this.setWidth(this.prev, this.prevWidth - offset);
                }
            }
        }
    },
    onFinish:function() {
        this.gripper.removeClass('hover');
        this.resizing = false;
        this.container.un('mousedown', this.initResize, this);
        this.container.un('mousemove', this.onResize, this);
        this.container.un('mouseup', this.onFinish, this);
        this.site.setSaveTipVisible(true);
    },
    setWidth:function(el, width) {
        el.setWidth((parseInt(width * 10000) / 100) + '%');
    }
};
