<%@ page language="java" pageEncoding="utf-8"%>
<%@ taglib prefix="g" uri="/gtis-tags"%>
<html>
  <head>
    <title>用户列表</title>
    <g:head useExt="true"/>

	<script type="text/javascript">
		function dateformat(val, p, record){
	        if (val && val!=''){
	            if (val.length==19)
	                return val.substring(0,10);
	        }
	    }
	    
	    function edituser(){
	    	Ext.Ajax.request({
	    		url:'${pageContext.request.contextPath}/sysuser!userInfo.action',
	    		method:'post',
	    		success: function(response, opts) { 
			        var userVo = Ext.util.JSON.decode(response.responseText); 
			        var userId=userVo.userId;
			        var userName = userVo.userName; 
			 		var email=userVo.email; 
			 		var loginName=userVo.loginName; 
			 		var mobilePhone=userVo.mobilePhone;
			 		var userNo=userVo.userNo;
			 		var officePhone=userVo.officePhone;
                    var remark = userVo.remark;

			    	var editUserForm= new Ext.FormPanel({
			    		labelAlign : 'center',//位置
						labelWidth : 60,
						frame : true,
						width : 240,
						heigth:380,
						waitMsgTarget: true,
						items :[{
							fieldLabel : '用户名',
							xtype:'textfield',
							allowBlank:false,
							name:'userVo.userName',
							value:userName,
							anchor:'95%'
						},{
							fieldLabel : '登录名',
							xtype:'textfield',
							allowBlank:false,
							name:'userVo.loginName',
							value:loginName,
							readOnly:true ,
							anchor:'95%'
						},{
							fieldLabel : '手机号码',
							xtype:'textfield',
							allowBlank:true,
							name:'userVo.mobilePhone',
							value:mobilePhone,
							anchor:'95%'
						},{
							fieldLabel : '邮箱',
							xtype:'textfield',
							allowBlank:true,
							name:'userVo.email',
							value:email,
							anchor:'95%'
						},{
                            fieldLabel:'办公电话',
                            xtype:'textfield',
                            allowBlank:true,
                            name:'userVo.officePhone',
                            value:officePhone,
                            anchor:'95%'
                        },{
                            fieldLabel:'备注',
                            xtype:'textarea',
                            allowBlank:true,
                            name:'userVo.remark',
                            value:remark,
                            anchor:'95%'
                        },new Ext.form.Hidden({
							name:'userVo.userId',
							value:userId
						}),new Ext.form.Hidden({
							name:'userVo.userNo',
							value:userNo
						})]
			    	});
	    	
			    	var win=new Ext.Window({
			    		title:'编辑用户',
			    		width:250,
			    		height:280,
			    		closable:true,
			    		layout:'fit',
						modal:true,//模式窗口
			    		items:editUserForm,
			    		buttons:[{
			    			text:'保存',
			    			handler:function(){
			    				editUserForm.form.submit({
			    					url:'${pageContext.request.contextPath}/sysuser!save.action',
									method:'post',
									success:function(response){
                                         refreshTask();
										 Ext.Msg.alert("信息", "数据保存成功！");
										 win.close();
									},
									failure: function(response) {
						            	Ext.Msg.alert("警告", "数据保存失败，请稍后再试！");
						            }
			    				});
			    			}
			    		},{
			    			text:'关闭',
			    			handler:function(){
			    				win.close();
			    			}
			    		}]
			    	});
			    	
			    	win.show();
			    } 
	    	});	
	    }
	    
	    //刷新任务
        function refreshTask(){
            var gridobj=Ext.getCmp("userList");
            if (gridobj)
                //gridobj.getStore().reload();
                gridobj.refresh();
        }
	</script>
  </head>
  
  <body>
    <g:list id="userList" width="100%" keyField="USER_ID" splitInfo="splitParam" contentHeightOffset="-100" checkbox="true">
        <g:toolbar>
    		<g:tool text="修改个人信息" handler="edituser" icon="${pageContext.request.contextPath}/common/images/over.gif"/>
    	</g:toolbar>
        <g:query>
            <g:queryItem label="用户名" name="USER_NAME"/>
            <g:queryItem label="登录名" name="LOGIN_NAME"/>
            <g:queryItem label="手　机" name="MOBILE_PHONE"/>
            <g:queryItem label="办　公" name="OFFICE_PHONE"/>
            <g:queryItem label="邮　箱" name="EMAIL"/>
        </g:query>
        <g:export fields="用户名,USER_NAME,80;
            手机号码,MOBILE_PHONE,120;
            办公电话,OFFICE_PHONE,120;
            邮箱,OFFICE_PHONE,170;
            备注,REMARK,230" caption="通讯录" />
    	<g:field fieldname="USER_ID" hidden="true"/>
    	<g:field fieldname="USER_NAME" header="用户名" width="80"/>
        <g:field fieldname="LOGIN_NAME" header="登录名" width="80"/>
    	<g:field fieldname="MOBILE_PHONE" header="手机号码" width="120"/>
    	<g:field fieldname="OFFICE_PHONE" header="办公电话" width="120"/> 
    	<g:field fieldname="EMAIL" header="邮箱" width="170"/>
    	<g:field fieldname="REMARK" header="备注" width="230"/>
    </g:list>
  </body>
</html>
