﻿<%@ page language="java" pageEncoding="utf-8" %>
<%@ taglib prefix="s" uri="/struts-tags" %>
<%@ taglib prefix="g" uri="/gtis-tags" %>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
<g:head useExt="true"/>
<link href="${pageContext.request.contextPath}/common/css/vscontext.css" type="text/css" media="screen" rel="stylesheet"/>
<script src="${pageContext.request.contextPath}/global/jquery/jquery-1.10.2.min.js"></script>
<script type="text/javascript" src="${pageContext.request.contextPath}/common/js/vscontext.jquery.js"></script>
<title>任务转发</title>
<style>
    body {
        margin-top: 10px;
        margin-left: 10px;
        overflow: hidden;
    }
    ul {
        padding: 0px;
        margin: 0px;
        list-style-type: none
    }
    li {
        padding: 0px;
        margin: 0px
    }
    #divTab .tabs {
        width: auto;
        height: 25px;
        border-bottom: #1C90E1 1px solid;
    }

    #divTab .tabs li {
        float: left;
        border: #A5C7F5 1px solid;
        padding: 0px 10px;
        line-height: 24px;
        background: #B8D0F3;
        cursor: pointer;
        color: blue;
    }
    #divTab .tabs .selectedTab {
        border-left: #5A9CCA 1px solid;
        border-top: #5A9CCA 1px solid;
        border-right: #5A9CCA 1px solid;
        border-bottom: #1C90E1 1px solid;
        font-weight: bold;
        background: #1C90E1;
        color: #FFFFFF;
        height: 25px
    }
    #divTab .tabs .tabspace {
        border-width: 0px;
        padding: 0px;
        background: #FFFFFF;
        width: 2px;
        height: 22px;
    }
    #divTab ul li {
        font-size: 13px
    }
    #tabContent {
        border-top: #1C90E1 5px solid;
        border-right: solid #1C90E1 2px;
        border-bottom: solid #1C90E1 5px;
        border-left: #1C90E1 2px solid;
    }
    .table_border {
        border-collapse: collapse;
    }
    .title {
        background-color: #A6E2FF;
    }
    .title td {
        font-style: oblique;
        font-size: 14px;
        font-weight: bold;
    }
    #button_div {
        width: 623px;
        height: 30px;
        margin: 0 auto;
        margin-top: 5px;
        padding: 0;
        text-align: center;
    }
    #button_div a:link,#button_div a:visited {
        display: block;
        width: 8em;
        padding: 0.1em;
        line-height: 1.4;
        background-color: #A6E2FF;
        border: 1px solid black;
        color: #000;
        text-decoration: none;
        text-align: center;
    }
    #button_div a:hover {
        background-color: #1C90E1;
        color: #fff;
    }
    #button_div a {
        font-size: 12px;
    }
    .table_border thead tr th,
    .table_border tbody tr th,
    .table_border tfoot tr th,
    .table_border thead tr td,
    .table_border tbody tr td,
    .table_border tfoot tr td {
        padding: 2px;
        line-height: 1.428571429;
        border: 1px solid #dddddd;
        text-align: center;
        font-size: 14px;
    }
    .table_border thead tr th {
        background-color: #f5f5f5;
        font-size: 14px;
        font-weight: bold;
    }
    select {
        width: 100%;
    }
    #div_tabl,#div_tab2{
        height: 230px;
        width: 100%;
        overflow-y:auto;
        overflow-x:hidden;
    }
    textarea{
        width: 100%;
        height:100%;
        padding:0;
        margin: 0;
        border: 0;
        font-size: 14px;
    }
    #sendMsg{
       display: none;
       font-size: 13px;
    }
    #mask {
        position: absolute;
        top: 0px;
        filter: alpha(opacity=60);
        background-color: #777;
        z-index: 1;
        left: 0px;
        opacity:0.5;
        -moz-opacity:0.5;
        text-align: center;
        font-weight: bold;
        font-size: 14px;
        color: red;
        line-height: 300px;
    }
</style>
<script language="JavaScript" type="text/javascript">


function TabSwitch(selectedTab) {
    //1、找ID为divTab的元素；2、找className为tabs的所有LI元素（排除className为tabspace的LI元素）；3、清除所有class
    $("#divTab .tabs LI[class!='tabspace']").removeClass();

    //为当前选中的tab设置class
    $("#" + selectedTab).addClass("selectedTab");
    $("#div_tabl").toggle();
    $("#div_tab2").toggle();
}


var activityRelType;
$(function () {
    $("#mask").hide();
    $("#div_tab2").toggle();
    var opinionsInfo = getOpinions();
    initializeTransferTable(getTurnInfo());
    initializeContextMenu();
});

function getTurnInfo() {
    var returnXml = '<s:property value="turnXml" escape="false" />';
    return returnXml;
}

function getOpinions() {
    var opinionJSON = '<s:property value="opinions" escape="false" />';
    return opinionJSON;
}

/**
*初始化意见右键菜单
 */
function initializeContextMenu(){
    var opinions = getOpinions();
    if(opinions!=null&&opinions!=''){
        var opinionList = $.parseJSON(opinions);
        var menuItems={};
        for(var index in opinionList){
            if(opinionList[index].opinIsUse=='1'){
                var menuItem = $('<a >');
                menuItem.attr('href','#');
                menuItem.bind('click', getOpinionFromContextMenu);
                menuItem.text(opinionList[index].opinContent);
                $(".vs-context-menu ul").append($('<li></li>').append(menuItem));
            }
        }
        $('#opinionText').vscontext({menuBlock: 'vs-context-menu'});
    }
}

function getOpinionFromContextMenu(){
    $("#opinionText").val($(this).text());
}

function postTurnInfo(info) {
    var url = "${pageContext.request.contextPath}/taskturn!TurnTask.action?taskid=" + '<s:property value="taskid" escape="false" />';
    var turnXML = getTurnXml();
    if (turnXML != null) {
        showWaiting();
        $.ajax({
            url: url,
            data: turnXML,
            processData: false,
            contentType: 'text/xml',
            type: 'POST',
            error: function () {
                $("#mask").hide();
                alert('工作流转发错误！');
            },
            success: function (data) {
                if (data == 'true') {
                    window.returnValue = "turnok";
                    Ext.util.Cookies.set('portlet_key', 'tasklist');
                    window.close();
                } else {
                    $("#mask").hide();
                    data = data.replace(/\\n/g,"\n");
					alert(data);
                }
            }
        });
    }

}

/**
 *获取到需要提交的XML
 */
function getTurnXml() {
    var activitysElement = '<Activitys RelType="' + activityRelType + '"';
    if ($('#sendMsg input').attr('checked') != null && ($('#sendMsg input').attr('checked') == 'true'))
        activitysElement += ' SendSMS="' + $('#sendMsg input').attr('checked') + '"';
    else
        activitysElement += ' SendSMS= "false"';
    activitysElement += '>';
    $('#activityTable').find('input:checked').each(function (i) {
        var activityElement = '<Activity ';
        var userInfoElement = '<UserInfo ';
        var rowspan = 1;
        $(this).parent().parent().find('td').each(function (j) {
            if (j == 0) {
                if ($(this).attr('rowspan') != null)
                    rowspan = parseInt($(this).attr('rowspan'));
            } else if (j == 1) {
                activityElement += 'Id="' + $(this).attr('name') + '">';
            } else if (j == 2) {
                userInfoElement += 'RoleId="' + $(this).find('select').val() + '"';
            } else if (j == 3) {
                if ($(this).find('select').val() != null && $(this).find('select').val() != "")
                    userInfoElement += ' Id="' + $(this).find('select').val() + '">';
                else
                    userInfoElement += ' Id="-1">';
            }
        });
        userInfoElement += "</UserInfo>";
        activityElement += userInfoElement;

        if(rowspan>1){
            var nextUserInfoElements = $(this).parent().parent().nextAll();
            for (var m = 0; m < nextUserInfoElements.length; m++) {
                var userInfoElement = '<UserInfo ';
                $(nextUserInfoElements[m]).find('td').each(function (j) {
                    if (j == 0) {
                        userInfoElement += 'RoleId="' + $(this).find('select').val() + '"';
                    } else if (j == 1) {
                        if ($(this).find('select').val() != null && $(this).find('select').val() != "")
                            userInfoElement += ' Id="' + $(this).find('select').val() + '">';
                        else
                            userInfoElement += ' Id="-1">';
                    }

                });
                userInfoElement += "</UserInfo>";
                activityElement += userInfoElement;
            }
        }

        activityElement += "</Activity>";
        activitysElement += activityElement;
    })


    var remarkElement = '<ReMark>';
    var remarkTextElement = '<text>';
    if ($('#opinionText').val() != null && $('#opinionText').val() != "")
        remarkTextElement += $('#opinionText').val();
    remarkTextElement += '</text>';
    remarkElement += remarkTextElement + '</ReMark>';
    activitysElement += remarkElement + '</Activitys>';
    return activitysElement;
}

/**
 *增加一行
 */
function addRow() {
    var imgObj = $(this);
    var oldRow = imgObj.parent().parent();
    var newRow = $('<tr></tr>');
    var activityId = $(oldRow.find('td')[0]).attr('name')
    newRow.append($(oldRow.find('td')[2]).clone(true));
    newRow.append($(oldRow.find('td')[3]).clone(true));
    var newImgNode = $('<img name="' + activityId + '" style="cursor:hand" ' + ' src="${pageContext.request.contextPath}/common/images/delete.gif" height="15" ext:qtip="删除"/>');
    newImgNode.bind('click', delRow);
    var newImgTd = $('<td></td>').append(newImgNode);
    newRow.append(newImgTd);
    newRow.insertAfter($(oldRow));
    if ($(oldRow.find('td')[0]).attr('rowspan') != null) {
        $(oldRow.find('td')[0]).attr('rowspan', parseInt($(oldRow.find('td')[0]).attr('rowspan')) + 1);
        $(oldRow.find('td')[1]).attr('rowspan', parseInt($(oldRow.find('td')[1]).attr('rowspan')) + 1);
    }
    else {
        $(oldRow.find('td')[0]).attr('rowspan', 2);
        $(oldRow.find('td')[1]).attr('rowspan', 2);
    }
    refreshUserSelectOption(newRow);
}

/**
 * 删除行
 */
function delRow() {
    var imgObj = $(this);
    var activityId = $(this).attr('name');
    var currentRow = imgObj.parent().parent();

    $('#activityTable').find('td[name="' + activityId + '"]').attr('rowspan', parseInt($('#activityTable').find('td[name="' + activityId + '"]').attr('rowspan')) - 1);
    currentRow.remove();
}

/**
 * 角色或部门列表变化处理方法
 */
function changeRole() {
    var roleSelectObj = $(this);
    refreshUserSelectOption($(roleSelectObj.parent().parent()));
}

/**
 *属性用户列表
 * @param row  用户select所在的行对象
 */
function refreshUserSelectOption(row) {
    var userSelectObj = row.find('select[Id="users"]');
    userSelectObj[0].options.length = 0;
    if($($.parseXML(getTurnInfo())).find('User[Id="' + ($(row.find('select')[0]).val()) + '"]>UserInfo')!=null&&($($.parseXML(getTurnInfo())).find('User[Id="' + ($(row.find('select')[0]).val()) + '"]>UserInfo').length>1))
        $(userSelectObj[0]).append($('<option value ="">---全部---</option>'));
    $($.parseXML(getTurnInfo())).find('User[Id="' + ($(row.find('select')[0]).val()) + '"]>UserInfo').each(function (i) {
        var userNode = $(this);
        $(userSelectObj[0]).append($('<option value ="' + userNode.attr('Id') + '">' + userNode.attr('Name') + '</option>'));
    });
}

/**
 *初始化转发列表
 * @param turnInfo
 */
function initializeTransferTable(turnInfo) {
    if (turnInfo === null || turnInfo === '')
        return;
    var turnInfoDoc = $.parseXML(turnInfo)
    var activityRoot = $(turnInfoDoc).find('*').eq(0);
    activityRelType = activityRoot.attr('RelType');
    var activitySendSMS = activityRoot.attr('SendSMS');

    var index = 0;
    $(turnInfoDoc).find('Activity').each(function (i) {
        var activityNode = $(this);
        var activityName = $(this).attr('Name');
        var activityId = $(this).attr('Id');
        var multiSelect = $(this).attr('MutiSelect');
        var defaultSelected = $(this).attr('DefaultSelected');
        var newRow = $('<tr></tr>');
        var newTypeTd = $('<td></td>');


        //为了兼容IE6和IE7的浏览器下的Radio控件,才写成字符串拼接
        var inputChecked="";
        if(defaultSelected!=null&&defaultSelected==='true')
            inputChecked= 'checked="checked"';
        var inputNodeType = "";
        if(activityRelType==='and'){
            inputNodeType = 'checkbox';
        }else{
            inputNodeType = 'radio';
        }
        var newInputNode = $('<input name="relType" type="'+inputNodeType+'"'+inputChecked+'/>');
        newTypeTd.append(newInputNode);
        newTypeTd.attr('name', activityId);
        newRow.append(newTypeTd);


        newTypeTd = $('<td></td>');
        newTypeTd.attr('name', activityId);
        newTypeTd.text(activityName);
        newRow.append(newTypeTd);
        if (activityNode.find('User').length > 0) {
            newTypeTd = $('<td></td>');
            var newSelectRole = $('<select></select>');
            newSelectRole.bind('change', changeRole);
            newSelectRole.attr('id', 'role' + activityId);
            var firstRoleId;
            activityNode.find('User').each(function (j) {
                var roleNode = $(this);
                if (j === 0)
                    firstRoleId = $(this).attr('Id');
                var roleName = $(this).attr('Name');
                var roleId = $(this).attr('Id');
                newSelectRole.append($('<option value ="' + roleId + '">' + roleName + '</option>'));
            });
            newTypeTd.append(newSelectRole);
            newRow.append(newTypeTd);
            if (firstRoleId != null && firstRoleId != '') {
                newTypeTd = $('<td></td>');
                var newSelectUser = $('<select id="users"></select>');
                if(activityNode.find('User[Id="' + firstRoleId + '"]>UserInfo')!=null&&activityNode.find('User[Id="' + firstRoleId + '"]>UserInfo').length>1)
                    newSelectUser.append($('<option value ="">---全部---</option>'));
                activityNode.find('User[Id="' + firstRoleId + '"]>UserInfo').each(function (m) {
                    var userNode = $(this);
                    newSelectUser.append($('<option value ="' + userNode.attr('Id') + '">' + userNode.attr('Name') + '</option>'));
                });
                newTypeTd.append(newSelectUser);
            }
            newRow.append(newTypeTd);
            newTypeTd = $('<td></td>');
            if (multiSelect != null && multiSelect === 'true') {
                var tmpImgNode = $("<img name='addRowImg' style=\"cursor:hand\"  src=\"${pageContext.request.contextPath}/common/images/drop-add.gif\" height=\"15\" ext:qtip=\"添加\"/>");
                tmpImgNode.bind('click', addRow);
                newTypeTd.append(tmpImgNode);
            }
            newRow.append(newTypeTd);
        } else {
            newRow.append($('<td></td><td></td><td></td>'));
        }
        if (i == 0)
            $('#activityTable tbody').append(newRow);
        else
            newRow.insertAfter($('#activityTable tr:eq(' + index + ')'));

        index += 1;
        if (multiSelect != null && multiSelect === 'true') {
            for (var k = 0; k < activityNode.find('User').length - 1; k++) {
                var nextRow = $('<tr></tr>');
                var activityId = $(newRow.find('td')[0]).attr('name')
                nextRow.append($(newRow.find('td')[2]).clone(true));
                nextRow.append($(newRow.find('td')[3]).clone(true));
                var newImgNode = $('<img name="' + activityId + '" style="cursor:hand" ' + ' src="${pageContext.request.contextPath}/common/images/delete.gif" height="15" ext:qtip="删除"/>');
                newImgNode.bind('click', delRow);
                var newImgTd = $('<td></td>').append(newImgNode);
                nextRow.append(newImgTd);
                nextRow.insertAfter($(newRow));
                if ($(newRow.find('td')[0]).attr('rowspan') != null) {
                    $(newRow.find('td')[0]).attr('rowspan', parseInt($(newRow.find('td')[0]).attr('rowspan')) + 1);
                    $(newRow.find('td')[1]).attr('rowspan', parseInt($(newRow.find('td')[1]).attr('rowspan')) + 1);
                }
                else {
                    $(newRow.find('td')[0]).attr('rowspan', 2);
                    $(newRow.find('td')[1]).attr('rowspan', 2);
                }
                index += 1;
                $(nextRow.find('td')[0]).find('select').get(0).selectedIndex = k + 1;
                refreshUserSelectOption(nextRow);
            }
        }


    });
    if (activitySendSMS != null && activitySendSMS === 'true') {
        $('#sendMsg').css('display', 'block');
        $('#sendMsg input').attr('checked', true);
    }

    var defaultNotChecked = true;
    $('#activityTable').find('input[name="relType"]').each(function (k) {
        if ($(this).attr('checked') != null)
            defaultNotChecked = false;
    });
    if (defaultNotChecked) {
        $($('#activityTable').find('input[name="relType"]')[0]).attr('checked', true);
    }


}


function showWaiting(){

    $("#mask").css("height",$(document).height());
    $("#mask").css("width",$(document).width());
    $("#mask").show();

}
</script>
</head>
<body scroll="no">
<div id="divTab" style="width:623px;">
    <table cellSpacing="0" cellPadding="0" width="100%" border="0">
        <tr>
            <td valign="bottom" align="left" width="100%">
                <UL class="tabs">
                    <LI class="tabspace"></LI>
                    <LI id="tab1" onclick="TabSwitch('tab1')" class="selectedTab">任务转发</LI>

                    <LI class="tabspace"></LI>
                    <LI id="tab2" onclick="TabSwitch('tab2')">意见</LI>
                </UL>
            </td>
        </tr>
        <tr>
            <td id="tabContent" height="230" align="center" style="vertical-align:top">
                <div id="div_tabl">
                    <table id="activityTable" width="100%" border="1" class="table_border" bordercolor="dddddd">
                        <thead>
                        <tr>
                            <th width="10%">选择</th>
                            <th width="30%">转发活动</th>
                            <th width="30%">参与角色</th>
                            <th width="25%">参与人</th>
                            <th width="5%"></th>
                        </tr>
                        </thead>
                        <tbody>

                        </tbody>
                    </table>
                </div>
                <div id="div_tab2">
                    <table width="100%" height="100%" border="1" class="table_border" bordercolor="000066">
                        <tr class="title">

                            <td align="center">
                                <textarea id="opinionText"></textarea>
                            </td>
                        </tr>
                    </table>
                </div>
            </td>
        </tr>
    </table>
</div>
<div id="sendMsg">
    <input  type="checkbox" name="sendMsg" value="">是否发送短信</input>
</div>
<div id="button_div">
    <table width="300" border="0" cellpadding="0" cellspacing="0">
        <tr>
            <td width="50%" align="center">
                <a id="aturn" href="#" onclick="javascript:postTurnInfo()">转 发</a>
            </td>
            <td width="50%" align="center">
                <a href="#" onclick="window.close()">关　闭</a>
            </td>
        </tr>
    </table>
</div>
<div class="vs-context-menu">
    <ul>
    </ul>
</div>
<div id="mask" class="mask">正在转发中.....</div>
</body>
</html>
