<%@ page language="java" pageEncoding="utf-8" %>
<%@ include file="/include.jsp" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html>
<head>
    <title>项目列表</title>
    <style type="text/css">
        .fc-error-dialog .x-panel-body {
            background: url(${pageContext.request.contextPath}/pf/images/icon-error.gif) no-repeat 10px 2px;
            padding: 10px 5px 18px 52px;
        }

        .fc-error-dialog-detail .x-panel-header {
            background: #f1f1f1;
        }
    </style>
    <g:head useFlash="false" useExt="true" useJQuery="true" cookie="true"/>
    <script type="text/javascript">
        var _wiid = "${wiid}";
    </script>
    <script type="text/javascript" src="${pageContext.request.contextPath}/pf/js/ErrorResolver.js"></script>
    <script type="text/javascript">

        function dateformat(val, p, record) {
            if (val && val != '') {
                if (val.length == 19)
                    return val.substring(0, 10);
            }
        }

        function rowdbclick(gridobj, rowindex, event) {
            var gdata = gridobj.store;
            if (gdata.getAt(rowindex).data.WORKFLOW_STATE != 3) {
                var wiid = gdata.getAt(rowindex).data.WORKFLOW_INSTANCE_ID;
                var w_width = screen.availWidth - 10;
                var w_height = screen.availHeight - 32;
                var url = '${pageContext.request.contextPath}/projecthandle.action?wiid=' + wiid;
                window.open(url, "_project", "left=1,top=0,height=" + w_height + ",width=" + w_width + ",resizable=yes,scrollbars=yes");
            } else {
                alert("文件挂起中，请解挂后再查看！");
            }
        }

        function ShowMessageBox(title, msg) {
            Ext.MessageBox.show({
                title: title,
                msg: msg,
                progress: true,
                width: 200
            });
            Ext.MessageBox.updateProgress(0, "0%", msg);
        }

        function HideMessageBox() {
            Ext.MessageBox.hide();
            var gridobj = Ext.getCmp("gridobj");
            if (gridobj)
            //gridobj.getStore().reload();
                gridobj.refresh();
        }

        function showHandler(val, p, record) {
            if (val != null) {
                return "<div ext:qtip='" + val + "'>" + val + "</div>";
            }
        }

        function refreshTask() {
            var gridobj = Ext.getCmp("gridobj");
            if (gridobj) {
                gridobj.refresh();
                //gridobj.focus(false);
            }
        }

        function BusinessChange(value) {
            Ext.Ajax.request({
                url: '${pageContext.request.contextPath}/tasklist!getWorkFlowDefineList.action',
                success: function (r) {
                    var selectCmb = Ext.getCmp("cmb_WORKFLOW_DEFINITION_ID");
                    selectCmb.store.loadData(eval(r.responseText));
                },
                method: 'POST',
                params: {businessid: value}
            });
        }

        function associateProject() {
            var wiidRelated = ""
            var gridobj = Ext.getCmp("gridobj");
            var sel = gridobj.getSelectionModel().getSelections();
            if (sel.length < 1) {
                alert("请选择关联项目！");
            } else {
                if (!confirm("是否确认进行关联！")) {
                    return;
                }
                var title = "◆正在关联项目......";
                ShowMessageBox("关联项目", title);
                for (var i = 0; i < sel.length; i++) {
                    var wiId = sel[i].data.WORKFLOW_INSTANCE_ID;
                    var taskName = sel[i].data.WORKFLOW_INSTANCE_NAME;
                    wiidRelated += wiId;
                    if (i < sel.length - 1)
                        wiidRelated += ";";
                }

            }
            Ext.Ajax.request({
                url: '${pageContext.request.contextPath}/projectrelate!associateWorkflowInstance.action',
                success: function (r) {
                    HideMessageBox();
                    parent.BeginQueryRelatedProj();
                },
                method: 'POST',
                params: {wiid: _wiid, wiidRelated: wiidRelated}
            });
        }
    </script>
</head>

<body>
<div>
    <g:list id="gridobj" width="100%" checkbox="true"
            keyField="WORKFLOW_INSTANCE_ID" splitInfo="splitParam" gridHeightOffset="-1" rowdbclick="rowdbclick"
            remoteSort="true" contentHeightOffset="-100">
        <g:query>
            <g:queryItem label="项目名称" name="WORKFLOW_INSTANCE_NAME"/>
            <g:queryItem label="创建人" name="CREATE_USERNAME"/>
            <g:queryItem label="备注" name="REMARK"/>
            <g:queryItem label="流程类型" itemType="combo" name="WORKFLOW_DEFINITION_ID"
                         showFieldName="workflowName" valueFieldName="workflowDefinitionId"
                         source="lstWorkFlowDefine"/>
            <g:queryItem label="开始时间(从)" itemType="datefield" name="BEGIN_TIME"/>
            <g:queryItem label="开始时间(至)" itemType="datefield" name="FINISH_TIME"/>
            <g:queryItem label="流程状态" itemType="combo" name="STATE"
                         showFieldName="name" valueFieldName="value"
                         source="[{name:'所有',value:''},{name:'正在办理',value:'1'},{name:'已办结',value:'2'},{name:'挂起',value:'3'}]"/>
        </g:query>
        <g:toolbar>
            <g:tool text="请选择业务..." itemType="combo" name="BUSINESS_ID" showFieldName="businessName"
                    valueFieldName="businessId" width="120"
                    source="businessList" change="BusinessChange"/>
            <g:tool text="关联" handler="associateProject"
                    icon="${pageContext.request.contextPath}/common/images/option.png"/>
        </g:toolbar>
        <g:field fieldname="WORKFLOW_INSTANCE_NAME" header="项目名称" width="230" renderer="showHandler"/>
        <g:field fieldname="WORKFLOW_NAME" header="流程类型" width="80"/>
        <g:field fieldname="CREATE_TIME" header="开始时间" width="80" renderer="dateformat" sortable="true"/>
        <g:field fieldname="FINISH_TIME" header="结束时间" width="80" renderer="dateformat" sortable="true"/>
        <g:field fieldname="CREATE_USERNAME" header="创建人" width="80"/>
        <g:field fieldname="REMARK" header="备注" width="85" renderer="showHandler"/>
        <g:field fieldname="WORKFLOW_INSTANCE_ID" header="" hidden="true"/>
    </g:list>
</div>
</body>
</html>
