<%@ page language="java" pageEncoding="utf-8" %>
<%@ taglib prefix="g" uri="/gtis-tags" %>
<%@ taglib prefix="s" uri="/struts-tags" %>
<html>

<head>
    <title>日志分析</title>
    <g:head useExt4="true"/>
    <script type="text/javascript">
        var store1;
        Ext.require('Ext.chart.*');
        Ext.require('Ext.layout.container.Fit');
        Ext.onReady(function () {
            Ext.define('User', {
                extend: 'Ext.data.Model',
                fields: ['COUNT', 'CTIME']
            });
            store1 = new Ext.data.Store({
                model: 'User',
                autoLoad : true,
                proxy: {
                    actionMethods: {
                        create: 'POST',
                        destroy: 'DELETE',
                        read: 'POST',
                        update: 'POST'
                    },
                    type: 'ajax',
                    url : 'loglist!getMonthData.action?year=${year}&month=${month}',
                    extraParams:{
                        logaction:'${logaction}'
                    },
                    reader: {
                        type: 'json',
                        root:'RESULT',
                        totalProperty:'MAX'
                    }
                }
            });
            store1.on("load",function(){
                var maxValue=store1.getTotalCount();
                var colCount=this.data.length;
                var chartwidth= colCount*90;
                if (chartwidth<300)
                    chartwidth=300;
                CreateChart(chartwidth,maxValue);
            });

        });

        function CreateChart(chartwidth,maxValue){
            var panel1 = Ext.create('widget.panel', {
                        width: chartwidth,
                        height: 600,
                        renderTo: divchart,
                        layout: 'fit',

                        items: {
                            xtype: 'chart',
                            style: 'background:#fff',
                            animate: true,
                            store: store1,
                            shadow: true,
                            theme: 'Category1',
                            legend: {
                                position: 'right'
                            },
                            axes: [
                                {
                                    type: 'Numeric',
                                    minimum: 0,
                                    maximum: maxValue,
                                    position: 'left',
                                    fields: ['COUNT'],
                                    title: '数量',
                                    grid:true
                                },
                                {
                                    type: 'Category',
                                    position: 'bottom',
                                    fields: ['CTIME'],
                                    title: '日期'
                                }
                            ],
                            series: [
                                {
                                    type: 'column',
                                    highlight: true,
                                    axis: 'left',
                                    xField: 'CTIME',
                                    yField: 'COUNT',
                                    showInLegend:false,
                                    label: {
                                        display: 'insideEnd',
                                        'text-anchor': 'middle',
                                        field: 'COUNT',
                                        orientation: 'vertical',
                                        color: '#333'
                                    }
                                }

                            ]
                        }
                    });
        }
    </script>
</head>
<body>
<div>
    <s:form theme="simple">
    <table>
        <tr>
            <td style="font-size:13px">年</td>
            <td style="font-size:13px"><s:select name="year" list="{'2010','2011','2012','2013','2014','2015'}" theme="simple" value="year"></s:select></td>
            <td style="font-size:13px">月</td>
            <td style="font-size:13px"><s:select name="month" list="{'1','2','3','4','5','6','7','8','9','10','11','12'}" theme="simple" value="month"></s:select>
            </td>
            <td style="font-size:13px">日志类型</td>
            <td style="font-size:13px"><s:select name="logaction" list="{'登陆','转发','删除'}" emptyOption="true"   theme="simple" value="logaction"></s:select>
            </td>
            <td style="font-size:13px"><s:submit value="统 计" action="loglist!statmonth"></s:submit></td>
        </tr>
    </table>
    </s:form>
</div>
<div id="divchart"></div>
</body>
</html>