// ext实例展示的js文件
//Ext.QuickTips.init();//加载快速提示框
Ext.namespace('Egov_Ext');//创建名字域

//应用程序主页面
Egov_Ext.app = function() {
    //空函数
};

Ext.app.resourceLoad = Ext.extend(Ext.ux.XmlTreeLoader, {
            processAttributes : function(attr) {
                attr.text = attr.Name;
                attr.id = attr.Id;
                attr.loaded = true;
                if (attr.Type == "0") {
                    attr.leaf = false;
                    attr.expanded = true;
                } else {
                    attr.leaf = true;
                }
                //alert(attr.text  + attr.leaf);
            }
        });

Ext.extend(Egov_Ext.app, Ext.util.Observable, {
            //顶端
            header:new Ext.BoxComponent({
                        region:'north',
                        el:'lyrtop',
                        height:94,
                        margins:'2'
                    }),
            //实例菜单树形
            menuTree:new Ext.tree.TreePanel({
                        title:'系统菜单',
                        el:'lyrtree',
                        region:'west',
                        id:'lyrtree',
                        autoScroll:true,
                        enableDD:false,//是否支持拖拽效果
                        containerScroll: true,//是否支持滚动条
                        split:true,
                        width: 190,
                        border:false,
                        minSize: 130,
                        maxSize: 300,
                        rootVisible:false,//是否显示跟节点
                        //collapseMode:'mini',//在分割线处出现按钮
                        collapsible: true,
                        margins:'0 0 6 6',
                        loader: new Ext.app.resourceLoad({
                                    dataUrl:_menuurl
                                }),
                        tools:[
                            {
                                id:'refresh',
                                handler:function() {
                                    var tree = Ext.getCmp('lyrtree');
                                    tree.root.reload();
                                }
                            }
                        ]
                    }),
            //菜单根节点
            menuRoot: new Ext.tree.AsyncTreeNode({
                        text:'系统菜单',
                        draggable:false,
                        id:'source'
                    }),
            //主要显示区
            main:new Ext.TabPanel({
                        id:'maintab',
                        region:'center',
                        enableTabScroll:true,
                        activeTab:0,
                        el:'lyrmain',
                        margins:'0 6 7 0'
                    }),

            //初始化构造函数
            init:function() {
                this.menuTree.setRootNode(this.menuRoot);
                this.menuRoot.expand();
                //给树形菜单添加事件
                this.menuTree.on('click', this.menuClickAction, this);
                //给main的tab页面添加tabchange事件
                this.main.on('tabchange', this.changeTab, this);
                var myView = new Ext.Viewport({
                            layout:'border',
                            border:false,
                            items:[this.header,this.main,this.menuTree]
                        });
                //新建一个mask
                this.loadMask = new Ext.LoadMask(this.main.body, {msg:"页面加载中……"});
            },

            //属性菜单的点击事件
            menuClickAction:function(node) {
                //alert(node.isLeaf());
                if (!node.isLeaf()) {
                    return false;
                }
                var tabId = 'tab-' + node.id;
                var tabTitle = node.text;
                var tablink = _resourceUrl + node.id;
                var tabJsArray = node.attributes.jsArray;//得到js文件存放的路径
                var tab = this.main.getComponent(tabId);//得到tab组建
                //alert(tablink);
                if (!tab) {
                    var html = '<iframe id=\'frame_' + node.id + '\' src=\'' + tablink + '\' width="100%" height="100%" frameborder="0"></iframe>';
                    tab = this.main.add(new Ext.Panel({id:tabId,title:tabTitle,autoScroll:true,layout: 'fit',border:false,closable:true,html:html}));
                    this.main.setActiveTab(tab);
                    //var loadmask = this.loadMask;
                    //var model;//加载模块js预置变量名
                    //loadmask.show();
                } else {
                    this.main.setActiveTab(tab);
                    var ff = document.getElementById('frame_' + node.id);
                    if (ff)
                        ff.src = tablink;
                }
                return false;
            },
            //change的实现
            changeTab:function(tab, newtab) {
                if (!newtab)
                    return;
                //如果存在相应树节点，就选中,否则就清空选择状态
                var nodeId = newtab.id.replace('tab-', '');
                var node = this.menuTree.getNodeById(nodeId);
                if (node) {
                    this.menuTree.getSelectionModel().select(node);
                } else {
                    this.menuTree.getSelectionModel().clearSelections();
                }
            }
        });

Ext.onReady(function() {
    var app = new Egov_Ext.app();
    app.init();

    app.menuTree.on('load', function(node, e) {
        var fNode = getFirstRootNode(node);
        //alert(fNode.text+"]]" );
        if (fNode != null)
            app.menuClickAction(fNode);
    });
    //任务前面的办理信息
    $.post("./taskinfo.action", {taskid:$("#taskid").val()},
            function (data) {
                if (data && data.length > 0)
                    $("#div_info").html(data);
            });


});

function getFirstRootNode(node) {
    //alert(node.firstChild.text+"]]" + node.firstChild.isLeaf());
    if (node.firstChild == null) {
        return null;
    }

    if (_defaultName != "") {
        for (var i = 0; i < node.childNodes.length; i++) {
            if (node.childNodes[i].text == _defaultName) {
                return node.childNodes[i];
            }
        }
    }
    if (node.firstChild.isLeaf()) {
        if (node.firstChild != null) {
            return node.firstChild;
        } else {
            return null;
        }
    } else {
        return getFirstRootNode(node.firstChild);
    }

}

function exit() {
    if (confirm("是否确认退出！")) {
        refreshTask();
    }
}

function turn(taskId) {
    var strurl = "./taskturn.action?taskid=" + taskId;
    var returnstr;

    if (/msie 6/i.test(navigator.userAgent)) {
        //判断是否ie6
        returnstr = showwindow(strurl, null, 640, 285);
    } else if (Ext.isGecko) {
        returnstr = showwindow(strurl, null, 640, 335);
    } else {
        returnstr = showwindow(strurl, null, 640, 335);
    }
    if (returnstr == "turnok") {
        refreshTask();
    }
}

function turnEnd(taskId) {
    if (!confirm("是否确认进行办结！")) {
        return;
    }
    var taskEndUrl = "./taskturn!TurnTask.action?taskid=" + taskId;
    var trunInfo = "<Activitys><ReMark><text/></ReMark></Activitys>";
    ajaxCaller.postXML(taskEndUrl, trunInfo, function(backxml) {
        if (backxml == 'true') {
            refreshTask();
        } else {
            alert(backxml);
        }
    });  	//开始提交
}

function taskmodify(taskId) {
    var strurl = "./taskmodify.action?taskid=" + taskId;
    var returnstr = showwindow(strurl, null, 640, 335);
    if (returnstr == "true") {
        window.location.reload();
    }
}

function taskSave(taskId) {
    var activeTab = Ext.getCmp("maintab").getActiveTab();
    if (activeTab) {
        var iframeId = activeTab.getItemId();
        $("#" + iframeId).contents().find("iframe").each(function() {
            $(this).contents().find("iframe[id='frameMain']").each(function() {
                try {
                    var conWin = this.contentWindow;
                    if (conWin.save) {
                        conWin.save();
                    } else {
                        $(this).contents().find(":button").each(function() {
                            if ($(this).attr("save") == "platform") {
                                $(this).click();
                            }
                        });
                    }
                } catch(e) {
                    alert(e);
                }
            });
            var wFrame = window.frames($(this).attr("id"));
            if (wFrame.save) {
                wFrame.save();
            }
        });
    }
}

function taskremark(taskId) {
    var strurl = "./taskremark.action?taskid=" + taskId;
    var returnstr = showwindow(strurl, null, 640, 235);
}


function delothertask(taskId) {
    if (!confirm("是否确认取件！")) {
        return;
    }
    var strurl = "./task!delOtherTasks.action?taskid=" + taskId;
    $.post(strurl, function(data) {
        data = $.trim(data);
        if (data == "true" || data == "1") {
            alert("取件成功！");
        } else {
            alert(data);
            refreshTask();
        }
    });
}

function refreshTask() {
    Ext.util.Cookies.set('portlet_key', 'tasklist');

    try {
        opener.refreshTask(); //刷新父页面
    } catch(ex) {

    }
    //alert("asdf111");

    window.close();
}
function turnback(taskId) {
    var strurl = "./taskturnback.action?taskid=" + taskId;
    var returnstr = showwindow(strurl, null, 640, 335);
    if (returnstr == "turnok") {
        refreshTask();
    }
}

function deltask(taskid) {
    if (!confirm("是否确认进行删除！")) {
        return;
    }
    var delUrl = "./task!del.action?taskid=" + taskid;
    $.post(delUrl, function(data) {
        data = $.trim(data);
        if (data == "true" || data == "1") {
            alert("删除成功！");
            refreshTask();
        } else {
            alert("该任务无法删除！");
        }
    });
}

function quickTurn(taskid) {
    if (!confirm("是否确认进行转发吗！")) {
        return;
    }
    var getUrl = "./task.action?taskid=" + taskid;
    $.ajax({
        url: getUrl,
        async: false,
        success:function(msg) {
            if (msg != "" && msg != "true") {
                alert(msg);
            } else {
                window.returnValue = "turnok";
                Ext.util.Cookies.set('portlet_key', 'tasklist');
                refreshTask();
                window.close();
            }
    }});
}

function popmessage() {
    var speed = 500;
    $("#divmsg").toggle("slow");
}





