// ext实例展示的js文件
//Ext.QuickTips.init();//加载快速提示框
Ext.namespace('Egov_Ext');//创建名字域

//应用程序主页面
Egov_Ext.app = function() {
    //空函数
};

Ext.extend(Egov_Ext.app, Ext.util.Observable, {
    //顶端
    header:new Ext.BoxComponent({
        region:'north',
        el:'lyrtop',
        height:94,
        margins:'2'
    }),
    //实例菜单树形
    menuTree:new Ext.tree.TreePanel({
        title:'系统菜单',
        el:'lyrtree',
        region:'west',
        id:'lyrtree',
        border:false,
        autoScroll:true,
        enableDD:false,//是否支持拖拽效果
        containerScroll: true,//是否支持滚动条
        split:true,
        width: 180,
        minSize: 180,
        maxSize: 300,
        rootVisible:false,//是否显示跟节点
        //collapseMode:'mini',//在分割线处出现按钮
        collapsible: true,
        margins:'0 0 6 6',
        loader:new Ext.tree.TreeLoader({
            dataUrl:_menuurl
        }),
        tools:[
            {
                id:'refresh',
                handler:function() {
                    var tree = Ext.getCmp('lyrtree');
                    tree.root.reload();
                }
            }
        ]
    }),
    //菜单根节点
    menuRoot: new Ext.tree.AsyncTreeNode({
        text:'系统菜单',
        draggable:false,
        id:'source'
    }),
    //主要显示区
    main:new Ext.TabPanel({
        id:'maintab',
        region:'center',
        enableTabScroll:true,
        activeTab:0,
        el:'lyrmain',
        margins:'0 6 7 0'
    }),

    //初始化构造函数
    init:function() {
        this.menuTree.setRootNode(this.menuRoot);
        this.menuRoot.expand();
        //给树形菜单添加事件
        this.menuTree.on('click', this.menuClickAction, this);
        //给main的tab页面添加tabchange事件
        this.main.on('tabchange', this.changeTab, this);
        var myView = new Ext.Viewport({
            layout:'border',
            border:false,
            items:[this.header,this.main,this.menuTree]
        });
        //新建一个mask
        this.loadMask = new Ext.LoadMask(this.main.body, {msg:"页面加载中……"});
    },

    //属性菜单的点击事件
    menuClickAction:function(node) {
        //alert(node.isLeaf());
        if (!node.isLeaf()) {
            return false;
        }
        var tabId = 'tab-' + node.id;
        var tabTitle = node.text;
        var tablink = _resourceUrl + node.id;
        var tabJsArray = node.attributes.jsArray;//得到js文件存放的路径
        var tab = this.main.getComponent(tabId);//得到tab组建
        //alert(tablink);
        if (!tab) {
            var html = '<iframe id=\'frame_' + node.id + '\' src=\'' + tablink + '\' width="100%" height="100%" frameborder="0"></iframe>';
            tab = this.main.add(new Ext.Panel({id:tabId,title:tabTitle,autoScroll:true,layout: 'fit',border:false,closable:true,html:html}));
            this.main.setActiveTab(tab);
            //var loadmask = this.loadMask;
            //var model;//加载模块js预置变量名
            //loadmask.show();
        } else {
            this.main.setActiveTab(tab);
            var ff = document.getElementById('frame_' + node.id);
            if (ff)
                ff.src = tablink;
        }
        return false;
    },
    //change的实现
    changeTab:function(tab, newtab) {
        if (!newtab)
            return;
        //如果存在相应树节点，就选中,否则就清空选择状态
        var nodeId = newtab.id.replace('tab-', '');
        var node = this.menuTree.getNodeById(nodeId);
        if (node) {
            this.menuTree.getSelectionModel().select(node);
        } else {
            this.menuTree.getSelectionModel().clearSelections();
        }
    }
});

Ext.onReady(function() {
    var app = new Egov_Ext.app();
    app.init();

    app.menuTree.on('load', function(node, e) {
        var fNode = getFirstRootNode(node);
        //alert(fNode.text+"]]" );
        if (fNode != null)
            app.menuClickAction(fNode);
    });
});

function getFirstRootNode(node) {
    //alert(node.firstChild.text+"]]" + node.firstChild.isLeaf());
    if (node.firstChild == null) {
        return null;
    }
    if (node.firstChild.isLeaf()) {
        if (node.firstChild != null) {
            return node.firstChild;
        } else {
            return null;
        }
    } else {
        return getFirstRootNode(node.firstChild);
    }
}

function exit() {
    window.close();
}








	
