<?xml version='1.0'?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<!--
命名模板
用来解释Select类型的Select控件 
对应type类型为：Select
Select没有字段类型
-->
<xsl:template name="SelectTemplate">
		<xsl:param name="Id"/><!--编号-->
		<xsl:param name="Name"/><!--名称-->
		<xsl:param name="Value"/><!--控件值-->
		<xsl:param name="DefaultValue"/><!--控件缺省值-->
		<xsl:param name="Disabled"/><!--控件是否可用-->
		<xsl:param name="Index"/>
		<xsl:param name="Style"/>
		<xsl:param name="ClassName"/>
		<xsl:variable name="TextValue">   <!--得到正式的值-->
			<xsl:choose>
				<xsl:when test="$Value=''">
					<xsl:value-of select="$DefaultValue"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="$Value"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="Class" select="concat('selectinput ',$ClassName)"/> 
		<xsl:variable name="SelectStyle" select="concat($Style,';width:100%')"/> 
		<xsl:variable name="SelectText" select="//SelectConfig[@Id=$Id]/SelectElement[@Value=$TextValue]/@Text"/>   <!--得到正式的值-->
		<xsl:choose>
				<xsl:when test="$Disabled='true'">
					<xsl:variable name="selectdata">
						[<xsl:for-each select="//SelectConfig[@Id=$Id]/SelectElement">
						['<xsl:value-of disable-output-escaping="yes"  select="@Value"/>', '<xsl:value-of disable-output-escaping="no" select="@Text"/>'],
						</xsl:for-each>['','']]
					</xsl:variable>
					<input type="text" typeex="select" name="{$Id}" id="{$Id}" 
					title="{$Name}"  value="{$TextValue}" style="{$SelectStyle}" class="{$ClassName}"
					datavalue="{$selectdata}"  readonly="true"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:variable name="selectdata">
						[<xsl:for-each select="//SelectConfig[@Id=$Id]/SelectElement">
						['<xsl:value-of disable-output-escaping="yes"  select="@Value"/>', '<xsl:value-of disable-output-escaping="no" select="@Text"/>'],
						</xsl:for-each>['','']]
					</xsl:variable>
					<input type="text" typeex="select" name="{$Id}" id="{$Id}" 
					title="{$Name}"  value="{$TextValue}" style="{$SelectStyle}" class="{$ClassName}"
					datavalue="{$selectdata}" />
				</xsl:otherwise>
		</xsl:choose>
</xsl:template>

</xsl:stylesheet>