<?xml version='1.0'?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<!--
命名模板
用来解释password类型的input控件 
对应type类型为：Password
password没有缺省值，没有字段类型
-->
<xsl:template name="PasswordTemplate">
	    <xsl:param name="Id"/><!--编号-->
		<xsl:param name="Name"/><!--名称-->
		<xsl:param name="Disabled"/><!--控件是否可用-->
		<xsl:param name="Index"/>
		<xsl:param name="Style"/>
		<xsl:param name="ClassName"/>
		<xsl:variable name="Class" select="concat('input_default ',$ClassName)"/> 
		<xsl:choose>
				<xsl:when test="$Disabled='true'">
					<input type="password" name="{$Id}" id="{$Id}" title="{$Name}" disabled="disabled"  value=""  style="{$Style}"  class="{$Class}"  readonly="true"  />
				</xsl:when>
				<xsl:otherwise>
					<input type="password" name="{$Id}" id="{$Id}" title="{$Name}"  value=""  style="{$Style}" class="{$Class}" tabindex="{$Index}" />
				</xsl:otherwise>
		</xsl:choose>
</xsl:template>
</xsl:stylesheet>