<?xml version='1.0'?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:import href="Element.xsl"/>
	<xsl:import href="GroupDefine.xsl"/>
	<xsl:import href="ElementNull.xsl"/>
	<!--
	内置模板
	匹配所有的/DataSet/Define/ElementDefine节点，
	GroupDefine下的ElementDefine
	-->
	<xsl:template match="//Define/ElementDefine">
		<xsl:param name="Style"/><!--样式-->
		<xsl:param name="ClassName"/><!--自定义CSS-->
		<xsl:call-template name="Element">
				<xsl:with-param name="Id" select="@Id"/>
				<xsl:with-param name="LineIndex"></xsl:with-param>
				<xsl:with-param name="Style" select="$Style"/>
				<xsl:with-param name="ClassName" select="$ClassName"/>
		</xsl:call-template>
	</xsl:template>
	
	<xsl:template match="//ElementData">
		<xsl:param name="Style"/><!--样式-->
		<xsl:param name="ClassName"/><!--自定义CSS-->
		<xsl:call-template name="Element">
				<xsl:with-param name="Id" select="@Id"/>
				<xsl:with-param name="LineIndex"></xsl:with-param>
				<xsl:with-param name="Style" select="$Style"/>
				<xsl:with-param name="ClassName" select="$ClassName"/>
		</xsl:call-template>
	</xsl:template>
	
	<xsl:template match="//GroupData/LineData/ElementData">
		<xsl:param name="Style"/><!--样式-->
		<xsl:param name="ClassName"/><!--自定义CSS-->
		<xsl:call-template name="Element">
				<xsl:with-param name="Id" select="@Id"/>
				<xsl:with-param name="LineIndex" select="parent::LineData/@Index"/>
				<xsl:with-param name="ClassName" select="$ClassName"/>
				<xsl:with-param name="Style">height:21px</xsl:with-param>
		</xsl:call-template>
	</xsl:template>
	
	<xsl:template name="ElementJs">
		<link href="./css/standard.css" type="text/css" rel="stylesheet"/>
        <script type="text/javascript" src="/platform/global/jquery/jquery-1.4.2.min.js"></script>
		<script type="text/javascript" src="./js/jquery.contextMenu.js"></script>
		
		<script type="text/javascript" src="./js/clientevent.js"/>
		<script type="text/javascript" src="./js/gridevent.js"/>  
		<script type="text/javascript" src="./js/checkvalue.js"/>
		<script type="text/javascript" src="./js/forminit.js"/>
		
		<link rel="stylesheet" type="text/css" href="/platform/global/ext/resources/css/ext-all.css" />
		<script type="text/javascript" src="/platform/global/ext/ext-base.js" ></script>
		<script type="text/javascript" src="/platform/global/ext/ext-all.js" ></script>
		<script type="text/javascript" src="/platform/global/ext/ext-lang-zh_CN.js" ></script>
		<script type="text/javascript">
		<![CDATA[
		Ext.BLANK_IMAGE_URL = "/platform/global/ext/resources/images/default/s.gif";
		$(function(){
			try{
				forminit();
			}catch(ex){
			}
			try{
				body_onload();
			}catch(ex){
			}
		});
		]]> 
		</script>
	</xsl:template>
</xsl:stylesheet>