var excWin;
var win;
Ec.showListWin=function(instanceId,instanceName){
            	
	//定义READER
	var reader = new Ext.data.JsonReader({
	    totalProperty: 'totalCount', 
	    root:'root',
		fields: [
	        'SUPER_ID',
	        'ACTIVITY_NAME',
	        'SUPER_TIME',
	        'USER_NAME'
	    ]    
	});
			
	var params = { 
		"workflowInstanceId":instanceId
	}
	var jsonStore=new Ext.data.GroupingStore({
		reader : reader,
		proxy : new Ext.data.HttpProxy({
			url : convertURL("supervise!superListByInstanceId.action")
		}),
		groupField:'ACTIVITY_NAME',
		sortInfo: {
			field: 'SUPER_TIME',
			direction: 'ASC'
		},
		listeners:{
			'load':function(store,records,options){
				groupGrid.fireEvent('rowclick',groupGrid,0);
			}
		}
	});
				 				
	jsonStore.load({params:params});
	   			
	var groupGrid= new Ext.grid.GridPanel({
		store:jsonStore,
		collapsible: false,
    	view : new Ext.grid.GroupingView({
			   	forceFit : true,
			 	groupTextTpl : '{text} ({[values.rs.length]} {[values.rs.length > 1 ? "条" : "条"]})'
			   }),
		split : true,
  		cm:new Ext.grid.ColumnModel([{
				header:"督办来源",
				dataIndex:"USER_NAME",
				renderer:source,
				width:80
			},{
				header:"活动名称",
				dataIndex:"ACTIVITY_NAME",
				width:110
			},{
				header:"督办时间",
				dataIndex:"SUPER_TIME",
				width:60,
				renderer:dateformat2
			},
			{
				dataIndex:"SUPER_ID",
				hidden:true
			}]),
			listeners:{'rowclick':function (grid,rindex,event){
									  var params = { 
									  	"supervisorVo.supervisorInfoId":grid.store.getAt(rindex).data.SUPER_ID
									  }
								
									  Ext.Ajax.request({
									    params: params,
									    method:'POST',
									    url:convertURL("supervise!superDetail.action"),
									    success:function(response, opts) {
									    	var obj = Ext.decode(response.responseText);
									    	var explain='<p style=\"font-family:\'微软雅黑\';font-size: \'11px\'\"><br/><a style="font-weight:bold;">&nbsp;&nbsp;详细信息：</a>' + obj.INFO;
                                            var reply='';
                                            if(obj.SUPERVISOR_EXPLAIN){
                                                reply='<br/><br/><a a style="font-weight:bold;">&nbsp;&nbsp;督办回复：</a>' + obj.SUPERVISOR_EXPLAIN + '</p>';
                                            }
									    	Ext.getCmp("showDetailInfo").body.update(explain + reply);
									    },
									    failure: function(response, opts) {
									    	Ext.Msg.alert('提示','数据请求失败！错误码：' + response.status);
										}
								   });
								 }
					  }
	});
	   			
	if (win){
		win.close();
	}
	   				
	win = new Ext.Window({
		title:'['+Ext.util.Format.ellipsis(instanceName,36)+']<strong>督办列表</strong>',
        closable:true,
        width:550,
        height:350,
        plain:true,
        resizable : false,
        layout: 'border',
        items:[{
        		xtype:'panel',
        		//width:400,
        		height:300,
        		region: 'center',
        		layout:'fit',
            	split: true,
            	items:groupGrid
        	},{
        		id:'showDetailInfo',
				height:100,
				region: 'south',
		    	split: true,
		    	bodyStyle: 'padding-bottom:15px;background:#eee;'	
			}
        ]
        
	});
	win.show();
	   		
	function source(val,p,record){
			var name=record.data.USER_NAME;
			if(name!=null&&name!=""){
				return name;
			}else{
				return "系统督办";
			}
	}
	
	function dateformat2(val, p, record){
  		if (val){
  			return val.replace('T',' ');
  		}
  	}
}
Ec.getExceptionList = function(workflowInstanceId,activityId,exceptionType) {
	function dateformat(val, p, record){
  		if (val && val!=''){
  			if (val.length==19)
  				return val.substring(0,10);
  		}
  	}
	
	function checkResult(val,p,record){
		var isSure = record.data.IS_SURE;
		if(isSure == 1){
			isSure = "属实";
		}else {
			isSure ="不属实";
		}
		
		return isSure;
	}
	
	function optionHandler(val,p,record){
		var exceptionId = record.data.EXCEPTION_ID
		var isSure = record.data.IS_SURE;
		var checkInfo = record.data.CHECK_INFO || '';
		var checkTime = record.data.CHECK_TIME || '';
		var checkUserId = record.data.CHECK_USER_ID || '';
		var checkUserName = record.data.CHECK_USER_NAME || '';
		
		var optionIcon = "<div align='center'><img src='common/images/option.png' style='text-align:center' style=\"cursor : hand\" onclick=\"javascript:Ec.exceptionDelete(\'" + exceptionId + "\',\'" + isSure + "\',\'" + checkInfo + "\',\'" + checkTime + "\',\'" + checkUserId + "\',\'" + checkUserName + "\') \"/></div>";	
		
		return optionIcon;
	}
	
	function exceptionTypeFormat(val,p,record){
		var exceptionType = record.data.EXCEPTION_TYPE;
		if(exceptionType == 1){
			exceptionType = "岗位异常";
		}else if(exceptionType == 2){
			exceptionType = "事项异常";
		}else if(exceptionType == 3){
			exceptionType = "流程异常";
		}else if(exceptionType == 4){
			exceptionType = "决定异常";
		}else if(exceptionType == 5){
			exceptionType = "收费异常";
		}else if(exceptionType == 6){
			exceptionType = "挂起异常";
		}else if(exceptionType == 7){
			exceptionType = "收费异常";
		}else if(exceptionType == 8){
			exceptionType = "投诉异常";
		}else{
			exceptionType = "考勤异常";
		}
		
		return exceptionType;
	}
	
	//异常列表
	var cm = new Ext.grid.ColumnModel([{
		header:"办理步骤",
		dataIndex:"ACTIVITY_NAME",
		width:75
	},{
		header:"异常类型",
		dataIndex:"EXCEPTION_TYPE",
		width:60,
		sortable: true,
		renderer:exceptionTypeFormat
	},{
		header:"办理人",
		dataIndex:"USER_NAME",
		width:48
	},{
		header:"发生时间",
		dataIndex:"EXCEPTION_REC_TIME",
		width:70,
		renderer:dateformat
	},{
		header:"核实结果",
		dataIndex:"IS_SURE",
		width:60,
		renderer:checkResult
	},{
		header:"核实时间",
		dataIndex:"CHECK_TIME",
		width:70,
		renderer:dateformat
	},{
		header:"核实人",
		dataIndex:"CHECK_USER_NAME",
		width:48
	},{
		header:'操作',
		dataIndex:'OPTION',
		width:38,
		renderer:optionHandler
	}]);
	
	var jsonStore = new Ext.data.JsonStore({
		"fields":['EXCEPTION_ID','WORKFLOW_INSTANCE_ID','EXCEPTION_TYPE','EXCEPTION_REC_TIME','ACTIVITY_ID','USER_ID','DESC_XML','CHECK_USER_ID','IS_SURE','CHECK_TIME','CHECK_INFO','USER_NAME','CHECK_USER_NAME','ACTIVITY_NAME','SUPERVISOR_EXPLAIN'],
		"url":"platform/supervisexception!exceptionList.action",
		listeners:{
			'update':function(store,record,opt){
				Ext.getCmp('statGrid').getSelectionModel().selectRow(0,false);
				Ext.getCmp('statGrid').fireEvent('rowclick',Ext.getCmp('statGrid'),0);
			},
			'load':function(store,record,opt){
				Ext.getCmp('statGrid').getSelectionModel().selectRow(0,false);
				Ext.getCmp('statGrid').fireEvent('rowclick',Ext.getCmp('statGrid'),0);
			}
		}
	});
	
	var params = {
		"exceptionVo.workflowInstanceId":workflowInstanceId || '',
		"exceptionVo.activityId":activityId || '',
		"exceptionVo.exceptionType":exceptionType || ''
	};
	
	jsonStore.load({params:params});
			
	if(excWin)
		excWin.hide();
	excWin = new Ext.Window({
		title:"异常处理",
      	closable:true,
      	width:517,
     	height:350,
     	loadMask: true,
      	plain:true,
      	resizable : true,
      	layout: 'border',
      	items: [{
      		xtype:'panel',
      		region: 'center',
      		layout: 'border',
       		items:[{
	       		xtype:'grid',
	       		id:'statGrid',
				"cm":cm,
				sm:new Ext.grid.RowSelectionModel({singleSelect:true}),
				store:jsonStore,
				autoScroll: true,
				height:160,
				width:500,
				region: 'north',
				listeners:{
					'rowclick':function (grid,rindex,event){
						var supervisorExplain = grid.getStore().getAt(rindex).data.SUPERVISOR_EXPLAIN;
						var descXml;
						if(supervisorExplain != null && supervisorExplain != ''){
							descXml = '<p style=\"font-family:\'微软雅黑\';font-size: \'11px\'\"><br/><strong>&nbsp;&nbsp;异常描述：</strong>' + grid.getStore().getAt(rindex).data.DESC_XML + '<br/><br/>&nbsp;&nbsp;<strong>回复督办：</strong>' + supervisorExplain + '</p>';
							Ext.getCmp("editpanel").hide();
							Ext.getCmp("detailPanel").setHeight(190);
						}else{
							if(grid.getStore().getAt(rindex).data.USER_ID == currentUserId){
								descXml = '<p style=\"font-family:\'微软雅黑\';font-size: \'11px\'\"><br/><strong>&nbsp;&nbsp;异常描述：</strong>' + grid.getStore().getAt(rindex).data.DESC_XML + '</p>';
								Ext.getCmp("editpanel").show();
								Ext.getCmp("detailPanel").setHeight(110);
							}else {
								descXml = '<p style=\"font-family:\'微软雅黑\';font-size: \'11px\'\"><br/><strong>&nbsp;&nbsp;异常描述：</strong>' + grid.getStore().getAt(rindex).data.DESC_XML + '<br/><br/>&nbsp;&nbsp;<strong>回复督办：</strong><span style=\"color: red\">未回复</span></p>';
								Ext.getCmp("editpanel").hide();
								Ext.getCmp("detailPanel").setHeight(190);
							}
						}
						Ext.getCmp("detailPanel").body.update(descXml);
					}
				}
			},{
				region: 'center',
				xtype: 'panel',
				title: '详细信息',
				height:190,
				id: 'detailPanel',
				bodyStyle: 'padding-bottom:15px;background:#eee;'				
			},{
				region: 'south',
				xtype: 'panel',
				height:50,
				hidden:true,
				id: 'editpanel',
				layout: 'border',
				items:[{
					region: 'center',
					xtype: 'textarea',
					id: 'editTextArea'
				},{
					region: 'east',
					width:80,
					xtype: 'button',
					text:'回复督办',
					id: 'editbut',
					listeners:{
						'click':function (){
							var statGrid = Ext.getCmp('statGrid');
							var selectedModel = statGrid.getSelectionModel();
							var selectedRecord = selectedModel.getSelected();
							
							if(selectedRecord){
								var supervisorExplain = selectedRecord.data.SUPERVISOR_EXPLAIN;
								var editTextAreaText = Ext.getCmp('editTextArea').getValue().trim();
								
								if(editTextAreaText.length > 250){
									Ext.Msg.alert('提示',"异常解释字符不能超过250个汉字！");
								}else if(editTextAreaText.length == 0) {
									Ext.Msg.alert('提示',"解释不能为空！");
								}else {
									var params_e = {
										"supervisorVo.exceptionId":selectedRecord.data.EXCEPTION_ID,
										"supervisorVo.supervisorExplain":editTextAreaText
									}
									Ext.Ajax.request({
									    form: 'some-form',
									    params: params_e,
									    method:'POST',
									    url:'supervisexception!revertSuperviseExplain.action',
									    success:function(response, opts) {
									    	var obj = Ext.decode(response.responseText);
									    	if(obj.revertResult == true){
									    		selectedRecord.data.SUPERVISOR_EXPLAIN = editTextAreaText;
									    		statGrid.fireEvent('rowclick',statGrid,statGrid.getStore().indexOf(selectedRecord));
									    		Ext.getCmp('editTextArea').setValue("");
									    		Ext.Msg.alert('提示','回复成功！');
									    	}else {
									    		Ext.Msg.alert('提示','回复失败！');
									    	}
									    },
									    failure: function(response, opts) {
									    	Ext.Msg.alert('提示','回复失败！错误码：' + response.status);
										}
									});
								}
							}else {
								Ext.Msg.alert('提示',"请选择要回复的异常！");
							}
						}
					}	
				}]			
			}],
	 		margins:'3 0 3 3',
	 		cmargins:'3 3 3 3'
		}]
	});
	excWin.show(this);
}

var supWin;

Ec.superviseActivity = function(workflowInstanceId,workflowName){
    shortWFName= Ext.util.Format.ellipsis(workflowName,25);
	//debugger;
	supWin = new Ext.Window({
		title:"活动督办",
      	closable:true,
      	width:550,
     	height:320,
     	loadMask: true,
      	plain:true,
      	resizable : true,
      	layout: 'border',
      	items: [{
      		id:'activityTree',
      		region: 'west',
      		xtype:'treepanel',
      		width:'34.2%',
      		animate:true,
      		useArrows:true,
      		listeners:{
      			'checkchange':function(node,checked){
      				if(!node.attributes.leaf){
      					Ext.each(node.childNodes,function(n){
      						if(checked != n.attributes.checked){
      							n.getUI().toggleCheck();
      						}
      					});
      				}else{
      					
      				}
      			}
      		},
      		enableDD:false,
      		autoScroll:true,
      		containerScroll:true,
      		rootVisible:true,
      		frame: true,
      		split:true,
      		root:{
      			nodeType: 'async',
      			text:shortWFName,
      			singleClickExpand:true,
      			expanded:true
      		},
	        dataUrl: convertURL("supervise!sendSuperActvityInfo.action?supervisorVo.workflowInstanceId=" + workflowInstanceId)
      	},{
      		region:'center',
      		xtype:'panel',
      		split:true,
      		layout: 'border',
      		items:[{
      			region: 'north',
      			xtype:'label',
      			width:'100%',
      			height:'20%',
      			split:true,
      			html:'<p style=\"font-family:\'微软雅黑\';font-size: \'12px\'\"><br/><strong>&nbsp;&nbsp;您正在对项目 ' + workflowName + ' 进行督办 ：</strong>'
      		},{
      			region: 'center',
      			xtype:'panel',
      			title:'督办信息',
      			split:true,
      			items:[{
      				id: 'superviseInfo',
      				xtype:'textarea',
      				height:'100%',
      				width:'100%'
      			}]
      		}],
      		buttonAlign:'center',
      		buttons: [{
	            text: '督办',
	            handler:function(){
	            	var superviseInfo = Ext.getCmp("superviseInfo").getValue().trim();
	            	if(superviseInfo.length > 250){
						Ext.Msg.alert('提示',"办信息字符不能超过250个汉字！");
					}else if(superviseInfo.length == 0) {
						Ext.Msg.alert('提示',"督办信息不能为空！");
					}else {
						var selectNodes = Ext.getCmp("activityTree").getChecked();
						
						var users = new Array();
						Ext.each(selectNodes,function(node){
							if(node.attributes.leaf){
								node.attributes.SUPERVISOR_INFO = superviseInfo;
								users.push(Ext.util.JSON.encode(node.attributes));
							}
						});
						
						if(users.length == 0){
							Ext.Msg.alert('提示',"请选择督办对象！");
						}else {
							var params = {
								"users":users
							};
							Ext.Ajax.request({
								"url":convertURL('supervise!saveSuperInfo.action'),
								"params":params,
								method:'POST',
								success:function(response, opts) {
							    	Ext.Msg.alert('提示','督办成功！');
							    	supWin.close();
                                    var sStat=Ext.getCmp("superviseStat");
                                    if (sStat){
                                        sStat.refresh();
                                    }
							    },
							    failure: function(response, opts) {
							    	Ext.Msg.alert('提示','督办失败！错误码：' + response.status);
								}
							});
						}
					}
	            }
	        },{
	            text: '关闭',
	            handler:function(){
					supWin.close();
	            }
	        }]
      	}],
      	margins:'3 0 3 3',
	 	cmargins:'3 3 3 3'
	});
	
	supWin.show(this);
}

Ec.subServise=function(ids,names){
	var showWin=new Ext.Window({
		title:'发送督办',
		closable:true,
		resizable : false,
		width:500,
		height:250,
		layout:'border',
		items:[
			{
				region: 'center',
				xtype: 'panel',
				html:'&nbsp;&nbsp;<p style=\"font-family:\'微软雅黑\';font-size: \'11px\'\"> &nbsp;&nbsp;您正在对'+names+" 项目进行督办 <br/>&nbsp;&nbsp;处于该项目下的所有活动人员将收到 您发出的督办信息</p>",
				height:170,
				id: 'showInfo',
				bodyStyle: 'padding-bottom:15px;background:#eee;'	
			},{
				region: 'south',
				xtype: 'panel',
				height:80,
				//isvisible:false,
				id: 'editpanel2',
				layout: 'border',
				items:[{
							region: 'center',
							xtype: 'textarea',
							id: 'inputInfo'
							},{
							region: 'east',
							width:80,
							xtype: 'button',
							text:'督办内容',
							id: 'subtn',
							listeners:{'click':function (){
									var inputInfo = Ext.getCmp('inputInfo').getValue().trim();
									
									if(inputInfo.length > 250){
										Ext.Msg.alert('提示',"督办字符不能超过250个汉字！");
									}else if(inputInfo.length == 0) {
										Ext.Msg.alert('提示',"督办内容不能为空！");
									}else {
										var params_e = {
											"ids":ids,
											"superInfo":inputInfo
										}
										Ext.Ajax.request({
										    form: 'some-form',
										    params: params_e,
										    method:'POST',
										    url:'${pageContext.request.contextPath}/supervise!sendSuperInfo.action',
										    success:function(response, opts) {
										    	var obj = Ext.decode(response.responseText);
										    	if(obj.revertResult == true){
										    		//detailStore.getAt(0).data.EXPLAIN= editTextAreaText;
										    		//Ext.getCmp('editTextArea').setValue(editTextAreaText);
                                                    Ext.Msg.show({
                                                       title: '提示',
                                                       msg: '督办成功！',
                                                       width: 150,
                                                       buttons: Ext.MessageBox.OK,
                                                       fn:function(){
                                                          showWin.close();
                                                          var sStat=Ext.getCmp("superviseStat");
                                                          if (sStat){
                                                             sStat.refresh();
                                                          }
                                                       },
                                                       icon: Ext.MessageBox.INFO
                                                    });
                                                    var content='<br/><br/><strong>督办内容：</strong>' + inputInfo + '</p>';
                                                    Ext.getCmp("showInfo").body.update('您已经对项目 '+names+' 进行了督办'+content);
                                                    Ext.getCmp("editpanel2").hide();
                                                    Ext.getCmp("showInfo").setHeight(250);
										    	}else {
										    		Ext.Msg.alert('提示','督办失败！'+obj.revertResult);
										    	}
										    },
										    failure: function(response, opts) {
										    	Ext.Msg.alert('提示','督办失败！错误码：' + response.status);
											}
										});
											
										}
								
									}}	
								}],
			margins:'3 0 3 3',
	 		cmargins:'3 3 3 3'
			}
		]
				
	});
	showWin.show();
}

Ec.exceptionDelete = function(exceptionId,isSure,checkInfo,checkTime,checkUserId,checkUserName){
	var changeStatusWin = new Ext.Window({
		title:'核实',
		width:240,
		height:270,
		layout: 'fit',
        plain:true,
        bodyStyle:'padding:5px;',
        buttonAlign:'center',
        items:[{
        	xtype:'fieldset',
        	defaultType: 'radio',
        	autoHeight: true,
        	height:'125',
        	items:[{
        		id:"isSureCheck",
        		checked:true,
        		fieldLabel:'核实状态',
        		boxLabel:'属实',
        		hideLabel:false,
        		name:'isSureStatus',
        		inputValue:1
        	},{
        		id:"isSureNoCheck",
        		fieldLabel:'',
        		labelSeparator:'',
        		boxLabel:'不属实',
        		name:'isSureStatus',
        		inputValue:0
        	}]
        },{
        	xtype:'label',
        	html :'<strong><p style=\"font-family:\'微软雅黑\';font-size: \'12px\'\">&nbsp;&nbsp;核实信息:</p></strong>'
        },{
        	id:'checkInfo',
    		xtype:'textarea',
    		hideLabel:false,
    		name:'msg',
    		value: checkInfo,
    		width:'100%',
    		height:125
    	}],
        buttons:[{
        	text:'保存',
        	handler:function(){
        		var checkInfo = Ext.getCmp("checkInfo").getValue().trim();
        		if(checkInfo == null || checkInfo == ""){
        			Ext.Msg.alert("提示","核实信息不能为空！");
        		}else if(checkInfo.length >= 250){
        			Ext.Msg.alert("提示","核实信息不能250个汉字");
        		}else {
        			var isSureCheck;
        			
        			if(Ext.getCmp("isSureCheck").checked == true){
        				isSureCheck = Ext.getCmp("isSureCheck").inputValue;
        			}else if(Ext.getCmp("isSureNoCheck").checked == true){
        				isSureCheck = Ext.getCmp("isSureNoCheck").inputValue;
        			}
        			
        			var params = {
        				"exceptionVo.checkInfo" : checkInfo,
        				"exceptionVo.isSure" : isSureCheck,
        				"exceptionVo.exceptionId":exceptionId
        			};
        			
        			Ext.Ajax.request({
        				"url":convertURL("supervisexception!updateExceptionStatus.action"),
        				"params":params,
        				success:function(response, opts) {
					    	Ext.Msg.alert('提示','核实成功！');
					    	Ext.getCmp("statGrid").getStore().reload();
					    	changeStatusWin.close();
					    },
					    failure: function(response, opts) {
					    	Ext.Msg.alert('提示','核实失败！错误码：' + response.status);
						}
        			});
        		}
        	}
        },{
        	text:'关闭',
        	handler:function(){
				changeStatusWin.close();
            }
        }]
	});
	
	if(isSure == 1){
		Ext.getCmp("isSureCheck").checked=true;
		Ext.getCmp("isSureNoCheck").checked=false;
	}else if(isSure == 0){
		Ext.getCmp("isSureCheck").checked=false;
		Ext.getCmp("isSureNoCheck").checked=true;
	}
	
	changeStatusWin.show(this);
}

function convertURL(url) {
    var timstamp = (new Date()).valueOf();
    if (url.indexOf("?") >= 0) {
        url = url + "&t=" + timstamp;
    } else {
        url = url + "?t=" + timstamp;
    }
    return url;
}