/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.web.sign;

import com.gtis.common.util.ObjectJSONUtil;
import com.gtis.plat.service.SysAuthorService;
import com.gtis.plat.service.SysOpinionService;
import com.gtis.plat.service.SysSignService;
import com.gtis.plat.service.SysWorkFlowDefineService;
import com.gtis.plat.service.SysWorkFlowInstanceService;
import com.gtis.plat.vo.PfSignVo;
import com.gtis.plat.vo.PfWorkFlowDefineVo;
import com.gtis.plat.vo.PfWorkFlowInstanceVo;
import com.gtis.web.SessionUtil;
import com.gtis.web.sign.SignUitl;
import com.opensymphony.xwork2.Action;
import java.io.OutputStream;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.struts2.ServletActionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignAction
implements Action {
    private static final Logger logger = LoggerFactory.getLogger(SignAction.class);
    private PfSignVo signVo;
    private List<PfSignVo> lstSign;
    private boolean createNew = true;
    private boolean disabled = false;
    private String opinionType;
    private boolean isOpinion = true;
    private String warrantKey;
    private String rid;
    private SysSignService signService;
    private SysAuthorService authorService;
    private SysOpinionService opinionService;
    private SysWorkFlowDefineService workFlowDefineService;
    private SysWorkFlowInstanceService workFlowInstanceService;
    private String signPoints;

    public void setWorkFlowInstanceService(SysWorkFlowInstanceService workFlowInstanceService) {
        this.workFlowInstanceService = workFlowInstanceService;
    }

    public void setWorkFlowDefineService(SysWorkFlowDefineService workFlowDefineService) {
        this.workFlowDefineService = workFlowDefineService;
    }

    public SysOpinionService getOpinionService() {
        return this.opinionService;
    }

    public void setOpinionService(SysOpinionService opinionService) {
        this.opinionService = opinionService;
    }

    public String getSignPoints() {
        return this.signPoints;
    }

    public void setSignPoints(String signPoints) {
        this.signPoints = signPoints;
    }

    public PfSignVo getSignVo() {
        return this.signVo;
    }

    public void setSignVo(PfSignVo signVo) {
        this.signVo = signVo;
    }

    public String getWarrantKey() {
        return this.warrantKey;
    }

    public void setWarrantKey(String warrantKey) {
        this.warrantKey = warrantKey;
    }

    public boolean isCreateNew() {
        return this.createNew;
    }

    public String getRid() {
        return this.rid;
    }

    public void setRid(String rid) {
        this.rid = rid;
    }

    public void setCreateNew(boolean createNew) {
        this.createNew = createNew;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public List<PfSignVo> getLstSign() {
        return this.lstSign;
    }

    public void setLstSign(List<PfSignVo> lstSign) {
        this.lstSign = lstSign;
    }

    public SysSignService getSignService() {
        return this.signService;
    }

    public void setSignService(SysSignService signService) {
        this.signService = signService;
    }

    public String getOpinionType() {
        return this.opinionType;
    }

    public void setOpinionType(String opinionType) {
        this.opinionType = opinionType;
    }

    public boolean isOpinion() {
        return this.isOpinion;
    }

    public void setOpinion(boolean opinion) {
        this.isOpinion = opinion;
    }

    private void btnDisable() {
        String disable = ServletActionContext.getRequest().getParameter("disable");
        if (!"true".equals(disable)) {
            if (!this.disabled) {
                PfWorkFlowInstanceVo workFlowInstanceVo;
                String from = ServletActionContext.getRequest().getParameter("from");
                String rid = ServletActionContext.getRequest().getParameter("rid");
                String wiid = ServletActionContext.getRequest().getParameter("wiid");
                if (StringUtils.isBlank((String)wiid) && (workFlowInstanceVo = this.workFlowInstanceService.getWorkflowInstanceByProId(this.signVo.getProId())) != null) {
                    wiid = workFlowInstanceVo.getWorkflowIntanceId();
                }
                if (!(StringUtils.isBlank((String)from) || StringUtils.isBlank((String)rid) || StringUtils.isBlank((String)wiid))) {
                    if ("task".equalsIgnoreCase(from)) {
                        String taskid = ServletActionContext.getRequest().getParameter("taskid");
                        this.disabled = this.authorService.queryTaskElement(wiid, taskid, rid, this.signVo.getSignKey());
                    } else if ("pro".equalsIgnoreCase(from)) {
                        String roles = SessionUtil.getUserInfo((HttpServletRequest)ServletActionContext.getRequest()).getRoleIds();
                        this.disabled = true;
                    } else {
                        logger.debug("from is null");
                    }
                }
            }
        } else {
            this.disabled = true;
        }
    }

    public String execute() throws Exception {
        if (this.signVo == null) {
            this.lstSign = new ArrayList();
        } else if (StringUtils.isNotBlank((String)this.signVo.getSignId())) {
            this.lstSign = new ArrayList();
            this.lstSign.add(this.signService.getSign(this.signVo.getSignId()));
        } else {
            this.lstSign = this.signService.getSignList(this.signVo.getSignKey(), this.signVo.getProId());
        }
        this.signVo.setUserId(SessionUtil.getUserId((HttpServletRequest)ServletActionContext.getRequest()));
        this.signVo.setSignName(SessionUtil.getUserName((HttpServletRequest)ServletActionContext.getRequest()));
        if (this.disabled) {
            this.createNew = false;
        } else {
            for (PfSignVo sign : this.lstSign) {
                if (!this.signVo.getUserId().equals(sign.getUserId())) continue;
                this.createNew = false;
                this.signVo = sign;
                break;
            }
        }
        this.btnDisable();
        if (this.isOpinion) {
            return "success";
        }
        return "sign_nooptinion";
    }

    public String image() throws Exception {
        HttpServletResponse resp = ServletActionContext.getResponse();
        resp.setHeader("Cache-Control", "no-cache");
        resp.setHeader("Pragma", "no-cache");
        resp.setDateHeader("Expires", -1L);
        if (StringUtils.isNotBlank((String)this.signVo.getSignId())) {
            PfSignVo signBean = this.signService.getSign(this.signVo.getSignId());
            PfSignVo sign = this.signService.getSignImage(this.signVo.getSignId());
            if (sign == null) {
                IOUtils.write((String)"", (OutputStream)resp.getOutputStream());
            } else if (sign.getSignImage() != null && sign.getSignImage().length > 1000) {
                IOUtils.write((byte[])sign.getSignImage(), (OutputStream)resp.getOutputStream());
            } else if (signBean != null) {
                SignUitl.BuildSignImage((String)signBean.getSignName(), (OutputStream)resp.getOutputStream());
            }
        }
        return "none";
    }

    public String sign() throws Exception {
        PfWorkFlowInstanceVo workflowInstance;
        this.signVo.setSignKey(URLDecoder.decode(this.signVo.getSignKey(), "UTF-8"));
        if (StringUtils.isBlank((String)this.opinionType) && StringUtils.isNotBlank((String)this.signVo.getProId()) && (workflowInstance = this.workFlowInstanceService.getWorkflowInstanceByProId(this.signVo.getProId())) != null) {
            PfWorkFlowDefineVo workFlowDefineVo = this.workFlowDefineService.getWorkFlowDefine(workflowInstance.getWorkflowDefinitionId());
            this.opinionType = workFlowDefineVo.getWorkflowName();
        }
        if (StringUtils.isNotBlank((String)this.signVo.getSignId())) {
            this.signVo = this.signService.getSign(this.signVo.getSignId());
        }
        if (this.signVo.getSignDate() == null) {
            this.signVo.setSignDate(new Date(System.currentTimeMillis()));
        }
        return "sign";
    }

    public String menu() throws Exception {
        String UserId = SessionUtil.getUserId((HttpServletRequest)ServletActionContext.getRequest());
        List lstOpinions = this.opinionService.getOpinionList(UserId, this.opinionType);
        ServletActionContext.getResponse().getWriter().print(ObjectJSONUtil.ObjectToJson((Object)lstOpinions));
        return "none";
    }

    public String signno() throws Exception {
        this.sign();
        return "signno";
    }

    public String autosign() throws Exception {
        PfSignVo sign = this.signService.getSign(this.signVo.getSignId());
        if (sign != null) {
            sign.setSignOpinion(this.signVo.getSignOpinion());
            if (this.signVo.getSignDate() == null) {
                this.signVo.setSignDate(Calendar.getInstance().getTime());
            }
            sign.setSignDate(this.signVo.getSignDate());
            this.signService.updateAutoSign(sign);
            this.signVo = sign;
        } else {
            this.signService.insertAutoSign(this.signVo);
        }
        ServletActionContext.getResponse().getWriter().print(ObjectJSONUtil.ObjectToJson((Object)this.signVo));
        return "none";
    }

    public String savesign() throws Exception {
        PfSignVo sign = this.signService.getSign(this.signVo.getSignId());
        if (sign != null) {
            sign.setSignOpinion(this.signVo.getSignOpinion());
            if (this.signVo.getSignDate() == null) {
                this.signVo.setSignDate(new Date(System.currentTimeMillis()));
            }
            sign.setSignDate(this.signVo.getSignDate());
            sign.setSignType("0");
            this.signService.updateSign(sign);
            this.signService.UpdateCustomSignPic(this.signVo.getSignId(), this.signPoints);
            this.signVo = sign;
        } else {
            String signId = this.signService.AddCustomSign(SessionUtil.getCurrentUserId(), this.signVo.getProId(), this.signVo.getSignKey(), this.signPoints);
            this.signVo.setSignId(signId);
            this.signVo.setSignType("0");
            this.signService.updateSign(this.signVo);
        }
        ServletActionContext.getResponse().getWriter().print(ObjectJSONUtil.ObjectToJson((Object)this.signVo));
        return "none";
    }

    public String saveSignOpinion() throws Exception {
        PfSignVo sign = this.signService.getSign(this.signVo.getSignId());
        if (sign == null) {
            this.signService.insertAutoSign(this.signVo);
        }
        sign.setSignOpinion(this.signVo.getSignOpinion());
        if (this.signVo.getSignDate() == null) {
            this.signVo.setSignDate(Calendar.getInstance().getTime());
        }
        sign.setSignDate(this.signVo.getSignDate());
        this.signService.updateSign(this.signVo);
        ServletActionContext.getResponse().getWriter().print(ObjectJSONUtil.ObjectToJson((Object)this.signVo));
        return "none";
    }

    public String saveSignDate() throws Exception {
        PfSignVo sign = this.signService.getSign(this.signVo.getSignId());
        if (sign == null) {
            this.signService.insertAutoSign(this.signVo);
        }
        if (this.signVo.getSignDate() == null) {
            this.signVo.setSignDate(Calendar.getInstance().getTime());
        }
        sign.setSignDate(this.signVo.getSignDate());
        this.signService.updateSign(sign);
        ServletActionContext.getResponse().getWriter().print(ObjectJSONUtil.ObjectToJson((Object)this.signVo));
        return "none";
    }

    public String deleteSign() throws Exception {
        if (StringUtils.isNotBlank((String)this.signVo.getSignId())) {
            this.signService.deleteSign(this.signVo.getSignId());
        }
        return "none";
    }

    public SysAuthorService getAuthorService() {
        return this.authorService;
    }

    public void setAuthorService(SysAuthorService authorService) {
        this.authorService = authorService;
    }
}

