/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.web.action.sjd;

import com.gtis.common.util.CommonUtil;
import com.gtis.common.util.UUIDGenerator;
import com.gtis.config.AppConfig;
import com.gtis.fileCenter.model.Node;
import com.gtis.fileCenter.model.Space;
import com.gtis.fileCenter.service.NodeService;
import com.gtis.plat.dao.BaseDao;
import com.gtis.plat.form.print.XMLBuildHelper;
import com.gtis.plat.service.SysWorkFlowDefineService;
import com.gtis.plat.service.SysWorkFlowInstanceService;
import com.gtis.plat.vo.PfWorkFlowDefineVo;
import com.gtis.plat.vo.PfWorkFlowInstanceVo;
import com.gtis.plat.vo.SjdVo;
import com.gtis.plat.vo.SjdclVo;
import com.gtis.plat.vo.StuffConfigVo;
import com.gtis.util.SjdUtil;
import com.gtis.web.SessionUtil;
import com.gtis.web.SplitParam;
import java.io.PrintWriter;
import java.net.URLDecoder;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.interceptor.ServletRequestAware;
import org.apache.struts2.interceptor.ServletResponseAware;
import org.apache.struts2.json.JSONUtil;

public class SjdManageAction
implements ServletRequestAware,
ServletResponseAware {
    private Logger logger = Logger.getLogger((String)this.getClass().getName());
    private HttpServletRequest request;
    private HttpServletResponse response;
    private BaseDao sjdDaoImpl;
    private String sjdid;
    private String data_id;
    private SjdVo sjdVo;
    private SjdclVo sjdclVo;
    private String result;
    private String message;
    private SplitParam splitParam;
    private String ids;
    private String state;
    private String proid;
    private List<SjdclVo> sjdclList;
    private String[] data_idArr;
    private Integer[] xhArr;
    private String[] nameArr;
    private Integer[] numArr;
    private Integer[] ysnumArr;
    private Integer[] dbnumArr;
    private String[] bzArr;
    private SysWorkFlowDefineService workFlowDefineService;
    private SysWorkFlowInstanceService sysWorkFlowInstanceService;
    private static final String spacecode = "WORK_FLOW_STUFF";
    private int nodeId;
    private String token;
    private NodeService nodeService;
    private String filename;
    private List<String> listID;
    private String paramString;
    private String configId;
    private String configName;

    public String openSjdInput() throws Exception {
        PfWorkFlowInstanceVo workFlowInstanceVo;
        this.message = "";
        if (StringUtils.isBlank((String)this.proid)) {
            this.proid = UUIDGenerator.generate();
        }
        if ((workFlowInstanceVo = this.sysWorkFlowInstanceService.getWorkflowInstanceByProId(this.proid)) != null && StringUtils.isNotBlank((String)workFlowInstanceVo.getWorkflowDefinitionId())) {
            this.configId = workFlowInstanceVo.getWorkflowDefinitionId();
            PfWorkFlowDefineVo workFlowDefineVo = this.workFlowDefineService.getWorkFlowDefine(this.configId);
            this.configName = workFlowDefineVo.getWorkflowName();
        }
        if (StringUtils.isBlank((String)this.configId)) {
            this.configId = "custom";
        }
        this.sjdVo = (SjdVo)this.sjdDaoImpl.getObject(this.proid, "PROID");
        this.createFileCenterNode(this.proid, spacecode);
        if (this.sjdVo == null) {
            this.sjdVo = new SjdVo();
            this.sjdVo.setProid(this.proid);
            this.sjdVo.setSjdid(UUIDGenerator.generate());
            this.sjdVo.setSjd_sj_date(CommonUtil.getCurrDate());
            this.sjdVo.setSjd_sjr(SessionUtil.getUserName((HttpServletRequest)this.request));
            this.sjdVo.setBusiType(this.configId);
            this.sjdVo.setSjd_sqlx(this.configName);
            this.sjdVo.setSjd_bh_year(Integer.getInteger(CommonUtil.getCurrYear()));
            HashMap<String, Integer> param = new HashMap<String, Integer>();
            param.put("SJD_BH_YEAR", this.sjdVo.getSjd_bh_year());
            Integer bh_xh = (Integer)this.sjdDaoImpl.getObjectByIbatisStr(param, "getMaxSjdXh");
            if (bh_xh == null) {
                bh_xh = 0;
            }
            this.sjdVo.setSjd_bh_xh(Integer.valueOf(bh_xh + 1));
            DecimalFormat decimalFormat = new DecimalFormat("0000");
            String lsh = decimalFormat.format(this.sjdVo.getSjd_bh_xh());
            String bh = "\uff08" + this.sjdVo.getSjd_bh_year() + "\uff09\u7b2c" + lsh + "\u53f7";
            this.sjdVo.setSjd_bh(bh.replaceAll("null", ""));
            this.sjdDaoImpl.insertObject((Object)this.sjdVo);
        }
        this.sjdclList = SjdUtil.getSjdclListBySjdVo((SjdVo)this.sjdVo);
        if (this.sjdclList == null || this.sjdclList.size() == 0) {
            this.sjdclList = this.initDefaultFile(this.sjdVo, this.nodeId, this.configId, this.sjdclList);
        }
        Collections.sort(this.sjdclList);
        SjdclVo clVo = new SjdclVo();
        clVo.setProid(this.sjdVo.getProid());
        clVo.setSjdid(this.sjdVo.getSjdid());
        clVo.setData_id("demo");
        this.sjdclList.add(clVo);
        return "sjdInput";
    }

    public String saveSjdInput() throws Exception {
        this.sjdclList = new ArrayList();
        if (StringUtils.isNotBlank((String)this.sjdVo.getSjdid())) {
            if (this.data_idArr != null && this.data_idArr.length > 0) {
                int i;
                for (i = 0; i < this.nameArr.length; ++i) {
                    String nameA = this.nameArr[i] + "";
                    for (int j = i + 1; j < this.nameArr.length; ++j) {
                        String nameB = this.nameArr[j] + "";
                        if (!nameA.equals(nameB)) continue;
                        this.message = "\u6587\u4ef6\u8d44\u6599\u540d\u79f0\u4e0d\u80fd\u91cd\u590d\uff01";
                        this.result = "false";
                        return "sjdInput";
                    }
                }
                this.createFileCenterNode(this.sjdVo.getProid(), spacecode);
                for (i = 0; i < this.data_idArr.length; ++i) {
                    try {
                        if (this.xhArr[i] == null && StringUtils.isBlank((String)this.nameArr[i]) && this.ysnumArr[i] == null && this.dbnumArr[i] == null && StringUtils.isBlank((String)this.bzArr[i])) continue;
                        SjdclVo vo = new SjdclVo();
                        if (this.data_idArr[i] != null && this.data_idArr[i].equals("demo")) {
                            vo.setData_id(UUIDGenerator.generate());
                        } else {
                            vo.setData_id(this.data_idArr[i]);
                        }
                        vo.setProid(this.sjdVo.getProid());
                        vo.setSjdid(this.sjdVo.getSjdid());
                        vo.setXh(this.xhArr[i]);
                        vo.setName(this.nameArr[i]);
                        vo.setNum(this.numArr[i]);
                        vo.setYsnum(this.ysnumArr[i]);
                        vo.setDbnum(this.dbnumArr[i]);
                        vo.setBz(this.bzArr[i]);
                        Node nodeChild = this.getOrCreateNode(Integer.valueOf(this.nodeId), vo.getName());
                        vo.setNode_id(nodeChild.getId());
                        this.sjdclList.add(vo);
                        continue;
                    }
                    catch (Exception e) {
                        this.logger.error((Object)e.getMessage());
                    }
                }
            }
            try {
                if (this.sjdclList != null) {
                    String clJson = JSONUtil.serialize((Object)this.sjdclList);
                    this.sjdVo.setSjd_cl(clJson.getBytes());
                }
                this.sjdDaoImpl.updateObject((Object)this.sjdVo);
                this.message = "\u64cd\u4f5c\u6210\u529f";
                this.result = "true";
            }
            catch (Exception e) {
                this.message = "\u64cd\u4f5c\u5931\u8d25";
                this.result = "false";
                this.logger.error((Object)e.getMessage());
            }
        }
        Collections.sort(this.sjdclList);
        SjdclVo clVo = new SjdclVo();
        clVo.setProid(this.sjdVo.getProid());
        clVo.setSjdid(this.sjdVo.getSjdid());
        clVo.setData_id("demo");
        this.sjdclList.add(clVo);
        return "sjdInput";
    }

    public String deleteSjdclInput() throws Exception {
        HashMap<String, String> returnMap = new HashMap<String, String>();
        if (StringUtils.isNotBlank((String)this.ids) && StringUtils.isNotBlank((String)this.proid)) {
            String idParam = URLDecoder.decode(this.ids, "utf-8");
            ArrayList<String> nameList = new ArrayList<String>();
            this.sjdVo = (SjdVo)this.sjdDaoImpl.getObject(this.proid, "PROID");
            if (this.sjdVo != null && this.sjdVo.getSjd_cl() != null) {
                List clList = SjdUtil.getSjdclListBySjdVo((SjdVo)this.sjdVo);
                ArrayList hasClList = new ArrayList();
                if (clList != null && clList.size() > 0) {
                    for (int i = 0; i < clList.size(); ++i) {
                        String id = ((SjdclVo)clList.get(i)).getData_id();
                        if (idParam.indexOf(id) > -1 && StringUtils.isNotBlank((String)((SjdclVo)clList.get(i)).getName())) {
                            nameList.add(((SjdclVo)clList.get(i)).getName());
                            continue;
                        }
                        hasClList.add(clList.get(i));
                    }
                }
                String clJson = JSONUtil.serialize(hasClList);
                this.sjdVo.setSjd_cl(clJson.getBytes());
                this.sjdDaoImpl.updateObject((Object)this.sjdVo);
            }
            for (int i = 0; i < nameList.size(); ++i) {
                try {
                    Space space = this.nodeService.getWorkSpace(spacecode, true);
                    Node prjNode = this.nodeService.getNode(space.getId(), this.proid, true);
                    Node child = this.nodeService.getChildNode(prjNode.getId(), (String)nameList.get(i));
                    this.nodeService.remove(child.getId());
                    this.message = "\u64cd\u4f5c\u6210\u529f";
                    this.result = "true";
                    continue;
                }
                catch (Exception e) {
                    this.message = "\u6587\u4ef6\u4e2d\u5fc3\u5220\u9664\u5f02\u5e38";
                    this.result = "false";
                }
            }
        }
        returnMap.put("result", this.result);
        returnMap.put("msg", this.message);
        ServletActionContext.getResponse().setCharacterEncoding("utf-8");
        ServletActionContext.getResponse().getWriter().println(JSONUtil.serialize(returnMap));
        return "none";
    }

    public String goPrint() throws Exception {
        StringBuilder xml = new StringBuilder();
        xml.append("<?xml version=\"1.0\" encoding=\"GBK\" ?>\n");
        xml.append("<fetchdatas>\n");
        xml.append("<datas>\n");
        XMLBuildHelper xmlBuildHelper = new XMLBuildHelper();
        if (StringUtils.isNotBlank((String)this.proid) && StringUtils.isNotBlank((String)this.sjdid)) {
            SjdVo sjdVo = new SjdVo();
            List<SjdclVo> dataList = new ArrayList();
            if (StringUtils.isNotBlank((String)this.sjdid) && (sjdVo = (SjdVo)this.sjdDaoImpl.getObject(this.sjdid)) == null) {
                sjdVo = new SjdVo();
                sjdVo.setProid(this.proid);
                sjdVo.setSjdid(this.sjdid);
            }
            xml.append(xmlBuildHelper.voToXml((Object)sjdVo));
            xml.append("</datas>\n");
            dataList = SjdUtil.getSjdclListBySjdVo((SjdVo)sjdVo);
            if (dataList == null || dataList.size() == 0) {
                dataList = new ArrayList();
                SjdclVo tempVo = new SjdclVo();
                dataList.add(tempVo);
            }
            xml.append("<detail ID=\"SJDCL\">\n");
            xml.append(xmlBuildHelper.voListToXml(dataList));
            xml.append("</detail>\n");
        }
        if (xml.indexOf("</datas>") == -1) {
            xml.append("</datas>\n");
        }
        xml.append("</fetchdatas>");
        String res = xml.toString();
        this.response.setContentType("text/xml; charset=GBK");
        PrintWriter out = this.response.getWriter();
        out.write(res);
        out.flush();
        out.close();
        System.out.println(res);
        return "none";
    }

    private void createFileCenterNode(String fileId, String spacecode) throws Exception {
        Space space = null;
        try {
            space = this.nodeService.getWorkSpace(spacecode, true);
            Node prjNode = this.nodeService.getNode(space.getId(), fileId, true);
            this.nodeId = prjNode.getId();
            this.token = this.nodeService.getToken(prjNode);
        }
        catch (Exception e) {
            System.out.println("\u6587\u4ef6\u4e2d\u5fc3\u5f02\u5e38\uff1a" + e.getMessage());
        }
    }

    public String uploadInfo() {
        try {
            if (StringUtils.isNotBlank((String)this.proid)) {
                Space space = null;
                space = this.nodeService.getWorkSpace(spacecode, true);
                Node node = this.nodeService.getNode(space.getId(), this.proid, true);
                this.token = this.nodeService.getToken(node);
                HashMap<String, String> returnMap = new HashMap<String, String>();
                returnMap.put("token", this.token);
                String fileId = "";
                if (StringUtils.isNotBlank((String)this.filename)) {
                    Node nodeChild = this.getOrCreateNode(node.getId(), this.filename);
                    fileId = nodeChild.getId().toString();
                } else {
                    fileId = node.getId().toString();
                }
                returnMap.put("fileId", fileId);
                String fileCenterUrl = AppConfig.getProperty((String)"fileCenter.url");
                if (StringUtils.isNotBlank((String)fileCenterUrl) && fileCenterUrl.length() > 4) {
                    returnMap.put("fileCenterUrl", fileCenterUrl.substring(4));
                }
                ServletActionContext.getResponse().setCharacterEncoding("utf-8");
                ServletActionContext.getResponse().getWriter().println(JSONUtil.serialize(returnMap));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "none";
    }

    public String previewPic() throws Exception {
        this.listID = new ArrayList();
        if (this.proid != null && !this.proid.equals("") && this.filename != null && !this.filename.equals("")) {
            Space space = null;
            space = this.nodeService.getWorkSpace(spacecode, true);
            Node node = this.nodeService.getNode(space.getId(), this.proid, true);
            Node child = this.nodeService.getChildNode(node.getId(), this.filename);
            List list = this.nodeService.getAllChildNodes(child.getId());
            for (Node tdnode : list) {
                this.listID.add(tdnode.getId().toString());
            }
        }
        return "preview";
    }

    public String delFile() throws Exception {
        if (this.ids != null && !this.ids.equals("")) {
            this.nodeService.remove(Integer.valueOf(this.ids));
        }
        return null;
    }

    private List<SjdclVo> initDefaultFile(SjdVo vo, int nid, String wdid, List<SjdclVo> clList) {
        try {
            if (clList == null) {
                clList = new ArrayList<SjdclVo>();
            }
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("WORKFLOW_DEFINITION_ID", wdid);
            List zdbList = this.sjdDaoImpl.getObjectListByIbatisStr(param, "get_PF_STUFF_CONFIG");
            if (zdbList != null && zdbList.size() > 0) {
                System.out.println("\u521d\u59cb\u5316\u6536\u4ef6\u5355\u6750\u6599\u5b57\u5178\u6570\u636e......");
                for (int i = 0; i < zdbList.size(); ++i) {
                    StuffConfigVo configVo = (StuffConfigVo)zdbList.get(i);
                    SjdclVo clVo = new SjdclVo();
                    clVo.setData_id(UUIDGenerator.generate());
                    clVo.setProid(vo.getProid());
                    clVo.setSjdid(vo.getSjdid());
                    clVo.setName(configVo.getStuffName());
                    clVo.setXh(configVo.getStuffXh());
                    clVo.setNum(configVo.getStuffCount());
                    clVo.setBz(configVo.getRemark());
                    clVo.setType(configVo.getMeterial());
                    clVo.setYsnum(configVo.getYsnum());
                    clVo.setDbnum(configVo.getDbnum());
                    Node nodeChild = this.getOrCreateNode(Integer.valueOf(nid), clVo.getName());
                    clVo.setNode_id(nodeChild.getId());
                    clList.add(i, clVo);
                }
                System.out.println("\u521d\u59cb\u5316\u6536\u4ef6\u5355\u6750\u6599\u5b57\u5178\u6570\u636e\u5b8c\u6210\uff01");
            }
            if (clList != null) {
                String clJson = JSONUtil.serialize(clList);
                vo.setSjd_cl(clJson.getBytes());
                this.sjdDaoImpl.updateObjectByIbatisStr((Object)this.sjdVo, "update_PF_SJD_CL");
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        return clList;
    }

    private Node getOrCreateNode(Integer nid, String fName) {
        Node nodeChild = null;
        try {
            nodeChild = this.nodeService.getNode(nid, fName, true);
        }
        catch (Exception e) {
            nodeChild = this.nodeService.createNode(nid, fName);
            nodeChild.setViewName(fName);
            nodeChild.setName(fName);
            nodeChild.setDescription(fName);
            this.nodeService.save(nodeChild);
        }
        if (nodeChild == null) {
            nodeChild = this.nodeService.getNode(nid, fName, true);
            nodeChild.setViewName(fName);
            nodeChild.setName(fName);
            nodeChild.setDescription(fName);
            this.nodeService.save(nodeChild);
        }
        return nodeChild;
    }

    public void setServletRequest(HttpServletRequest arg0) {
        this.request = arg0;
    }

    public void setServletResponse(HttpServletResponse arg0) {
        this.response = arg0;
    }

    public String getData_id() {
        return this.data_id;
    }

    public void setData_id(String data_id) {
        this.data_id = data_id;
    }

    public SjdclVo getSjdclVo() {
        return this.sjdclVo;
    }

    public void setSjdclVo(SjdclVo sjdclVo) {
        this.sjdclVo = sjdclVo;
    }

    public String getResult() {
        return this.result;
    }

    public void setResult(String result) {
        this.result = result;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public SplitParam getSplitParam() {
        return this.splitParam;
    }

    public void setSplitParam(SplitParam splitParam) {
        this.splitParam = splitParam;
    }

    public String getIds() {
        return this.ids;
    }

    public void setIds(String ids) {
        this.ids = ids;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getProid() {
        return this.proid;
    }

    public void setProid(String proid) {
        this.proid = proid;
    }

    public int getNodeId() {
        return this.nodeId;
    }

    public void setNodeId(int nodeId) {
        this.nodeId = nodeId;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public List<String> getListID() {
        return this.listID;
    }

    public void setListID(List<String> listID) {
        this.listID = listID;
    }

    public String getSjdid() {
        return this.sjdid;
    }

    public void setSjdid(String sjdid) {
        this.sjdid = sjdid;
    }

    public SjdVo getSjdVo() {
        return this.sjdVo;
    }

    public void setSjdVo(SjdVo sjdVo) {
        this.sjdVo = sjdVo;
    }

    public NodeService getNodeService() {
        return this.nodeService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public List<SjdclVo> getSjdclList() {
        return this.sjdclList;
    }

    public void setSjdclList(List<SjdclVo> sjdclList) {
        this.sjdclList = sjdclList;
    }

    public String[] getData_idArr() {
        return this.data_idArr;
    }

    public void setData_idArr(String[] data_idArr) {
        this.data_idArr = data_idArr;
    }

    public Integer[] getXhArr() {
        return this.xhArr;
    }

    public void setXhArr(Integer[] xhArr) {
        this.xhArr = xhArr;
    }

    public String[] getNameArr() {
        return this.nameArr;
    }

    public void setNameArr(String[] nameArr) {
        this.nameArr = nameArr;
    }

    public Integer[] getNumArr() {
        return this.numArr;
    }

    public void setNumArr(Integer[] numArr) {
        this.numArr = numArr;
    }

    public Integer[] getYsnumArr() {
        return this.ysnumArr;
    }

    public void setYsnumArr(Integer[] ysnumArr) {
        this.ysnumArr = ysnumArr;
    }

    public Integer[] getDbnumArr() {
        return this.dbnumArr;
    }

    public void setDbnumArr(Integer[] dbnumArr) {
        this.dbnumArr = dbnumArr;
    }

    public String[] getBzArr() {
        return this.bzArr;
    }

    public void setBzArr(String[] bzArr) {
        this.bzArr = bzArr;
    }

    public String getParamString() {
        return this.paramString;
    }

    public void setParamString(String paramString) {
        this.paramString = paramString;
    }

    public SysWorkFlowDefineService getWorkFlowDefineService() {
        return this.workFlowDefineService;
    }

    public void setWorkFlowDefineService(SysWorkFlowDefineService workFlowDefineService) {
        this.workFlowDefineService = workFlowDefineService;
    }

    public SysWorkFlowInstanceService getSysWorkFlowInstanceService() {
        return this.sysWorkFlowInstanceService;
    }

    public void setSysWorkFlowInstanceService(SysWorkFlowInstanceService sysWorkFlowInstanceService) {
        this.sysWorkFlowInstanceService = sysWorkFlowInstanceService;
    }

    public BaseDao getSjdDaoImpl() {
        return this.sjdDaoImpl;
    }

    public void setSjdDaoImpl(BaseDao sjdDaoImpl) {
        this.sjdDaoImpl = sjdDaoImpl;
    }
}

