/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.web.action;

import com.gtis.plat.service.SysAuthorService;
import com.gtis.plat.service.SysMenuService;
import com.gtis.plat.vo.PfPartitionInfoVo;
import com.gtis.web.SessionUtil;
import com.gtis.web.action.TaskListActionAbstract;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.struts2.ServletActionContext;

public class ProjectListAction
extends TaskListActionAbstract {
    String IBATIS_QUERY_NAME = "getProjectList";
    boolean hasDel = false;
    boolean hasRestart = false;
    String rid;
    SysAuthorService authorService;
    SysMenuService menuService;

    public SysMenuService getMenuService() {
        return this.menuService;
    }

    public boolean isHasRestart() {
        return this.hasRestart;
    }

    public void setHasRestart(boolean hasRestart) {
        this.hasRestart = hasRestart;
    }

    public void setMenuService(SysMenuService menuService) {
        this.menuService = menuService;
    }

    public SysAuthorService getAuthorService() {
        return this.authorService;
    }

    public void setAuthorService(SysAuthorService authorService) {
        this.authorService = authorService;
    }

    public String getRid() {
        return this.rid;
    }

    public void setRid(String rid) {
        this.rid = rid;
    }

    public boolean isHasDel() {
        return this.hasDel;
    }

    public void setHasDel(boolean hasDel) {
        this.hasDel = hasDel;
    }

    public String execute() throws Exception {
        this.hasDel = false;
        this.hasRestart = false;
        super.execute();
        if (SessionUtil.getUserInfo((HttpServletRequest)ServletActionContext.getRequest()).isAdmin()) {
            this.hasDel = true;
            this.hasRestart = true;
        } else {
            String roles = SessionUtil.getUserInfo((HttpServletRequest)ServletActionContext.getRequest()).getRoleIds();
            List lstfPartitions = this.authorService.getSystemResrouceFunAuthorList(roles, this.rid);
            if (lstfPartitions != null) {
                for (PfPartitionInfoVo partitionInfoVo : lstfPartitions) {
                    if (!partitionInfoVo.getElementName().endsWith("\u5220\u9664") && !partitionInfoVo.getElementName().equalsIgnoreCase("del")) continue;
                    this.hasDel = true;
                    break;
                }
                for (PfPartitionInfoVo partitionInfoVo : lstfPartitions) {
                    if (!partitionInfoVo.getElementName().endsWith("\u91cd\u529e") && !partitionInfoVo.getElementName().equalsIgnoreCase("restart")) continue;
                    this.hasRestart = true;
                    break;
                }
            }
            HashMap mapParam = (HashMap)this.getSplitParam().getQueryParam();
            List listWdids = this.menuService.getProjectWorkFlowDefineIds(roles);
            StringBuffer bufferWdids = new StringBuffer("''");
            if (listWdids != null) {
                for (int index = 0; index < listWdids.size(); ++index) {
                    bufferWdids.append(",");
                    bufferWdids.append("'" + (String)listWdids.get(index) + "'");
                }
            }
            mapParam.put("wdids", bufferWdids.toString());
        }
        return "success";
    }

    public String viewbycreator() throws Exception {
        this.IBATIS_QUERY_NAME = "getProjectListByCreater";
        this.execute();
        HashMap mapParam = (HashMap)this.getSplitParam().getQueryParam();
        mapParam.put("CREATE_USER", SessionUtil.getCurrentUserId());
        mapParam.put("wdids", null);
        mapParam.put("regionCode", null);
        return "success";
    }

    public String viewbyperformer() throws Exception {
        this.IBATIS_QUERY_NAME = "getProjectListByPerformer";
        this.execute();
        HashMap mapParam = (HashMap)this.getSplitParam().getQueryParam();
        mapParam.put("USER_ID", SessionUtil.getCurrentUserId());
        mapParam.put("wdids", null);
        mapParam.put("regionCode", null);
        return "success";
    }

    public String viewbyregioncode() throws Exception {
        this.IBATIS_QUERY_NAME = "getProjectListByRegionCode";
        this.execute();
        return "success";
    }

    public String rss() throws Exception {
        String result = super.rss();
        return result;
    }

    public HashMap<String, String> getParam() {
        HashMap params = super.getParam();
        String roles = SessionUtil.getUserInfo((HttpServletRequest)ServletActionContext.getRequest()).getRoleIds();
        if (StringUtils.isNotBlank((String)roles)) {
            List listWdids = this.menuService.getProjectWorkFlowDefineIds(roles);
            StringBuilder builderWdids = new StringBuilder("''");
            for (int index = 0; index < listWdids.size(); ++index) {
                builderWdids.append(",");
                builderWdids.append("'" + (String)listWdids.get(index) + "'");
            }
            params.put("wdids", builderWdids.toString());
        }
        params.put("regionCode", this.getUserService().getUserRegionCode(SessionUtil.getCurrentUserId()));
        return params;
    }

    public String getIbatisQueryName() {
        return this.IBATIS_QUERY_NAME;
    }
}

