/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.web.action;

import com.gtis.plat.vo.OnlineUser;
import com.gtis.plat.vo.PfOrganVo;
import com.gtis.plat.vo.UserInfo;
import com.gtis.web.SessionStorage;
import com.opensymphony.xwork2.Action;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpSession;
import org.springframework.security.context.SecurityContext;

public class OnlineViewAction
implements Action {
    private SessionStorage sessionStorage;
    private Map<String, Set<OnlineUser>> organs;
    private int count = 0;

    public int getCount() {
        return this.count;
    }

    public Map<String, Set<OnlineUser>> getOrgans() {
        return this.organs;
    }

    public void setSessionStorage(SessionStorage sessionStorage) {
        this.sessionStorage = sessionStorage;
    }

    public String execute() throws Exception {
        this.organs = new LinkedHashMap();
        LinkedHashSet<OnlineUser> others = new LinkedHashSet<OnlineUser>();
        Collection sessions = this.sessionStorage.getSessions();
        for (HttpSession session : sessions) {
            SecurityContext sc = (SecurityContext)session.getAttribute("SPRING_SECURITY_CONTEXT");
            if (sc == null) continue;
            UserInfo ui = (UserInfo)sc.getAuthentication().getPrincipal();
            String ip = (String)session.getAttribute("online_user_ip");
            OnlineUser ou = new OnlineUser(ip, new Date(session.getCreationTime()), ui.getId(), ui.getUsername());
            if (ui.getLstOragn() == null || ui.getLstOragn().size() == 0) {
                others.add(ou);
                continue;
            }
            String organName = ((PfOrganVo)ui.getLstOragn().get(0)).getOrganName();
            if (this.organs.containsKey(organName)) {
                ((Set)this.organs.get(organName)).add(ou);
                continue;
            }
            LinkedHashSet<OnlineUser> list = new LinkedHashSet<OnlineUser>();
            list.add(ou);
            this.organs.put(organName, list);
        }
        if (others.size() > 0) {
            this.organs.put("\u5176\u4ed6", others);
        }
        for (Set users : this.organs.values()) {
            this.count += users.size();
        }
        return "success";
    }
}

