/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.web.action;

import com.gtis.common.util.CommonUtil;
import com.gtis.common.util.UUIDGenerator;
import com.gtis.plat.dao.SysFormDao;
import com.gtis.plat.vo.PfUserSignVo;
import com.gtis.web.SessionUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.ServletActionContext;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class FormSignImageAction {
    private static final Log log = LogFactory.getLog(FormSignImageAction.class);
    private static final String CONTENT_TYPE_IMAGE = "image/jpeg";
    private static final String CONTENT_TYPE = "text/html; charset=utf-8";
    private String signid;
    private String signdate;
    SysFormDao formDao;

    public SysFormDao getFormDao() {
        return this.formDao;
    }

    public void setFormDao(SysFormDao formDao) {
        this.formDao = formDao;
    }

    public String getSignid() {
        return this.signid;
    }

    public void setSignid(String signid) {
        this.signid = signid;
    }

    public String execute() throws Exception {
        ServletActionContext.getResponse().setContentType(CONTENT_TYPE_IMAGE);
        PfUserSignVo signVo = this.formDao.getSign(this.signid);
        if (signVo != null) {
            if (signVo.getSignType() != null && signVo.getSignType().equals("1")) {
                String userId = signVo.getUserId();
                signVo = this.formDao.getSignUserImage(userId);
            }
            if (signVo.getSignImage() != null) {
                ServletActionContext.getResponse().getOutputStream().write(signVo.getSignImage(), 0, signVo.getSignImage().length);
                ServletActionContext.getResponse().getOutputStream().flush();
                ServletActionContext.getResponse().getOutputStream().close();
            }
        }
        return null;
    }

    public String save() throws Exception {
        SAXReader reader = new SAXReader();
        Document document = null;
        ServletActionContext.getResponse().setContentType(CONTENT_TYPE);
        document = reader.read((InputStream)ServletActionContext.getRequest().getInputStream());
        if (document != null) {
            String userId = SessionUtil.getUserId((HttpServletRequest)ServletActionContext.getRequest());
            String userName = SessionUtil.getUserName((HttpServletRequest)ServletActionContext.getRequest());
            Element root = document.getRootElement();
            PfUserSignVo signVo = new PfUserSignVo();
            signVo.setSignId(UUIDGenerator.generate());
            signVo.setUserId(userId);
            signVo.setSignDate(CommonUtil.formateDateToStr((String)this.signdate));
            signVo.setSignName(userName);
            if (root.valueOf("@autopic").equals("true")) {
                signVo.setSignType("1");
                this.formDao.createSign(signVo);
                this.PrintResult(signVo.getSignId() + "|" + signVo.getSignName() + "|" + this.signdate);
            } else {
                String pnts = root.getText();
                if (pnts.trim().equals("")) {
                    this.PrintResult("||");
                } else {
                    signVo.setSignType("2");
                    BufferedImage srcImage = this.drawPic(pnts);
                    ByteArrayOutputStream bb = new ByteArrayOutputStream(srcImage.getData().getDataBuffer().getSize());
                    ImageIO.write((RenderedImage)srcImage, "jpg", bb);
                    signVo.setSignImage(bb.toByteArray());
                    this.formDao.createSign(signVo);
                    this.PrintResult(signVo.getSignId() + "|" + userName + "|" + this.signdate);
                }
            }
        }
        return null;
    }

    public void PrintResult(String reponseText) {
        try {
            ServletActionContext.getResponse().setCharacterEncoding("utf-8");
            ServletActionContext.getResponse().setContentType(CONTENT_TYPE);
            PrintWriter out = ServletActionContext.getResponse().getWriter();
            out.println(reponseText);
            out.flush();
            out.close();
        }
        catch (Exception e) {
            log.error((Object)e.getMessage());
        }
    }

    private BufferedImage drawPic(String strPoint) {
        boolean flage = true;
        Graphics2D graphic = null;
        BufferedImage bfimg = new BufferedImage(400, 160, 1);
        BasicStroke bs = new BasicStroke(10.0f);
        graphic = bfimg.createGraphics();
        graphic.setStroke(bs);
        graphic.setColor(new Color(255, 255, 255));
        graphic.fillRect(0, 0, 400, 160);
        int[] xPoints = new int[10000];
        int[] yPoints = new int[10000];
        int nPoints = 0;
        int vNum = 0;
        int i = 0;
        int j = 0;
        int k = 0;
        Vector<String> vctline = new Vector<String>();
        strPoint = "|" + strPoint;
        for (i = 0; i < strPoint.length(); ++i) {
            String line = new String();
            if (strPoint.charAt(i) == '|') continue;
            j = i + 1;
            k = 0;
            while (j < strPoint.length() && strPoint.charAt(j) != '|') {
                line = line + strPoint.charAt(j);
                ++j;
                ++k;
            }
            i += k;
            k = 0;
            vctline.add(vNum++, line);
        }
        k = 0;
        for (i = 0; i < vctline.size(); ++i) {
            String strline = vctline.get(i).toString();
            String strfig = "";
            int p = 0;
            for (j = 0; j < strline.length(); ++j) {
                if (strline.charAt(j) != ',') continue;
                p = j - 1;
                strfig = "";
                while (flage && strline.charAt(p) >= '0' && strline.charAt(j) <= '9') {
                    strfig = strline.charAt(p) + strfig;
                    if (--p >= 0) continue;
                    p = 0;
                    flage = false;
                }
                flage = true;
                xPoints[k] = Integer.parseInt(strfig);
                p = j + 1;
                strfig = "";
                while (flage && strline.charAt(p) >= '0' && strline.charAt(j) <= '9') {
                    strfig = strfig + strline.charAt(p);
                    if (++p < strline.length()) continue;
                    p = 0;
                    flage = false;
                }
                flage = true;
                yPoints[k] = Integer.parseInt(strfig);
                nPoints = ++k;
            }
            k = 0;
            if (nPoints <= 0) continue;
            graphic.setColor(new Color(0, 0, 0));
            graphic.drawPolyline(xPoints, yPoints, nPoints);
            nPoints = 0;
        }
        graphic.setColor(new Color(0, 0, 0));
        graphic.drawPolyline(xPoints, yPoints, nPoints);
        return bfimg;
    }

    public String getSigndate() {
        return this.signdate;
    }

    public void setSigndate(String signdate) {
        this.signdate = signdate;
    }
}

