/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.web.action;

import com.gtis.common.util.CommonUtil;
import com.gtis.common.util.UUIDGenerator;
import com.gtis.plat.service.SysUserService;
import com.gtis.plat.service.SysWorkFlowDefineService;
import com.gtis.plat.service.WorkFlowCoreService;
import com.gtis.plat.vo.PfBusinessVo;
import com.gtis.plat.vo.PfOrganVo;
import com.gtis.plat.vo.PfTaskVo;
import com.gtis.plat.vo.PfWorkFlowDefineVo;
import com.gtis.plat.vo.PfWorkFlowInstanceVo;
import com.gtis.plat.vo.UserInfo;
import com.gtis.plat.wf.WorkFlowInfo;
import com.gtis.web.SessionUtil;
import com.opensymphony.xwork2.ActionSupport;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.text.StrSubstitutor;
import org.apache.struts2.ServletActionContext;

public class CreateTaskAction
extends ActionSupport {
    private SysUserService userService;
    private SysWorkFlowDefineService workFlowDefineService;
    private WorkFlowCoreService workFlowCoreService;
    private String userName;
    private String organName;
    private String instanceName;
    private String workFlowName;
    private String proselect;
    private int timeLimit;
    private Date createTime;
    private String remark;
    private String message;
    private String wdid;
    private LinkedHashMap<String, String> proMap = new LinkedHashMap();
    private String businessName;
    private String taskId;
    private String workFlowNameTemple;

    public CreateTaskAction() {
        this.proMap.put("1", "\u666e\u901a");
        this.proMap.put("2", "\u7d27\u6025");
        this.proMap.put("3", "\u7279\u6025");
    }

    public String execute() throws Exception {
        PfWorkFlowDefineVo workFlowDefineVo = this.workFlowDefineService.getWorkFlowDefine(this.wdid);
        PfBusinessVo businessVo = this.workFlowDefineService.getBusiness(workFlowDefineVo.getBusinessId());
        this.businessName = businessVo.getBusinessName();
        this.workFlowName = workFlowDefineVo.getWorkflowName();
        this.proselect = workFlowDefineVo.getPriority();
        this.remark = workFlowDefineVo.getRemark();
        this.timeLimit = workFlowDefineVo.getTimeLimit();
        this.createTime = Calendar.getInstance().getTime();
        UserInfo userInfo = SessionUtil.getUserInfo((HttpServletRequest)ServletActionContext.getRequest());
        this.userName = userInfo.getUsername();
        if (userInfo.getLstOragn() != null && userInfo.getLstOragn().size() > 0) {
            this.organName = ((PfOrganVo)userInfo.getLstOragn().get(0)).getOrganName();
        }
        return "success";
    }

    public String create() {
        PfWorkFlowInstanceVo intanceVo = new PfWorkFlowInstanceVo();
        try {
            PfTaskVo taskVo;
            String userId = SessionUtil.getUserId((HttpServletRequest)ServletActionContext.getRequest());
            String proId = UUIDGenerator.generate();
            intanceVo.setWorkflowDefinitionId(this.wdid);
            intanceVo.setWorkflowIntanceId(proId);
            intanceVo.setProId(proId);
            intanceVo.setRemark(this.remark);
            intanceVo.setTimeLimit(this.timeLimit);
            intanceVo.setPriority(this.proselect);
            intanceVo.setWorkflowIntanceName(this.instanceName);
            WorkFlowInfo infoObj = this.workFlowCoreService.createWorkFlowInstance(intanceVo, userId);
            Iterator i$ = infoObj.getTargetTasks().iterator();
            while (i$.hasNext()) {
                taskVo = (PfTaskVo)i$.next();
                if (!taskVo.getUserVo().getUserId().equals(userId)) continue;
                this.taskId = taskVo.getTaskId();
                break;
            }
            if ((this.taskId == null || this.taskId.equals("")) && (i$ = infoObj.getTargetTasks().iterator()).hasNext()) {
                taskVo = (PfTaskVo)i$.next();
                this.taskId = taskVo.getTaskId();
            }
            this.message = "ok";
        }
        catch (Exception e) {
            this.message = e.getMessage();
            e.printStackTrace();
        }
        return "success";
    }

    public String defaultCreate() throws Exception {
        PfWorkFlowDefineVo workFlowDefineVo = this.workFlowDefineService.getWorkFlowDefine(this.wdid);
        PfWorkFlowInstanceVo intanceVo = new PfWorkFlowInstanceVo();
        try {
            PfTaskVo taskVo;
            if (this.workFlowNameTemple != null) {
                this.workFlowNameTemple = this.workFlowNameTemple.trim();
            }
            String userId = SessionUtil.getUserId((HttpServletRequest)ServletActionContext.getRequest());
            String proId = UUIDGenerator.generate();
            intanceVo.setWorkflowDefinitionId(this.wdid);
            intanceVo.setWorkflowIntanceId(proId);
            intanceVo.setProId(proId);
            intanceVo.setRemark("");
            intanceVo.setTimeLimit(workFlowDefineVo.getTimeLimit());
            intanceVo.setPriority("1");
            if (this.message != null) {
                if (this.message.endsWith("**")) {
                    intanceVo.setPriority("3");
                } else if (this.message.endsWith("*")) {
                    intanceVo.setPriority("2");
                }
            }
            HashMap<String, String> modeMap = new HashMap<String, String>();
            modeMap.put("WORKFLOW_NAME", workFlowDefineVo.getWorkflowName());
            modeMap.put("FOUNDER", SessionUtil.getUserName((HttpServletRequest)ServletActionContext.getRequest()));
            modeMap.put("CREATE_DATE", CommonUtil.getCurrYearMonthDayHourMinute());
            StrSubstitutor sub = new StrSubstitutor(modeMap, "%{", "}");
            intanceVo.setWorkflowIntanceName(sub.replace(this.workFlowNameTemple));
            WorkFlowInfo infoObj = this.workFlowCoreService.createWorkFlowInstance(intanceVo, userId);
            Iterator i$ = infoObj.getTargetTasks().iterator();
            while (i$.hasNext()) {
                taskVo = (PfTaskVo)i$.next();
                if (!taskVo.getUserVo().getUserId().equals(userId)) continue;
                this.taskId = taskVo.getTaskId();
                break;
            }
            if (StringUtils.isBlank((String)this.taskId) && (i$ = infoObj.getTargetTasks().iterator()).hasNext()) {
                taskVo = (PfTaskVo)i$.next();
                this.taskId = taskVo.getTaskId();
            }
        }
        catch (Exception e) {
            this.message = e.getMessage();
            e.printStackTrace();
        }
        ServletActionContext.getResponse().setCharacterEncoding("utf-8");
        ServletActionContext.getResponse().getWriter().println(this.taskId);
        return "none";
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getOrganName() {
        return this.organName;
    }

    public void setOrganName(String organName) {
        this.organName = organName;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public void setInstanceName(String instanceName) {
        this.instanceName = instanceName;
    }

    public String getWorkFlowName() {
        return this.workFlowName;
    }

    public void setWorkFlowName(String workFlowName) {
        this.workFlowName = workFlowName;
    }

    public String getProselect() {
        return this.proselect;
    }

    public void setProselect(String proselect) {
        this.proselect = proselect;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public String getRemark() {
        return this.remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getWdid() {
        return this.wdid;
    }

    public void setWdid(String wdid) {
        this.wdid = wdid;
    }

    public LinkedHashMap<String, String> getProMap() {
        return this.proMap;
    }

    public void setProMap(LinkedHashMap<String, String> proMap) {
        this.proMap = proMap;
    }

    public String getBusinessName() {
        return this.businessName;
    }

    public void setBusinessName(String businessName) {
        this.businessName = businessName;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public int getTimeLimit() {
        return this.timeLimit;
    }

    public void setTimeLimit(int timeLimit) {
        this.timeLimit = timeLimit;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public SysUserService getUserService() {
        return this.userService;
    }

    public void setUserService(SysUserService userService) {
        this.userService = userService;
    }

    public SysWorkFlowDefineService getWorkFlowDefineService() {
        return this.workFlowDefineService;
    }

    public void setWorkFlowDefineService(SysWorkFlowDefineService workFlowDefineService) {
        this.workFlowDefineService = workFlowDefineService;
    }

    public WorkFlowCoreService getWorkFlowCoreService() {
        return this.workFlowCoreService;
    }

    public void setWorkFlowCoreService(WorkFlowCoreService workFlowCoreService) {
        this.workFlowCoreService = workFlowCoreService;
    }

    public void setWorkFlowNameTemple(String workFlowNameTemple) {
        this.workFlowNameTemple = workFlowNameTemple;
    }
}

