/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.web;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.http.HttpSession;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.security.ui.session.HttpSessionApplicationEvent;
import org.springframework.security.ui.session.HttpSessionCreatedEvent;

public class SessionStorage
implements ApplicationListener {
    private Map<String, HttpSession> sessions = Collections.synchronizedMap(new LinkedHashMap());

    public Collection<HttpSession> getSessions() {
        return this.sessions.values();
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof HttpSessionApplicationEvent) {
            HttpSession session = ((HttpSessionApplicationEvent)event).getSession();
            if (event instanceof HttpSessionCreatedEvent) {
                this.sessions.put(session.getId(), session);
            } else {
                this.sessions.remove(session.getId());
            }
        }
    }
}

