/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.plat.wf;

import com.gtis.plat.service.SysWorkFlowDefineService;
import com.gtis.plat.service.SysWorkFlowInstanceService;
import com.gtis.plat.vo.PfWorkFlowDefineVo;
import com.gtis.plat.vo.PfWorkFlowInstanceVo;
import com.gtis.plat.wf.WorkFlowXml;
import com.gtis.spring.Container;
import java.util.HashMap;
import java.util.LinkedHashMap;

public class WorkFlowXmlUtil {
    static int MAPMAXSIZE = 100;
    static HashMap<String, WorkFlowXml> workFlowDefineMap = new HashMap();
    static LinkedHashMap<String, WorkFlowXml> workFlowInstanceMap = new LinkedHashMap(100);
    SysWorkFlowInstanceService worFlowInstanceService;
    SysWorkFlowDefineService workFlowDefineService;

    public SysWorkFlowInstanceService getWorFlowInstanceService() {
        return this.worFlowInstanceService;
    }

    public void setWorFlowInstanceService(SysWorkFlowInstanceService worFlowInstanceService) {
        this.worFlowInstanceService = worFlowInstanceService;
    }

    public SysWorkFlowDefineService getWorkFlowDefineService() {
        return this.workFlowDefineService;
    }

    public void setWorkFlowDefineService(SysWorkFlowDefineService workFlowDefineService) {
        this.workFlowDefineService = workFlowDefineService;
    }

    public WorkFlowXml getWorkFlowDefineModel(PfWorkFlowDefineVo defineVo) {
        WorkFlowXml modelXml = (WorkFlowXml)workFlowDefineMap.get(defineVo.getWorkflowDefinitionId());
        if (modelXml != null && modelXml.getModifyDate() != null && !modelXml.getModifyDate().equals(defineVo.getModifyDate())) {
            modelXml = null;
        }
        if (modelXml == null) {
            String xml = this.workFlowDefineService.getWorkFlowDefineXml(defineVo);
            modelXml = new WorkFlowXml(xml);
            modelXml.setModifyDate(defineVo.getModifyDate());
            workFlowDefineMap.put(defineVo.getWorkflowDefinitionId(), modelXml);
        }
        return modelXml;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WorkFlowXml getWorkFlowInstanceModel(PfWorkFlowInstanceVo instanceVo) {
        WorkFlowXml modelXml = (WorkFlowXml)workFlowInstanceMap.get(instanceVo.getWorkflowIntanceId());
        if (modelXml != null && modelXml.getModifyDate() != null && !modelXml.getModifyDate().equals(instanceVo.getModifyDate())) {
            modelXml = null;
        }
        if (modelXml == null) {
            if (workFlowInstanceMap.size() > MAPMAXSIZE) {
                LinkedHashMap linkedHashMap = workFlowInstanceMap;
                synchronized (linkedHashMap) {
                    workFlowInstanceMap.remove(((String)workFlowInstanceMap.keySet().iterator().next()).toString());
                }
            }
            String xml = this.worFlowInstanceService.getWorkflowInstanceXml(instanceVo);
            modelXml = new WorkFlowXml(xml);
            modelXml.setModifyDate(instanceVo.getModifyDate());
            workFlowInstanceMap.put(instanceVo.getWorkflowIntanceId(), modelXml);
        }
        return modelXml;
    }

    public void updateGobalValByProId(String proId, String valName, String val) {
        PfWorkFlowInstanceVo vo = this.worFlowInstanceService.getWorkflowInstanceByProId(proId);
        this.updateGobalVal(vo.getWorkflowIntanceId(), valName, val);
    }

    public HashMap<String, Object> getGobalValByProId(String proId) {
        PfWorkFlowInstanceVo vo = this.worFlowInstanceService.getWorkflowInstanceByProId(proId);
        if (vo != null) {
            return this.getGobalVal(vo.getWorkflowIntanceId());
        }
        return new HashMap<String, Object>();
    }

    public void updateGobalVal(String workflowIntanceId, String valName, String val) {
        this.worFlowInstanceService.updateGobalVal(workflowIntanceId, valName, (Object)val);
    }

    public HashMap<String, Object> getGobalVal(String workflowIntanceId) {
        return this.worFlowInstanceService.getGobalVal(workflowIntanceId);
    }

    public static WorkFlowXml getDefineModel(PfWorkFlowDefineVo defineVo) {
        WorkFlowXmlUtil factory = (WorkFlowXmlUtil)Container.getBean((String)"WorkFlowXmlUtil");
        return factory.getWorkFlowDefineModel(defineVo);
    }

    public static WorkFlowXml getInstanceModel(PfWorkFlowInstanceVo instanceVo) {
        WorkFlowXmlUtil factory = (WorkFlowXmlUtil)Container.getBean((String)"WorkFlowXmlUtil");
        return factory.getWorkFlowInstanceModel(instanceVo);
    }

    public static void updateGobalVals(String workflowIntanceId, String valName, String val) {
        WorkFlowXmlUtil factory = (WorkFlowXmlUtil)Container.getBean((String)"WorkFlowXmlUtil");
        factory.updateGobalVal(workflowIntanceId, valName, val);
    }

    public static HashMap<String, Object> getGobalVals(String workflowIntanceId) {
        WorkFlowXmlUtil factory = (WorkFlowXmlUtil)Container.getBean((String)"WorkFlowXmlUtil");
        return factory.getGobalVal(workflowIntanceId);
    }

    public static void updateGobalValsByProId(String proId, String valName, String val) {
        WorkFlowXmlUtil factory = (WorkFlowXmlUtil)Container.getBean((String)"WorkFlowXmlUtil");
        factory.updateGobalValByProId(proId, valName, val);
    }

    public static HashMap<String, Object> getGobalValsByProId(String proId) {
        WorkFlowXmlUtil factory = (WorkFlowXmlUtil)Container.getBean((String)"WorkFlowXmlUtil");
        return factory.getGobalValByProId(proId);
    }
}

