/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.plat.wf;

import com.gtis.common.util.CommonUtil;
import com.gtis.plat.service.SysSmsService;
import com.gtis.plat.service.SysUserService;
import com.gtis.plat.service.WorkFlowCoreService;
import com.gtis.plat.vo.PfActivityVo;
import com.gtis.plat.vo.PfTaskVo;
import com.gtis.plat.vo.PfUserVo;
import com.gtis.plat.vo.PfWorkFlowInstanceVo;
import com.gtis.plat.wf.WorkFlowBean;
import com.gtis.plat.wf.WorkFlowException;
import com.gtis.plat.wf.WorkFlowInfo;
import com.gtis.plat.wf.WorkFlowTransInfo;
import com.gtis.plat.wf.WorkFlowXml;
import com.gtis.plat.wf.WorkFlowXmlUtil;
import com.gtis.plat.wf.model.ActivityModel;
import com.gtis.plat.wf.model.PerformerTaskModel;
import com.gtis.web.SessionUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.text.StrSubstitutor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.springframework.transaction.annotation.Transactional;

public class WorkFlowCoreServiceImpl
implements WorkFlowCoreService {
    private String smsMsg;
    private SysSmsService smsService;
    private SysUserService userService;
    private List<WorkFlowBean> createWorkFlowBeans;
    private List<WorkFlowBean> getWorkFlowTurnInfoBeans;
    private List<WorkFlowBean> getWorkFlowTurnBackInfoBeans;
    private List<WorkFlowBean> turnWorkFlowBeans;
    private List<WorkFlowBean> delWorkFlowBean;
    private List<WorkFlowBean> lockWorkFlowBean;
    private List<WorkFlowBean> unLockWorkFlowBean;
    private List<WorkFlowBean> finishWorkFlowBean;
    private List<WorkFlowBean> turnBackWorkFlowBeans;
    private List<WorkFlowBean> retrieveWorkFlowBeans;
    private List<WorkFlowBean> restartWorkFlowBeans;
    static Log log = LogFactory.getLog(WorkFlowCoreServiceImpl.class);

    public List<WorkFlowBean> getRetrieveWorkFlowBeans() {
        return this.retrieveWorkFlowBeans;
    }

    public void setRetrieveWorkFlowBeans(List<WorkFlowBean> retrieveWorkFlowBeans) {
        this.retrieveWorkFlowBeans = retrieveWorkFlowBeans;
    }

    @Transactional(rollbackFor={Exception.class})
    public WorkFlowInfo createWorkFlowInstance(PfWorkFlowInstanceVo workFlowIntanceVo, String userId) throws Exception {
        if (this.createWorkFlowBeans != null) {
            WorkFlowInfo infoObj = new WorkFlowInfo();
            infoObj.setUserId(userId);
            infoObj.setWorkFlowIntanceVo(workFlowIntanceVo);
            try {
                this.doWorkBeans(infoObj, this.createWorkFlowBeans);
            }
            catch (Exception e) {
                if (e instanceof WorkFlowException) {
                    WorkFlowException ex = (WorkFlowException)e;
                    log.error((Object)("-----\u5de5\u4f5c\u6d41\u5f15\u64ce\u9519\u8bef\uff1a" + ex.getMessage()), (Throwable)ex);
                }
                throw e;
            }
            return infoObj;
        }
        return null;
    }

    public List<WorkFlowBean> getCreateWorkFlowBeans() {
        return this.createWorkFlowBeans;
    }

    public void setCreateWorkFlowBeans(List<WorkFlowBean> createWorkFlowBeans) {
        this.createWorkFlowBeans = createWorkFlowBeans;
    }

    public WorkFlowInfo getWorkFlowTurnInfo(String userId, String taskId) throws Exception {
        if (this.getWorkFlowTurnInfoBeans != null) {
            WorkFlowInfo infoObj = new WorkFlowInfo();
            infoObj.setUserId(userId);
            PfTaskVo taskVo = new PfTaskVo();
            taskVo.setTaskId(taskId);
            infoObj.setSourceTask(taskVo);
            this.doWorkBeans(infoObj, this.getWorkFlowTurnInfoBeans);
            return infoObj;
        }
        return null;
    }

    public List<WorkFlowBean> getGetWorkFlowTurnInfoBeans() {
        return this.getWorkFlowTurnInfoBeans;
    }

    public void setGetWorkFlowTurnInfoBeans(List<WorkFlowBean> getWorkFlowTurnInfoBeans) {
        this.getWorkFlowTurnInfoBeans = getWorkFlowTurnInfoBeans;
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean postWorkFlow(String userId, String taskId, WorkFlowInfo infoObj) throws Exception {
        if (this.turnWorkFlowBeans != null) {
            return this.doWorkBeans(infoObj, this.turnWorkFlowBeans);
        }
        return false;
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean postBackWorkFlow(String userId, String taskId, String[] backDefineActivitys, String remark) throws Exception {
        if (this.turnBackWorkFlowBeans != null) {
            try {
                WorkFlowInfo infoObj = new WorkFlowInfo();
                infoObj.setUserId(userId);
                WorkFlowTransInfo transInfo = new WorkFlowTransInfo();
                transInfo.setRemark(remark);
                infoObj.setTransInfo(transInfo);
                PfTaskVo taskVo = new PfTaskVo();
                taskVo.setTaskId(taskId);
                infoObj.setSourceTask(taskVo);
                ArrayList<PfActivityVo> backActivitys = new ArrayList<PfActivityVo>();
                for (int i = 0; i < backDefineActivitys.length; ++i) {
                    PfActivityVo aVo = new PfActivityVo();
                    aVo.setActivityDefinitionId(backDefineActivitys[i]);
                    backActivitys.add(aVo);
                }
                infoObj.setTargetActivitys(backActivitys);
                return this.doWorkBeans(infoObj, this.turnBackWorkFlowBeans);
            }
            catch (Exception e) {
                if (e instanceof WorkFlowException) {
                    WorkFlowException ex = (WorkFlowException)e;
                    log.error((Object)("-----\u5de5\u4f5c\u6d41\u5f15\u64ce\u9519\u8bef\uff1a" + ex.getMessage()), (Throwable)ex);
                    throw ex;
                }
                log.error((Object)("-----\u5de5\u4f5c\u6d41\u5f15\u64ce\u9519\u8bef\uff1a" + e.getMessage()), (Throwable)e);
                throw e;
            }
        }
        return false;
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean restartWorkFlow(String userId, String wiid, String remark) throws Exception {
        if (this.restartWorkFlowBeans != null) {
            WorkFlowInfo infoObj = new WorkFlowInfo();
            infoObj.setUserId(userId);
            WorkFlowTransInfo transInfo = new WorkFlowTransInfo();
            transInfo.setRemark(remark);
            infoObj.setTransInfo(transInfo);
            PfWorkFlowInstanceVo intanceVo = new PfWorkFlowInstanceVo();
            intanceVo.setWorkflowIntanceId(wiid);
            infoObj.setWorkFlowIntanceVo(intanceVo);
            return this.doWorkBeans(infoObj, this.restartWorkFlowBeans);
        }
        return false;
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean turnTask(Document doc, String taskId) throws Exception {
        String userId = SessionUtil.getCurrentUserId();
        WorkFlowInfo info = this.getWorkFlowTurnInfo(userId, taskId);
        WorkFlowXml xmlUtil = WorkFlowXmlUtil.getInstanceModel((PfWorkFlowInstanceVo)info.getWorkFlowIntanceVo());
        ActivityModel activityModel = xmlUtil.getActivity(info.getSourceActivity().getActivityDefinitionId());
        List activityList = doc.selectNodes("//Activity");
        ArrayList<String> activitys = new ArrayList<String>();
        for (Node node : activityList) {
            activitys.add(node.valueOf("@Id"));
        }
        List lstActivityModel = info.getTransInfo().getTranActivitys();
        Iterator itModel = lstActivityModel.iterator();
        while (itModel.hasNext()) {
            ActivityModel model = (ActivityModel)itModel.next();
            if (!activitys.contains(model.getDefineId())) {
                itModel.remove();
                continue;
            }
            List lstPerformer = model.getPerformerModelList();
            List lstUser = doc.selectNodes("//Activity[@Id='" + model.getDefineId() + "']/UserInfo");
            ArrayList<String> userIds = new ArrayList<String>();
            ArrayList<String> performerIds = new ArrayList<String>();
            for (Node node : lstUser) {
                if (node.valueOf("@RoleId") != null) {
                    performerIds.add(node.valueOf("@RoleId"));
                    if (StringUtils.isBlank((String)node.valueOf("@Id")) || node.valueOf("@Id").equals("-1")) {
                        userIds.addAll(this.getUsersByRoleId(node.valueOf("@RoleId")));
                        continue;
                    }
                    userIds.add(node.valueOf("@Id"));
                    continue;
                }
                if (!StringUtils.isNotBlank((String)node.valueOf("@Id"))) continue;
                userIds.add(node.valueOf("@Id"));
            }
            ArrayList<String> userTmpList = new ArrayList<String>();
            if (userIds.size() <= 0) continue;
            Iterator itPerformer = lstPerformer.iterator();
            while (itPerformer.hasNext()) {
                PerformerTaskModel taskModel = (PerformerTaskModel)itPerformer.next();
                if (taskModel.getId() != null && !performerIds.contains(taskModel.getId())) {
                    itPerformer.remove();
                    continue;
                }
                Iterator it = taskModel.getUserList().iterator();
                while (it.hasNext()) {
                    PfUserVo vo = (PfUserVo)it.next();
                    if (userTmpList.contains(vo.getUserId())) {
                        it.remove();
                        continue;
                    }
                    if (!userIds.contains(vo.getUserId())) {
                        it.remove();
                        continue;
                    }
                    userTmpList.add(vo.getUserId());
                }
            }
        }
        Node remarkNode = doc.selectSingleNode("//ReMark/text");
        if (remarkNode != null && !"".equals(remarkNode.getText().trim())) {
            info.getTransInfo().setRemark(remarkNode.getText());
        }
        this.postWorkFlow(userId, taskId, info);
        boolean sendSms = "always".equalsIgnoreCase(activityModel.getIsSendSMS());
        if (Boolean.parseBoolean(doc.selectSingleNode("/Activitys").valueOf("@SendSMS")) || sendSms) {
            this.sendTaskSMS(info);
        }
        return false;
    }

    private List<String> getUsersByRoleId(String roleId) {
        List users = this.userService.getUserListByRole(roleId);
        if (users == null || users.size() == 0) {
            users = this.userService.getUserListByOragn(roleId);
        }
        ArrayList<String> result = new ArrayList<String>();
        for (PfUserVo userVo : users) {
            result.add(userVo.getUserId());
        }
        return result;
    }

    public void setRestartWorkFlowBeans(List<WorkFlowBean> restartWorkFlowBeans) {
        this.restartWorkFlowBeans = restartWorkFlowBeans;
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean deleteWorkFlowInstance(String userId, String workflowIntanceId) throws Exception {
        if (this.delWorkFlowBean != null) {
            WorkFlowInfo infoObj = new WorkFlowInfo();
            PfWorkFlowInstanceVo workFlowIntanceVo = new PfWorkFlowInstanceVo();
            workFlowIntanceVo.setWorkflowIntanceId(workflowIntanceId);
            infoObj.setWorkFlowIntanceVo(workFlowIntanceVo);
            infoObj.setUserId(userId);
            try {
                return this.doWorkBeans(infoObj, this.delWorkFlowBean);
            }
            catch (Exception e) {
                if (e instanceof WorkFlowException) {
                    WorkFlowException ex = (WorkFlowException)e;
                    log.error((Object)("-----\u5de5\u4f5c\u6d41\u5f15\u64ce\u9519\u8bef\uff1a" + ex.getMessage()), (Throwable)ex);
                    throw ex;
                }
                throw e;
            }
        }
        return false;
    }

    public List<WorkFlowBean> getTurnWorkFlowBeans() {
        return this.turnWorkFlowBeans;
    }

    public void setTurnWorkFlowBeans(List<WorkFlowBean> turnWorkFlowBeans) {
        this.turnWorkFlowBeans = turnWorkFlowBeans;
    }

    public List<WorkFlowBean> getDelWorkFlowBean() {
        return this.delWorkFlowBean;
    }

    public void setDelWorkFlowBean(List<WorkFlowBean> delWorkFlowBean) {
        this.delWorkFlowBean = delWorkFlowBean;
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean lockWorkFlowInstance(String workflowIntanceId, String taskId, String remark) throws Exception {
        if (this.lockWorkFlowBean != null) {
            WorkFlowInfo infoObj = new WorkFlowInfo();
            if (taskId != null && !taskId.equals("")) {
                PfTaskVo taskVo = new PfTaskVo();
                taskVo.setTaskId(taskId);
                infoObj.setSourceTask(taskVo);
            }
            PfWorkFlowInstanceVo workFlowIntanceVo = new PfWorkFlowInstanceVo();
            workFlowIntanceVo.setWorkflowIntanceId(workflowIntanceId);
            workFlowIntanceVo.setRemark(remark);
            infoObj.setWorkFlowIntanceVo(workFlowIntanceVo);
            try {
                return this.doWorkBeans(infoObj, this.lockWorkFlowBean);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return false;
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean lockWorkFlowInstance(String workflowIntanceId, String taskId) throws Exception {
        if (this.lockWorkFlowBean != null) {
            WorkFlowInfo infoObj = new WorkFlowInfo();
            if (taskId != null && !taskId.equals("")) {
                PfTaskVo taskVo = new PfTaskVo();
                taskVo.setTaskId(taskId);
                infoObj.setSourceTask(taskVo);
            }
            PfWorkFlowInstanceVo workFlowIntanceVo = new PfWorkFlowInstanceVo();
            workFlowIntanceVo.setWorkflowIntanceId(workflowIntanceId);
            infoObj.setWorkFlowIntanceVo(workFlowIntanceVo);
            try {
                return this.doWorkBeans(infoObj, this.lockWorkFlowBean);
            }
            catch (Exception e) {
                log.error((Object)"-----\u5de5\u4f5c\u6d41\u5f15\u64ce\u9519\u8bef\uff1a", (Throwable)e);
            }
        }
        return false;
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean unLockWorkFlowInstance(String workflowIntanceId) throws Exception {
        if (this.unLockWorkFlowBean != null) {
            WorkFlowInfo infoObj = new WorkFlowInfo();
            PfWorkFlowInstanceVo workFlowIntanceVo = new PfWorkFlowInstanceVo();
            workFlowIntanceVo.setWorkflowIntanceId(workflowIntanceId);
            infoObj.setWorkFlowIntanceVo(workFlowIntanceVo);
            try {
                return this.doWorkBeans(infoObj, this.unLockWorkFlowBean);
            }
            catch (Exception e) {
                if (e instanceof WorkFlowException) {
                    WorkFlowException ex = (WorkFlowException)e;
                    log.error((Object)("-----\u5de5\u4f5c\u6d41\u5f15\u64ce\u9519\u8bef\uff1a" + ex.getMessage()), (Throwable)ex);
                    throw ex;
                }
                throw e;
            }
        }
        return false;
    }

    public List<WorkFlowBean> getLockWorkFlowBean() {
        return this.lockWorkFlowBean;
    }

    public void setLockWorkFlowBean(List<WorkFlowBean> lockWorkFlowBean) {
        this.lockWorkFlowBean = lockWorkFlowBean;
    }

    public List<WorkFlowBean> getUnLockWorkFlowBean() {
        return this.unLockWorkFlowBean;
    }

    public void setUnLockWorkFlowBean(List<WorkFlowBean> unLockWorkFlowBean) {
        this.unLockWorkFlowBean = unLockWorkFlowBean;
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean finishWorkFlow(WorkFlowInfo infoObj) throws Exception {
        if (this.finishWorkFlowBean != null) {
            try {
                return this.doWorkBeans(infoObj, this.finishWorkFlowBean);
            }
            catch (Exception e) {
                if (e instanceof WorkFlowException) {
                    WorkFlowException ex = (WorkFlowException)e;
                    log.error((Object)("-----\u5de5\u4f5c\u6d41\u5f15\u64ce\u9519\u8bef\uff1a" + ex.getMessage()), (Throwable)ex);
                    throw ex;
                }
                throw e;
            }
        }
        return false;
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean finishWorkFlow(String workflowIntanceId) throws Exception {
        if (this.finishWorkFlowBean != null) {
            WorkFlowInfo infoObj = new WorkFlowInfo();
            PfWorkFlowInstanceVo workFlowIntanceVo = new PfWorkFlowInstanceVo();
            workFlowIntanceVo.setWorkflowIntanceId(workflowIntanceId);
            infoObj.setWorkFlowIntanceVo(workFlowIntanceVo);
            this.finishWorkFlow(infoObj);
        }
        return false;
    }

    public List<WorkFlowBean> getFinishWorkFlowBean() {
        return this.finishWorkFlowBean;
    }

    public void setFinishWorkFlowBean(List<WorkFlowBean> finishWorkFlowBean) {
        this.finishWorkFlowBean = finishWorkFlowBean;
    }

    public boolean doWorkBeans(WorkFlowInfo infoObj, List<WorkFlowBean> beans) throws Exception {
        WorkFlowBean step;
        boolean result;
        Iterator<WorkFlowBean> i$ = beans.iterator();
        while (i$.hasNext() && (result = (step = i$.next()).doWork(infoObj))) {
        }
        return true;
    }

    public WorkFlowInfo getWorkFlowTurnBackInfo(String userId, String taskId) throws Exception {
        if (this.getWorkFlowTurnBackInfoBeans != null) {
            WorkFlowInfo infoObj = new WorkFlowInfo();
            PfTaskVo taskVo = new PfTaskVo();
            taskVo.setTaskId(taskId);
            infoObj.setSourceTask(taskVo);
            try {
                this.doWorkBeans(infoObj, this.getWorkFlowTurnBackInfoBeans);
            }
            catch (Exception e) {
                if (e instanceof WorkFlowException) {
                    WorkFlowException ex = (WorkFlowException)e;
                    log.error((Object)("-----\u5de5\u4f5c\u6d41\u5f15\u64ce\u9519\u8bef\uff1a" + ex.getMessage()), (Throwable)ex);
                }
                throw e;
            }
            return infoObj;
        }
        return null;
    }

    public List<WorkFlowBean> getGetWorkFlowTurnBackInfoBeans() {
        return this.getWorkFlowTurnBackInfoBeans;
    }

    public void setGetWorkFlowTurnBackInfoBeans(List<WorkFlowBean> getWorkFlowTurnBackInfoBeans) {
        this.getWorkFlowTurnBackInfoBeans = getWorkFlowTurnBackInfoBeans;
    }

    public List<WorkFlowBean> getTurnBackWorkFlowBeans() {
        return this.turnBackWorkFlowBeans;
    }

    public void setTurnBackWorkFlowBeans(List<WorkFlowBean> turnBackWorkFlowBeans) {
        this.turnBackWorkFlowBeans = turnBackWorkFlowBeans;
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean retrieveWorkFlow(String userId, String taskId) throws Exception {
        if (this.retrieveWorkFlowBeans != null) {
            WorkFlowInfo infoObj = new WorkFlowInfo();
            PfTaskVo taskVo = new PfTaskVo();
            taskVo.setTaskId(taskId);
            infoObj.setSourceTask(taskVo);
            return this.doWorkBeans(infoObj, this.retrieveWorkFlowBeans);
        }
        return false;
    }

    private void sendTaskSMS(WorkFlowInfo info) {
        List taskList = info.getTargetTasks();
        HashMap<String, String> praseMap = new HashMap<String, String>();
        praseMap.put("workflowName", info.getWorkFlowIntanceVo().getWorkflowIntanceName());
        praseMap.put("createTime", CommonUtil.formateDate((Date)info.getWorkFlowIntanceVo().getCreateTime()));
        StrSubstitutor sub = new StrSubstitutor(praseMap, "%{", "}");
        String tempSms = sub.replace(this.smsMsg);
        for (PfTaskVo task : taskList) {
            PfUserVo user = this.userService.getUserVo(task.getUserVo().getUserId());
            if (user.getMobilePhone() == null) continue;
            try {
                this.smsService.sendMsg("\u7cfb\u7edf\u53d1\u9001", user.getUserName(), user.getMobilePhone(), tempSms);
            }
            catch (Exception e) {
                log.debug((Object)e.getMessage());
                e.printStackTrace();
            }
        }
    }

    private Document httpFilterXml(Document doc, ActivityModel actModel) {
        if (StringUtils.isNotBlank((String)actModel.getTurnInfoUrl())) {
            HttpClient httpClient = new HttpClient();
            PostMethod postMethod = new PostMethod(actModel.getTurnInfoUrl());
            NameValuePair[] data = new NameValuePair[]{new NameValuePair("turnInfo", doc.asXML())};
            postMethod.setRequestBody(data);
            int status = 0;
            try {
                status = httpClient.executeMethod((HttpMethod)postMethod);
            }
            catch (IOException e) {
                log.error((Object)"TurnInfo filter url request failer{}", (Throwable)e);
            }
            if (status == 200) {
                SAXReader reader = new SAXReader();
                try {
                    doc = reader.read(postMethod.getResponseBodyAsString());
                }
                catch (Exception e) {
                    log.error((Object)"TurnInfo filter url request success,prase failure{}", (Throwable)e);
                }
            } else {
                log.error((Object)"TurnInfo filter url request failer");
            }
        }
        return doc;
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean turnTask(String xml, String taskId, String userId) throws Exception {
        Document doc = DocumentHelper.parseText((String)xml);
        WorkFlowInfo info = this.getWorkFlowTurnInfo(userId, taskId);
        List activityList = doc.selectNodes("//Activity");
        ArrayList<String> activitys = new ArrayList<String>();
        for (Node node : activityList) {
            activitys.add(node.valueOf("@Id"));
        }
        List lstActivityModel = info.getTransInfo().getTranActivitys();
        Iterator itModel = lstActivityModel.iterator();
        while (itModel.hasNext()) {
            Node node;
            ActivityModel model = (ActivityModel)itModel.next();
            if (!activitys.contains(model.getDefineId())) {
                itModel.remove();
                continue;
            }
            List lstPerformer = model.getPerformerModelList();
            List lstUser = doc.selectNodes("//Activity[@Id='" + model.getDefineId() + "']/UserInfo");
            ArrayList<String> userIds = new ArrayList<String>();
            ArrayList<String> performerIds = new ArrayList<String>();
            Iterator i$ = lstUser.iterator();
            while (i$.hasNext() && !(node = (Node)i$.next()).valueOf("@Id").equals("-1")) {
                userIds.add(node.valueOf("@Id"));
                if (node.valueOf("@RoleId") == null) continue;
                performerIds.add(node.valueOf("@RoleId"));
            }
            ArrayList<String> userTmpList = new ArrayList<String>();
            if (userIds.size() <= 0) continue;
            Iterator itPerformer = lstPerformer.iterator();
            while (itPerformer.hasNext()) {
                PerformerTaskModel taskModel = (PerformerTaskModel)itPerformer.next();
                if (taskModel.getId() != null && !performerIds.contains(taskModel.getId())) {
                    itPerformer.remove();
                    continue;
                }
                Iterator it = taskModel.getUserList().iterator();
                while (it.hasNext()) {
                    PfUserVo vo = (PfUserVo)it.next();
                    if (userTmpList.contains(vo.getUserId())) {
                        it.remove();
                        continue;
                    }
                    if (!userIds.contains(vo.getUserId())) {
                        it.remove();
                        continue;
                    }
                    userTmpList.add(vo.getUserId());
                }
            }
        }
        Node remarkNode = doc.selectSingleNode("//ReMark/text");
        if (remarkNode != null && !"".equals(remarkNode.getText().trim())) {
            info.getTransInfo().setRemark(remarkNode.getText());
        }
        this.postWorkFlow(userId, taskId, info);
        if (Boolean.parseBoolean(doc.selectSingleNode("/Activitys").valueOf("@SendSMS"))) {
            this.sendTaskSMS(info);
        }
        return false;
    }

    public void setSmsService(SysSmsService smsService) {
        this.smsService = smsService;
    }

    public void setUserService(SysUserService userService) {
        this.userService = userService;
    }

    public void setSmsMsg(String smsMsg) {
        this.smsMsg = smsMsg;
    }
}

