/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.plat.service.impl.search;

import com.gtis.common.AbstractSplitDataIndexProvider;
import com.gtis.plat.dao.SysWorkFlowInstanceDao;
import com.gtis.plat.service.SysTaskService;
import com.gtis.plat.service.SysUserService;
import com.gtis.plat.service.SysWorkFlowDefineService;
import com.gtis.plat.vo.PfActivityVo;
import com.gtis.plat.vo.PfBusinessVo;
import com.gtis.plat.vo.PfUserVo;
import com.gtis.plat.vo.PfWorkFlowDefineVo;
import com.gtis.plat.vo.PfWorkFlowInstanceVo;
import com.gtis.search.Business;
import com.gtis.search.BusinessFactory;
import com.gtis.search.Category;
import com.gtis.search.CategoryFactory;
import com.gtis.search.Index;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class SysWorkFlowIndexProviderImpl
extends AbstractSplitDataIndexProvider<PfWorkFlowInstanceVo> {
    private SysWorkFlowInstanceDao intanceDAO;
    private SysUserService sysUserService;
    private SysWorkFlowDefineService workFlowDefineService;
    private SysTaskService taskService;
    private BusinessFactory defaultBusinessFactory;
    private CategoryFactory defaultCategoryFactory;

    public void setIntanceDAO(SysWorkFlowInstanceDao intanceDAO) {
        this.intanceDAO = intanceDAO;
    }

    public void setSysUserService(SysUserService sysUserService) {
        this.sysUserService = sysUserService;
    }

    public void setWorkFlowDefineService(SysWorkFlowDefineService workFlowDefineService) {
        this.workFlowDefineService = workFlowDefineService;
    }

    public void setTaskService(SysTaskService taskService) {
        this.taskService = taskService;
    }

    public void setDefaultBusinessFactory(BusinessFactory defaultBusinessFactory) {
        this.defaultBusinessFactory = defaultBusinessFactory;
    }

    public void setDefaultCategoryFactory(CategoryFactory defaultCategoryFactory) {
        this.defaultCategoryFactory = defaultCategoryFactory;
    }

    public List<Business> getBusinesses() {
        List businesses = super.getBusinesses();
        for (Business sBiz : this.getSysBusinesses()) {
            int i = businesses.indexOf(sBiz);
            if (i > -1) {
                Business biz = ((Business)businesses.get(i)).clone();
                biz.setLastModified(null);
                if (biz.getName() == null) {
                    biz.setName(sBiz.getName());
                }
                if (biz.getIcon() == null) {
                    biz.setIcon(sBiz.getIcon());
                }
                for (Map.Entry entry : sBiz.getTpls().entrySet()) {
                    Map tpls = biz.getTpls();
                    if (tpls.containsKey(entry.getKey())) continue;
                    tpls.put(entry.getKey(), entry.getValue());
                }
                for (Map.Entry entry : sBiz.getTplVars().entrySet()) {
                    Map vars = biz.getTplVars();
                    if (vars.containsKey(entry.getKey())) continue;
                    vars.put(entry.getKey(), entry.getValue());
                }
                List categories = biz.getCategories();
                List sysCategory = sBiz.getCategories();
                for (Category sCat : sysCategory) {
                    int j = categories.indexOf(sCat);
                    if (j > -1) {
                        Category cat = (Category)categories.get(j);
                        if (cat.getName() == null) {
                            cat.setName(sBiz.getName());
                        }
                        if (cat.getIcon() != null) continue;
                        cat.setIcon(sBiz.getIcon());
                        continue;
                    }
                    categories.add(sCat);
                }
                businesses.set(i, biz);
                continue;
            }
            businesses.add(sBiz);
        }
        return businesses;
    }

    protected Collection<Business> getSysBusinesses() {
        LinkedHashMap<String, Business> map = new LinkedHashMap<String, Business>();
        for (PfWorkFlowDefineVo vo : this.workFlowDefineService.getWorkFlowDefineList()) {
            Business biz = (Business)map.get(vo.getBusinessId());
            if (biz == null) {
                biz = this.defaultBusinessFactory.getBusiness().clone();
                biz.setCategories(new ArrayList());
                PfBusinessVo bvo = vo.getBusinessVo();
                biz.setId(vo.getBusinessId());
                if (StringUtils.isNotBlank((String)bvo.getBusinessCode())) {
                    biz.setIcon(bvo.getBusinessCode());
                }
                biz.setName(bvo.getBusinessName());
                map.put(vo.getBusinessId(), biz);
            }
            Category cat = this.defaultCategoryFactory.getCategory(biz).clone();
            cat.setId(vo.getWorkflowDefinitionId());
            cat.setName(vo.getWorkflowName());
            if (StringUtils.isNotBlank((String)vo.getWorkflowCode())) {
                cat.setIcon(vo.getWorkflowCode());
            }
            biz.getCategories().add(cat);
        }
        return map.values();
    }

    protected PfWorkFlowInstanceVo getEntity(String categoryId, String id) {
        return this.intanceDAO.getWorkflowInstance(id);
    }

    protected void extractEntity(PfWorkFlowInstanceVo entity, Index index) {
        index.setBusinessId(this.workFlowDefineService.getWorkFlowDefine(entity.getWorkflowDefinitionId()).getBusinessId());
        index.setCategoryId(entity.getWorkflowDefinitionId());
        index.setId(entity.getWorkflowIntanceId());
        index.setTitle(entity.getWorkflowIntanceName());
        index.setDate(this.getWfDate(entity));
        PfUserVo user = this.sysUserService.getUserVo(entity.getCreateUser());
        if (user != null) {
            index.appendBody(user.getUserName());
        }
        index.appendBody(entity.getRemark());
    }

    private Date getWfDate(PfWorkFlowInstanceVo entity) {
        Date date = new Date();
        List list = this.taskService.getWorkFlowInstanceActivityList(entity.getWorkflowIntanceId());
        if (!list.isEmpty()) {
            date = ((PfActivityVo)list.get(0)).getBeginTime();
        }
        if (date == null) {
            date = entity.getCreateTime();
        }
        if (date == null) {
            date = new Date();
        }
        return date;
    }

    protected String getStatementName() {
        return "getWorkFlowInstanceList";
    }

    protected void parepareSplitParams(Map<String, String> params, String categoryId) {
        params.put("WORKFLOW_DEFINITION_ID", categoryId);
    }
}

