/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.plat.service.impl;

import com.gtis.plat.dao.SysTaskDao;
import com.gtis.plat.service.SysTaskService;
import com.gtis.plat.vo.PfActivityVo;
import com.gtis.plat.vo.PfTaskVo;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class SysTaskServiceImpl
implements SysTaskService {
    SysTaskDao taskDao;

    public void createActivity(PfActivityVo activityVo) {
        PfActivityVo aVo = this.taskDao.getActivityBywIdandadId(activityVo.getWorkflowInstanceId(), activityVo.getActivityDefinitionId());
        if (aVo == null) {
            this.taskDao.createActivity(activityVo);
        } else {
            this.updateActivityStadus(activityVo.getActivityId(), activityVo.getActivityState());
        }
    }

    public void createTask(PfTaskVo taskVo) {
        List lstTasks = this.taskDao.getTaskListByUserIdAndActivity(taskVo.getActivityId(), taskVo.getUserVo().getUserId());
        if (lstTasks == null || lstTasks.size() == 0) {
            this.taskDao.createTask(taskVo);
        } else if (!StringUtils.isBlank((String)taskVo.getTaskBefore())) {
            for (PfTaskVo aTask : lstTasks) {
                this.taskDao.updateTasksByBefore(aTask.getTaskId(), taskVo.getTaskBefore());
            }
        }
    }

    public void createTasks(List<PfTaskVo> tasklist) {
        for (PfTaskVo taskVo : tasklist) {
            this.createTask(taskVo);
        }
    }

    public List<PfActivityVo> getActivityByBefore(String activityId) {
        return this.taskDao.getActivityByBefore(activityId);
    }

    public void updateHistoryTask(PfTaskVo taskVo) {
        this.taskDao.updateTaskHistory(taskVo);
    }

    public void deleteActivityTask(String activityId) {
        this.taskDao.deleteActivityTask(activityId);
    }

    public void deleteTask(String taskId) {
        this.taskDao.deleteTask(taskId);
    }

    public PfActivityVo getActivity(String activityId) {
        return this.taskDao.getActivity(activityId);
    }

    public PfActivityVo getActivityBywIdandadId(String workflowInstanceId, String activityDefinitionId) {
        return this.taskDao.getActivityBywIdandadId(workflowInstanceId, activityDefinitionId);
    }

    public List<PfTaskVo> getTaskListByActivity(String activityId) {
        return this.taskDao.getTaskListByActivity(activityId);
    }

    public List<PfTaskVo> getHistoryTasks(String activityId) {
        return this.taskDao.getHistoryTasks(activityId);
    }

    public int getAllTaskCountByActivityId(String activityId) {
        return this.taskDao.getAllTaskCountByActivityId(activityId);
    }

    public PfTaskVo getTask(String taskId) {
        return this.taskDao.getTask(taskId);
    }

    public PfTaskVo getTaskAll(String taskId) {
        return this.taskDao.getTaskAll(taskId);
    }

    public List<PfActivityVo> getWorkFlowInstanceActivityList(String workflowInstanceId) {
        return this.taskDao.getWorkFlowInstanceActivityList(workflowInstanceId);
    }

    public void insertTaskHistory(String taskId) {
        this.taskDao.insertTaskHistory(taskId);
    }

    public void updateActivityBackStadus(String activityId, boolean isBack) {
        if (isBack) {
            this.taskDao.updateActivityBack(activityId);
        } else {
            this.taskDao.updateActivityForword(activityId);
        }
    }

    public void updateActivityRemark(String activityId, String remark) {
        this.taskDao.updateActivityRemark(activityId, remark);
    }

    public void updateActivityStadus(String activityId, int stadus) {
        PfActivityVo activityVo = new PfActivityVo();
        activityVo.setActivityId(activityId);
        switch (stadus) {
            case 1: {
                activityVo.setBeginTime(Calendar.getInstance().getTime());
                activityVo.setActivityState(1);
                break;
            }
            case 2: {
                activityVo.setFinishTime(Calendar.getInstance().getTime());
                activityVo.setActivityState(2);
                break;
            }
            case 5: {
                activityVo.setFinishTime(Calendar.getInstance().getTime());
                activityVo.setActivityState(5);
                break;
            }
            default: {
                activityVo.setActivityState(stadus);
            }
        }
        this.taskDao.updateActivityStadus(activityVo);
    }

    public void updateActivityHandlesDay(String activityId, int handlesDay) {
        PfActivityVo activityVo = new PfActivityVo();
        activityVo.setActivityId(activityId);
        activityVo.setHandlesDay(handlesDay);
        this.taskDao.updateActivityHandlesDay(activityVo);
    }

    public void updateCooperateStateDown(String activityId) {
        this.taskDao.updateCooperateStateDown(activityId);
    }

    public void updateCooperateStateUp(String activityId) {
        this.taskDao.updateCooperateStateUp(activityId);
    }

    public SysTaskDao getTaskDao() {
        return this.taskDao;
    }

    public void setTaskDao(SysTaskDao taskDao) {
        this.taskDao = taskDao;
    }

    public List<PfTaskVo> getHistoryTaskListByInstance(String workFlowInstanceId) {
        return this.taskDao.getHistoryTaskListByInstance(workFlowInstanceId);
    }

    public List<PfTaskVo> getHistoryTaskListByDefineId(String workFlowInstanceId, String activityDefineId) {
        return this.taskDao.getHistoryTaskListByDefineId(workFlowInstanceId, activityDefineId);
    }

    public List<PfTaskVo> getTaskListByInstance(String workFlowInstanceId) {
        return this.taskDao.getTaskListByInstance(workFlowInstanceId);
    }

    public List<PfActivityVo> getWorkFlowInstanceAllActivityList(String workFlowInstanceId) {
        return this.taskDao.getWorkFlowInstanceAllActivityList(workFlowInstanceId);
    }

    public PfTaskVo getHistoryTask(String taskId) {
        return this.taskDao.getHistoryTask(taskId);
    }

    public List<PfTaskVo> getHistoryTaskByBefore(PfTaskVo taskVo) {
        ArrayList<PfTaskVo> lstResult = new ArrayList<PfTaskVo>();
        if (!StringUtils.isBlank((String)taskVo.getTaskBefore())) {
            String[] taskIds;
            for (String taskId : taskIds = StringUtils.split((String)taskVo.getTaskBefore(), (String)",")) {
                if (StringUtils.isBlank((String)taskId)) continue;
                PfTaskVo taskHisVo = this.getHistoryTask(taskId);
                if (taskHisVo == null) {
                    taskHisVo = this.getTask(taskId);
                }
                if (taskHisVo == null) continue;
                lstResult.add(taskHisVo);
            }
        }
        return lstResult;
    }

    public void deleteWorkFlowInstanceActivity(String workflowIntanceId) {
        this.taskDao.deleteWorkFlowInstanceActivity(workflowIntanceId);
    }

    public void deleteHistoryTaskByActivityId(String activityId) {
        this.taskDao.deleteHistoryTaskByActivityId(activityId);
    }

    public void updateTask(PfTaskVo taskVo) {
        this.taskDao.updateTask(taskVo);
    }

    public void updateTempTask(String activityId) {
        this.taskDao.updateTempTask(activityId);
    }

    public List<PfTaskVo> getTasksByBefore(String taskId) {
        return this.taskDao.getTasksByBefore(taskId);
    }

    public void createTaskByHistroy(String taskId) {
        this.taskDao.createTaskByHistroy(taskId);
    }

    public void deleteHistoryTask(String taskId) {
        this.taskDao.deleteHistoryTask(taskId);
    }

    public void deleteActivity(String activityId) {
        this.taskDao.deleteActivity(activityId);
    }

    public void updateTaskStadus(String taskId) {
        String acceptTaskId = this.taskDao.selectIsAcceptedTask(taskId);
        if (StringUtils.isBlank((String)acceptTaskId)) {
            this.taskDao.updateTaskStadus(taskId);
        }
    }

    public List<PfTaskVo> getHistoryTaskListByActivity(String activityId) {
        return this.taskDao.getHistoryTaskListByActivity(activityId);
    }

    public void deleteOtherTasks(String taskId) {
        this.taskDao.deleteOtherTasks(taskId);
    }

    public void updateAssignmentHistoryRepeat(String assignmentId) {
        this.taskDao.updateAssignmentHistoryRepeat(assignmentId);
    }
}

