/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.plat.service.impl;

import com.gtis.common.util.UUIDGenerator;
import com.gtis.plat.dao.SysSignDAO;
import com.gtis.plat.dao.SysUserDAO;
import com.gtis.plat.service.SysSignService;
import com.gtis.plat.vo.PfSignVo;
import com.gtis.spring.Container;
import com.gtis.util.ImageUtil;
import com.gtis.web.SessionUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Calendar;
import java.util.List;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.sql.DataSource;
import oracle.sql.BLOB;
import org.apache.commons.lang.StringUtils;
import org.springframework.transaction.annotation.Transactional;

public class SysSignServiceImpl
implements SysSignService {
    private SysSignDAO signDAO;
    private SysUserDAO userDAO;
    private static String USER_AUTOSIGN_TYPE = "1";
    private static String USER_CUSTOM_SIGN_TYPE = "0";

    public void setUserDAO(SysUserDAO userDAO) {
        this.userDAO = userDAO;
    }

    public void setSignDAO(SysSignDAO signDAO) {
        this.signDAO = signDAO;
    }

    public List<PfSignVo> getSignList(String signKey, String proId) {
        return this.signDAO.getSignList(null, signKey, null, null, proId, null);
    }

    public List<PfSignVo> getSignListByUserId(String signKey, String proId, String userId) {
        return this.signDAO.getSignList(null, signKey, null, null, proId, userId);
    }

    public PfSignVo getSign(String signId) {
        return this.signDAO.getSignNoImage(signId);
    }

    public PfSignVo getSignImage(String signId) {
        PfSignVo signVo = this.getSign(signId);
        if (signVo != null) {
            if (USER_AUTOSIGN_TYPE.equals(signVo.getSignType())) {
                return this.signDAO.getUserSignImage(signId);
            }
            return this.signDAO.getSignImage(signId);
        }
        return null;
    }

    public boolean insertAutoSign(PfSignVo signVo) {
        signVo = this.CheckSignVo(signVo);
        signVo.setSignType(USER_AUTOSIGN_TYPE);
        this.signDAO.insertSign(signVo);
        return true;
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean updateAutoSign(PfSignVo signVo) {
        signVo = this.CheckSignVo(signVo);
        signVo.setSignType(USER_AUTOSIGN_TYPE);
        this.signDAO.updateSign(signVo);
        this.signDAO.updateSignNullPic(signVo.getSignId());
        return true;
    }

    public boolean updateSign(PfSignVo signVo) {
        signVo = this.CheckSignVo(signVo);
        this.signDAO.updateSign(signVo);
        return true;
    }

    public boolean deleteSign(String signId) {
        this.signDAO.deleteSign(signId);
        return true;
    }

    @Transactional(rollbackFor={Exception.class})
    public String AddCustomSign(String userId, String proId, String signKey, String imgStr) {
        PfSignVo signVo = new PfSignVo();
        signVo.setProId(proId);
        signVo.setUserId(userId);
        signVo.setSignType(USER_CUSTOM_SIGN_TYPE);
        signVo.setSignKey(signKey);
        signVo = this.CheckSignVo(signVo);
        signVo = this.CheckSignVo(signVo);
        this.signDAO.insertSign(signVo);
        this.UpdateCustomSignPic(signVo.getSignId(), imgStr);
        return signVo.getSignId();
    }

    public boolean UpdateCustomSignPic(String signId, String imgStr) {
        this.signDAO.updateSignEmptyPic(signId);
        this.UpdateSignPic(signId, imgStr);
        return true;
    }

    private PfSignVo CheckSignVo(PfSignVo signVo) {
        if (signVo != null) {
            if (StringUtils.isBlank((String)signVo.getSignId())) {
                signVo.setSignId(UUIDGenerator.generate());
            }
            if (StringUtils.isBlank((String)signVo.getUserId())) {
                signVo.setUserId(SessionUtil.getCurrentUserId());
            }
            if (StringUtils.isBlank((String)signVo.getSignName())) {
                signVo.setSignName(this.userDAO.getUserVo(SessionUtil.getCurrentUserId()).getUserName());
            }
            if (signVo.getSignDate() == null) {
                signVo.setSignDate(Calendar.getInstance().getTime());
            }
        }
        return signVo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void UpdateBase64SignPic(String signId, String imgStr) {
        Statement stmt = null;
        ResultSet rs = null;
        try {
            DataSource ds = (DataSource)Container.getBean((String)"egov");
            Connection conn = ds.getConnection();
            conn.setAutoCommit(false);
            stmt = conn.createStatement();
            rs = stmt.executeQuery("select SIGN_PIC from PF_USERSIGN where SIGN_ID='" + signId + "' FOR UPDATE");
            if (rs.next()) {
                BLOB blob = (BLOB)rs.getBlob("SIGN_PIC");
                BufferedOutputStream out = new BufferedOutputStream(blob.getBinaryOutputStream());
                if (StringUtils.isNotEmpty((String)imgStr)) {
                    imgStr = imgStr.substring(imgStr.indexOf("data:image/bmp;base64,") + 23);
                }
                ImageUtil.GenerateImage((String)imgStr, (OutputStream)out);
            }
            conn.setAutoCommit(false);
            conn.commit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                rs.close();
                stmt.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void UpdateSignPic(String signId, String pnts) {
        try {
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            PfSignVo signVo = new PfSignVo();
            if (pnts.indexOf(",") > 0 || pnts.indexOf("|") > 0) {
                BufferedImage bufferImg = this.drawPic(pnts);
                ImageIO.write((RenderedImage)bufferImg, "jpg", bOut);
            } else {
                ImageUtil.GenerateImage((String)pnts, (OutputStream)bOut);
            }
            signVo.setSignImage(bOut.toByteArray());
            signVo.setSignId(signId);
            this.signDAO.updateSignPic(signVo);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private BufferedImage drawPic(String strPoint) {
        boolean flage = true;
        Graphics2D graphic = null;
        BufferedImage bfimg = new BufferedImage(400, 160, 1);
        BasicStroke bs = new BasicStroke(10.0f);
        graphic = bfimg.createGraphics();
        graphic.setStroke(bs);
        graphic.setColor(new Color(255, 255, 255));
        graphic.fillRect(0, 0, 400, 160);
        int[] xPoints = new int[10000];
        int[] yPoints = new int[10000];
        int nPoints = 0;
        int vNum = 0;
        int i = 0;
        int j = 0;
        int k = 0;
        Vector<String> vctline = new Vector<String>();
        strPoint = "|" + strPoint;
        for (i = 0; i < strPoint.length(); ++i) {
            String line = new String();
            if (strPoint.charAt(i) == '|') continue;
            j = i + 1;
            k = 0;
            while (j < strPoint.length() && strPoint.charAt(j) != '|') {
                line = line + strPoint.charAt(j);
                ++j;
                ++k;
            }
            i += k;
            k = 0;
            vctline.add(vNum++, line);
        }
        k = 0;
        for (i = 0; i < vctline.size(); ++i) {
            String strline = vctline.get(i).toString();
            String strfig = "";
            int p = 0;
            for (j = 0; j < strline.length(); ++j) {
                if (strline.charAt(j) != ',') continue;
                p = j - 1;
                strfig = "";
                while (flage && strline.charAt(p) >= '0' && strline.charAt(j) <= '9') {
                    strfig = strline.charAt(p) + strfig;
                    if (--p >= 0) continue;
                    p = 0;
                    flage = false;
                }
                flage = true;
                xPoints[k] = Integer.parseInt(strfig);
                p = j + 1;
                strfig = "";
                while (flage && strline.charAt(p) >= '0' && strline.charAt(j) <= '9') {
                    strfig = strfig + strline.charAt(p);
                    if (++p < strline.length()) continue;
                    p = 0;
                    flage = false;
                }
                flage = true;
                yPoints[k] = Integer.parseInt(strfig);
                nPoints = ++k;
            }
            k = 0;
            if (nPoints <= 0) continue;
            graphic.setColor(new Color(0, 0, 0));
            graphic.drawPolyline(xPoints, yPoints, nPoints);
            nPoints = 0;
        }
        graphic.setColor(new Color(0, 0, 0));
        graphic.drawPolyline(xPoints, yPoints, nPoints);
        return bfimg;
    }
}

