/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.plat.service.impl;

import com.gtis.plat.dao.SysMenuDao;
import com.gtis.plat.service.SysMenuService;
import com.gtis.plat.vo.PfMenuVo;
import com.gtis.plat.vo.PfResourceVo;
import com.gtis.plat.vo.UserInfo;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class SysMenuServiceImpl
implements SysMenuService {
    private SysMenuDao menuDao;

    public SysMenuDao getMenuDao() {
        return this.menuDao;
    }

    public void setMenuDao(SysMenuDao menuDao) {
        this.menuDao = menuDao;
    }

    public List<PfMenuVo> getMenusByUserInfo(UserInfo userInfo) {
        if (!userInfo.isAdmin()) {
            String roles = userInfo.getRoleIds();
            if (StringUtils.isNotBlank((String)roles)) {
                return this.menuDao.getMenuListByRoles(roles);
            }
            return this.menuDao.getMenuListByRoles("'-99'");
        }
        return this.menuDao.getMenuListByRoles(null);
    }

    public List<PfMenuVo> getRootMenuListByUserInfo(UserInfo userInfo, boolean Leaves) {
        if (!userInfo.isAdmin()) {
            return this.menuDao.getRootMenuListByRoles(userInfo.getRoleIds(), Leaves);
        }
        return this.menuDao.getRootMenuListByRoles(null, Leaves);
    }

    public List<PfMenuVo> getRootMenuChildsByRoles(UserInfo userInfo, String menuParentId) {
        if (!userInfo.isAdmin()) {
            return this.menuDao.getRootMenuChildsByRoles(userInfo.getRoleIds(), menuParentId);
        }
        return this.menuDao.getRootMenuChildsByRoles(null, menuParentId);
    }

    public PfResourceVo getResource(String rid) {
        return this.menuDao.getResource(rid);
    }

    public PfResourceVo getResourceByCode(String code) {
        return this.menuDao.getResourceByCode(code);
    }

    public List<PfResourceVo> getProjectMenu(String roles, String wdid) {
        return this.menuDao.getProjectMenu(roles, wdid);
    }

    public List<String> getProjectWorkFlowDefineIds(String roles) {
        return this.menuDao.getProjectWorkFlowDefineIds(roles);
    }

    public List<PfMenuVo> getSysMenuByUserInfo(UserInfo userInfo) {
        if (!userInfo.isAdmin()) {
            return this.menuDao.getSysMenuByRoles(userInfo.getRoleIds());
        }
        return this.menuDao.getSysMenuByRoles(null);
    }

    public List<String> getWorkFlowDefineRoleIds(String workflowDefinitionId) {
        return this.menuDao.getWorkFlowDefineRoleIds(workflowDefinitionId);
    }
}

