/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.plat.portal.impl;

import com.gtis.plat.portal.PortalDao;
import com.gtis.plat.portal.PortalManager;
import com.gtis.plat.portal.model.Fragment;
import com.gtis.plat.portal.model.Page;
import com.gtis.plat.portal.model.Portlet;
import com.gtis.plat.portal.model.PortletApp;
import com.gtis.plat.portal.model.PortletEntity;
import com.gtis.plat.portal.model.Site;
import com.gtis.plat.service.CountProvider;
import com.gtis.plat.service.SysUserService;
import com.gtis.plat.vo.PfRoleVo;
import com.thoughtworks.xstream.XStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.util.ResourceUtils;

public class PortalManagerImpl
implements PortalManager {
    public static final String PORTLETAPPS_CONFIG = "classpath:portlets.xml";
    private Site globalSite;
    private List<PortletApp> portletApps;
    private Map<String, PortletEntity> pes;
    private XStream sm;
    private List<CountProvider> countProviders;
    private SysUserService sysUserService;
    private PortalDao portalDao;

    public void setSysUserService(SysUserService sysUserService) {
        this.sysUserService = sysUserService;
    }

    public void setCountProviders(List<CountProvider> countProviders) {
        this.countProviders = countProviders;
    }

    public void setPortalDao(PortalDao portalDao) {
        this.portalDao = portalDao;
    }

    public PortletApp getPortletApp(String name) {
        for (PortletApp pa : this.portletApps) {
            if (!pa.getName().equals(name)) continue;
            return pa;
        }
        return null;
    }

    public List<PortletApp> getPortletApps() {
        return this.portletApps;
    }

    public PortletEntity getPortletEntity(String id) {
        return (PortletEntity)this.pes.get(id);
    }

    public Collection<PortletEntity> getPortletEntities() {
        return this.pes.values();
    }

    public PortletEntity savePortletEntity(PortletEntity pe) {
        boolean isCreate = StringUtils.isEmpty((String)pe.getId());
        this.portalDao.savePortletEntity(pe);
        if (!isCreate) {
            PortletEntity sPe = this.getPortletEntity(pe.getId());
            BeanUtils.copyProperties((Object)pe, (Object)sPe);
            pe = sPe;
        } else {
            this.pes.put(pe.getId(), pe);
        }
        pe.setApp(this.getPortletApp(pe.getAppName()));
        return pe;
    }

    public void removePortletEntity(String id) {
        this.portalDao.removePortletEntity(id);
        this.pes.remove(id);
    }

    public Site getSite(String owner) {
        Site site;
        if ("global".equals(owner)) {
            site = this.globalSite;
        } else if (owner.startsWith("role_")) {
            site = this.portalDao.getSite(owner);
            if (site == null) {
                try {
                    site = this.globalSite.clone();
                    site.setOwner(owner);
                }
                catch (CloneNotSupportedException e) {
                    throw new RuntimeException(e);
                }
            }
        } else {
            site = this.portalDao.getSite(owner);
            if (site == null) {
                Map map = this.portalDao.getRoleSitesMap();
                for (PfRoleVo role : this.sysUserService.getRoleListByUser(owner)) {
                    site = (Site)map.get("role_" + role.getRoleId());
                    if (site == null) continue;
                    break;
                }
                if (site == null) {
                    site = this.globalSite;
                }
                try {
                    site = site.clone();
                    site.setOwner(owner);
                }
                catch (CloneNotSupportedException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        this.initPortlets(site);
        return site;
    }

    public Site saveSite(Site site) {
        this.initPortlets(site);
        return this.portalDao.saveSite(site);
    }

    public void removeSite(String owner) {
        this.portalDao.removeSite(owner);
    }

    public List<CountProvider> getCountProviders() {
        return this.countProviders;
    }

    public void resetUserSite() {
        this.portalDao.resetUserSite();
    }

    public synchronized void init() throws Exception {
        this.sm = new XStream();
        this.sm.alias("portlet", PortletApp.class);
        this.loadPortletApps();
        this.pes = new HashMap();
        List entities = this.portalDao.getPortletEntities();
        for (PortletEntity pe : entities) {
            pe.setApp(this.getPortletApp(pe.getAppName()));
            this.pes.put(pe.getId(), pe);
        }
        this.globalSite = this.portalDao.getSite("global");
        if (this.globalSite == null) {
            this.globalSite = new Site();
            this.globalSite.setOwner("global");
            Page page = new Page();
            page.setName("index");
            this.globalSite.getPages().add(page);
            page.setLayout("2-0");
            for (int i = 0; i < 3; ++i) {
                Fragment fragment = new Fragment();
                page.getFragments().add(fragment);
            }
            this.portalDao.saveSite(this.globalSite);
        }
    }

    private void initPortlets(Site site) {
        for (Page page : site.getPages()) {
            for (Fragment fm : page.getFragments()) {
                for (Portlet portlet : fm.getPortlets()) {
                    PortletEntity entity = this.getPortletEntity(portlet.getEntityId());
                    if (portlet.getEntity() != null) continue;
                    portlet.setEntity(entity);
                }
            }
        }
    }

    private void loadPortletApps() {
        try {
            File file = ResourceUtils.getFile((String)PORTLETAPPS_CONFIG);
            this.portletApps = (List)this.sm.fromXML((Reader)new FileReader(file));
        }
        catch (IOException e) {
            this.portletApps = new ArrayList();
        }
    }
}

