/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.plat.portal.impl;

import com.gtis.plat.portal.PortalDao;
import com.gtis.plat.portal.impl.PortalDaoImpl;
import com.gtis.plat.portal.model.PortletEntity;
import com.gtis.plat.portal.model.Site;
import com.gtis.util.UUIDGenerator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.PreparedStatementCallback;
import org.springframework.jdbc.core.simple.ParameterizedRowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.jdbc.support.lob.LobHandler;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository(value="portalDao")
public class PortalDaoImpl
implements PortalDao {
    private static final Logger logger = LoggerFactory.getLogger(PortalDaoImpl.class);
    protected LobHandler lobHandler;
    private SimpleJdbcTemplate simpleJdbcTemplate;

    public void setLobHandler(LobHandler lobHandler) {
        this.lobHandler = lobHandler;
    }

    public void setDataSource(DataSource dataSource) {
        this.simpleJdbcTemplate = new SimpleJdbcTemplate(dataSource);
    }

    @Transactional(readOnly=true)
    public PortletEntity getPortletEntity(String id) {
        String sql = "select entity from t_pf_portlet_entity where id=?";
        try {
            return (PortletEntity)this.simpleJdbcTemplate.queryForObject("select entity from t_pf_portlet_entity where id=?", (ParameterizedRowMapper)new PortletEntityRowMapper(this, null), new Object[]{id});
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
    }

    @Transactional(readOnly=true)
    public List<PortletEntity> getPortletEntities() {
        String sql = "select entity from t_pf_portlet_entity";
        try {
            return this.simpleJdbcTemplate.query("select entity from t_pf_portlet_entity", (ParameterizedRowMapper)new PortletEntityRowMapper(this, null), new Object[0]);
        }
        catch (EmptyResultDataAccessException e) {
            return new ArrayList<PortletEntity>();
        }
    }

    @Transactional
    public PortletEntity savePortletEntity(PortletEntity portletEntity) {
        String sql;
        if (StringUtils.isBlank((String)portletEntity.getId())) {
            portletEntity.setId(UUIDGenerator.generate());
            sql = "insert into t_pf_portlet_entity (entity,id) values (?,?)";
        } else {
            sql = "update t_pf_portlet_entity set entity=? where id=?";
        }
        this.simpleJdbcTemplate.getJdbcOperations().execute(sql, (PreparedStatementCallback)new /* Unavailable Anonymous Inner Class!! */);
        return portletEntity;
    }

    @Transactional
    public void removePortletEntity(String id) {
        String sql = "delete from t_pf_portlet_entity where id=?";
        this.simpleJdbcTemplate.update("delete from t_pf_portlet_entity where id=?", new Object[]{id});
        logger.debug("remove portletEntity,id:({})", (Object)id);
    }

    public boolean portletEntityExist(String id) {
        String sql = "select count(0) from t_pf_portlet_entity where id=?";
        return this.simpleJdbcTemplate.queryForInt("select count(0) from t_pf_portlet_entity where id=?", new Object[]{id}) > 0;
    }

    @Transactional(readOnly=true)
    public Site getSite(String owner) {
        String sql = "select site from t_pf_portal_site where owner=?";
        try {
            return (Site)this.simpleJdbcTemplate.queryForObject("select site from t_pf_portal_site where owner=?", (ParameterizedRowMapper)new SiteRowMapper(this, null), new Object[]{owner});
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
    }

    @Transactional
    public Site saveSite(Site site) {
        String sql = this.siteExist(site.getOwner()) ? "update t_pf_portal_site set site=? where owner=?" : "insert into t_pf_portal_site (site,owner) values (?,?)";
        this.simpleJdbcTemplate.getJdbcOperations().execute(sql, (PreparedStatementCallback)new /* Unavailable Anonymous Inner Class!! */);
        return site;
    }

    @Transactional
    public void removeSite(String owner) {
        String sql = "delete from t_pf_portal_site where owner=?";
        this.simpleJdbcTemplate.update("delete from t_pf_portal_site where owner=?", new Object[]{owner});
        logger.debug("remove site,owner:({})", (Object)owner);
    }

    public void resetUserSite() {
        String sql = "delete from t_pf_portal_site where owner!='global' and owner not like 'role_%'";
        this.simpleJdbcTemplate.update("delete from t_pf_portal_site where owner!='global' and owner not like 'role_%'", new Object[0]);
    }

    public Map<String, Site> getRoleSitesMap() {
        String sql = "select site from t_pf_portal_site where owner like 'role_%'";
        HashMap<String, Site> map = new HashMap<String, Site>();
        for (Site site : this.simpleJdbcTemplate.query("select site from t_pf_portal_site where owner like 'role_%'", (ParameterizedRowMapper)new SiteRowMapper(this, null), new Object[0])) {
            map.put(site.getOwner(), site);
        }
        return map;
    }

    public boolean siteExist(String owner) {
        String sql = "select count(0) from t_pf_portal_site where owner=?";
        return this.simpleJdbcTemplate.queryForInt("select count(0) from t_pf_portal_site where owner=?", new Object[]{owner}) > 0;
    }
}

