/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.plat.form;

import com.gtis.common.util.UUIDGenerator;
import com.gtis.plat.datasource.BusinessDataSource;
import com.gtis.plat.form.FormInstance;
import com.gtis.plat.form.FormModel;
import com.gtis.plat.form.FormModelFactory;
import com.gtis.plat.form.FormSqlBuilder;
import com.gtis.plat.form.FormSqlProcessor;
import com.gtis.plat.form.GroupDefine;
import com.gtis.plat.service.SysFormService;
import com.gtis.plat.vo.PfBusinessVo;
import com.gtis.plat.vo.PfFormDefineVo;
import com.gtis.spring.Container;
import com.gtis.util.DataSourceManager;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.Element;
import org.springframework.jdbc.core.JdbcTemplate;

/*
 * Exception performing whole class analysis ignored.
 */
public class FormInstanceFactory {
    private FormSqlProcessor formSqlProcessor;
    SysFormService formService;
    private static final Log log = LogFactory.getLog(FormInstanceFactory.class);

    public void setFormSqlProcessor(FormSqlProcessor formSqlProcessor) {
        this.formSqlProcessor = formSqlProcessor;
    }

    public FormInstance createFormInstance(String formDefineId) {
        FormInstance formInstance = new FormInstance();
        FormModel formModel = FormModelFactory.getFormModel((String)formDefineId);
        PfFormDefineVo formDefineVo = formModel.getFormDefineVo();
        PfBusinessVo businessVo = this.formService.getBusiness(formDefineVo);
        formInstance.setFormDefineVo(formDefineVo);
        formInstance.setBusinessVo(businessVo);
        try {
            Document formDefineDoc = formModel.getDefinitionXml();
            formInstance.setFormDefineDoc(formDefineDoc);
            formInstance.buildFormElementMap(formDefineDoc);
        }
        catch (Exception e) {
            log.error((Object)("\u8868\u5355\u5b9a\u4e49\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01" + formDefineId), (Throwable)e);
        }
        return formInstance;
    }

    public boolean saveFormInstance(Map requestMap, String formDefineId, String proId, HashMap queryParam) throws Exception {
        FormInstance formInstance = this.createFormInstance(formDefineId);
        formInstance.setQueryParam(queryParam);
        formInstance.setProId(proId);
        Map selectMap = this.checkResult(formInstance);
        if (selectMap == null) {
            this.insertFormInstance(formInstance);
            selectMap = this.checkResult(formInstance);
        }
        DataSource ds = BusinessDataSource.getDataSourceByBusiness((PfBusinessVo)formInstance.getBusinessVo());
        String updateSql = formInstance.getFormDefineVo().getUpdateCommand();
        List updateSqlCommandList = FormSqlBuilder.buildUpdateSql((FormInstance)formInstance, (Map)requestMap, (Map)selectMap);
        Connection conn = null;
        Statement st = null;
        try {
            conn = ds.getConnection();
            st = conn.createStatement();
            for (int i = 0; i < updateSqlCommandList.size(); ++i) {
                log.info((Object)("\u5f00\u59cb\u66f4\u65b0\u6570\u636e\u5e93\uff1a" + (String)updateSqlCommandList.get(i)));
                st.executeUpdate((String)updateSqlCommandList.get(i));
                continue;
            }
            this.saveGridForm(requestMap, formInstance, conn);
        }
        catch (Exception e) {
            try {
                log.error((Object)("\u8868\u5355\u66f4\u65b0SQL\u5b9a\u4e49\u9519\u8bef" + formInstance.getFormDefineVo().getFormDefinitionId() + "\uff0c\u8bf7\u68c0\u67e5\uff01" + updateSql), (Throwable)e);
                throw e;
            }
            catch (Throwable throwable) {
                DataSourceManager.attemptClose(st);
                DataSourceManager.attemptClose((Connection)conn);
                throw throwable;
            }
        }
        DataSourceManager.attemptClose((Statement)st);
        DataSourceManager.attemptClose((Connection)conn);
        return true;
    }

    public boolean saveFormInstance(Map requestMap, String formDefineId, String proId) throws Exception {
        return this.saveFormInstance(requestMap, formDefineId, proId, null);
    }

    public boolean saveGridForm(Map requestMap, FormInstance formInstance, Connection conn) throws Exception {
        Document dDoc = formInstance.getFormDefineDoc();
        String fkValue = "";
        List defGroupElementList = dDoc.selectNodes("/DataSet/Define/GroupDefine");
        for (int i = 0; i < defGroupElementList.size(); ++i) {
            Element elementGroup = (Element)defGroupElementList.get(i);
            String groupId = elementGroup.valueOf("@Id");
            GroupDefine groupDefine = new GroupDefine(requestMap, elementGroup);
            if (fkValue.length() == 0) {
                fkValue = FormInstanceFactory.getFormTablePKValue((FormInstance)formInstance, (String)groupDefine.getFkField(), (Connection)conn);
            }
            groupDefine.updateGridForm(fkValue, conn);
        }
        return true;
    }

    public static String getFormTablePKValue(FormInstance formInstance, String pkFieldName, Connection conn) throws Exception {
        String fkValue = "";
        String selectSql = formInstance.getFormDefineVo().getSelectCommand();
        FormSqlProcessor formSqlProcessor = (FormSqlProcessor)Container.getBean((String)"FormSqlProcessor");
        selectSql = formSqlProcessor.processor(selectSql, formInstance.getProId(), (Map)formInstance.getQueryParam());
        if (selectSql.toLowerCase().lastIndexOf("from") < 0) {
            return fkValue;
        }
        String fromStr = selectSql.substring(selectSql.toLowerCase().lastIndexOf("from"), selectSql.length());
        StringBuffer selectBuf = new StringBuffer();
        selectBuf.append("select ");
        Statement stmt = conn.createStatement();
        selectBuf.append(pkFieldName);
        selectBuf.append(" ");
        selectBuf.append(fromStr);
        ResultSet rs = stmt.executeQuery(selectBuf.toString());
        if (rs.next()) {
            fkValue = rs.getString(pkFieldName);
        }
        return fkValue;
    }

    private void insertFormInstance(FormInstance formInstance) throws Exception {
        DataSource ds = BusinessDataSource.getDataSourceByBusiness((PfBusinessVo)formInstance.getBusinessVo());
        String insertSql = formInstance.getFormDefineVo().getInsertCommand();
        insertSql = this.formSqlProcessor.processor(insertSql, formInstance.getProId(), (Map)formInstance.getQueryParam());
        insertSql = insertSql.replaceAll("\n", " ");
        insertSql = insertSql.replaceAll("\r", " ");
        Vector<String> insertSqlList = new Vector<String>();
        String sqlWorkStr = insertSql;
        while (sqlWorkStr.indexOf("@!SEPARATOR!@") >= 0) {
            String childInsertSql = sqlWorkStr.substring(0, sqlWorkStr.indexOf("@!SEPARATOR!@"));
            insertSqlList.add(childInsertSql);
            sqlWorkStr = sqlWorkStr.substring(sqlWorkStr.indexOf("@!SEPARATOR!@") + "@!SEPARATOR!@".length(), sqlWorkStr.length());
        }
        insertSqlList.add(sqlWorkStr);
        Connection conn = null;
        Statement st = null;
        try {
            conn = ds.getConnection();
            st = conn.createStatement();
            for (int i = 0; i < insertSqlList.size(); ++i) {
                String tempInsertSql = (String)insertSqlList.get(i);
                if (tempInsertSql == null || tempInsertSql.trim().length() == 0) continue;
                if (tempInsertSql.indexOf("#SYSBUILDPK#") > 0) {
                    String newPkId = UUIDGenerator.generate();
                    tempInsertSql = tempInsertSql.replaceAll("#SYSBUILDPK#", "'" + newPkId + "'");
                }
                st.executeUpdate(tempInsertSql);
            }
        }
        catch (Exception e) {
            try {
                log.error((Object)("\u8868\u5355\u67e5\u8be2SQL\u5b9a\u4e49\u9519\u8bef" + formInstance.getFormDefineVo().getFormDefinitionId() + "\uff0c\u8bf7\u68c0\u67e5\uff01" + insertSql), (Throwable)e);
                throw e;
            }
            catch (Throwable throwable) {
                DataSourceManager.attemptClose(st);
                DataSourceManager.attemptClose((Connection)conn);
                throw throwable;
            }
        }
        DataSourceManager.attemptClose((Statement)st);
        DataSourceManager.attemptClose((Connection)conn);
    }

    private Map checkResult(FormInstance formInstance) {
        DataSource ds = BusinessDataSource.getDataSourceByBusiness((PfBusinessVo)formInstance.getBusinessVo());
        String selectSql = formInstance.getFormDefineVo().getSelectCommand();
        try {
            selectSql = this.formSqlProcessor.processor(selectSql, formInstance.getProId(), (Map)formInstance.getQueryParam());
            JdbcTemplate jdbcTemplate = new JdbcTemplate(ds);
            List result = jdbcTemplate.queryForList(selectSql);
            if (result.size() > 0) {
                return (Map)result.get(0);
            }
        }
        catch (Exception e) {
            log.error((Object)("\u8868\u5355\u67e5\u8be2SQL\u5b9a\u4e49\u9519\u8bef" + formInstance.getFormDefineVo().getFormDefinitionId() + "\uff0c\u8bf7\u68c0\u67e5\uff01" + selectSql), (Throwable)e);
        }
        return null;
    }

    public SysFormService getFormService() {
        return this.formService;
    }

    public void setFormService(SysFormService formService) {
        this.formService = formService;
    }
}

