/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.plat.datasource;

import com.gtis.plat.vo.PfBusinessVo;
import java.util.HashMap;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class BusinessDataSource {
    private static String ORACLE_CLASSNAME = "oracle.jdbc.driver.OracleDriver";
    private static String SQL_CLASSNAME = "oracle.jdbc.driver.OracleDriver";
    public static HashMap<String, DataSource> businessDsMap;
    static Log log;

    public static DataSource getDataSourceByBusiness(PfBusinessVo businessVo) {
        DataSource ds = BusinessDataSource.getDataSourceFromMap((String)businessVo.getBusinessId());
        if (ds == null) {
            ds = BusinessDataSource.createDataSource((PfBusinessVo)businessVo);
        }
        return ds;
    }

    private static DataSource getDataSourceFromMap(String businessId) {
        if (businessDsMap == null) {
            businessDsMap = new HashMap();
        }
        return (DataSource)businessDsMap.get(businessId);
    }

    private static DataSource createDataSource(PfBusinessVo businessVo) {
        DataSource ds = null;
        try {
            if (businessVo.getDsUrl().indexOf("java:/comp/env") > -1) {
                InitialContext initContext = new InitialContext();
                Context envContext = (Context)initContext.lookup("java:/comp/env");
                ds = (DataSource)envContext.lookup(businessVo.getDsUrl().replaceAll("java:/comp/env/", ""));
            } else {
                ds = businessVo.getDsType().startsWith("SQL") ? BusinessDataSource.createSqlDataSource((PfBusinessVo)businessVo) : BusinessDataSource.createOracleDataSource((PfBusinessVo)businessVo);
            }
            businessDsMap.put(businessVo.getBusinessId(), ds);
        }
        catch (Exception ex) {
            log.error((Object)"", ex.getCause());
        }
        return ds;
    }

    private static DataSource createOracleDataSource(PfBusinessVo businessVo) {
        BasicDataSource ds = new BasicDataSource();
        ds.setDriverClassName(ORACLE_CLASSNAME);
        ds.setUrl(businessVo.getDsUrl());
        ds.setUsername(businessVo.getDsUser());
        ds.setPassword(businessVo.getDsUserPass());
        businessDsMap.put(businessVo.getBusinessId(), ds);
        return ds;
    }

    private static DataSource createSqlDataSource(PfBusinessVo businessVo) {
        BasicDataSource ds = new BasicDataSource();
        ds.setDriverClassName(SQL_CLASSNAME);
        ds.setUrl(businessVo.getDsUrl());
        ds.setUsername(businessVo.getDsUser());
        ds.setPassword(businessVo.getDsUserPass());
        businessDsMap.put(businessVo.getBusinessId(), ds);
        return ds;
    }

    static {
        log = LogFactory.getLog(BusinessDataSource.class);
    }
}

