/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.plat.dao;

import com.gtis.plat.vo.PfMenuVo;
import com.gtis.plat.vo.PfResourceVo;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.orm.ibatis.support.SqlMapClientDaoSupport;

public class SysMenuDao
extends SqlMapClientDaoSupport {
    public List<PfMenuVo> getMenuListByRoles(String roles) {
        HashMap<String, String> mapParam = new HashMap<String, String>();
        mapParam.put("roles", roles);
        return super.getSqlMapClientTemplate().queryForList("getMenuListByRoles", mapParam);
    }

    public List<PfMenuVo> getSysMenuByRoles(String roles) {
        HashMap<String, String> mapParam = new HashMap<String, String>();
        mapParam.put("roles", roles);
        return super.getSqlMapClientTemplate().queryForList("getSysMenuByRoles", mapParam);
    }

    public List<PfMenuVo> getRootMenuListByRoles(String roles, boolean leaves) {
        HashMap<String, Object> mapParam = new HashMap<String, Object>();
        mapParam.put("roles", roles);
        mapParam.put("leaves", leaves);
        return super.getSqlMapClientTemplate().queryForList("getRootMenuListByRoles", mapParam);
    }

    public List<PfMenuVo> getRootMenuChildsByRoles(String roles, String menuParentId) {
        HashMap<String, String> mapParam = new HashMap<String, String>();
        mapParam.put("roles", roles);
        if (menuParentId != null) {
            mapParam.put("menuParentId", menuParentId);
        } else {
            mapParam.put("menuParentId", "1");
        }
        return super.getSqlMapClientTemplate().queryForList("getRootMenuChildsByRoles", mapParam);
    }

    public PfResourceVo getResource(String rid) {
        return (PfResourceVo)super.getSqlMapClientTemplate().queryForObject("getResource", (Object)rid);
    }

    public PfResourceVo getResourceByCode(String code) {
        return (PfResourceVo)super.getSqlMapClientTemplate().queryForObject("getResourceByCode", (Object)code);
    }

    public List<PfResourceVo> getProjectMenu(String roles, String wdid) {
        HashMap<String, String> mapParam = new HashMap<String, String>();
        mapParam.put("roles", roles);
        mapParam.put("wdid", wdid);
        return super.getSqlMapClientTemplate().queryForList("getProjectMenu", mapParam);
    }

    public List<String> getProjectWorkFlowDefineIds(String roles) {
        if (StringUtils.isNotBlank((String)roles)) {
            return super.getSqlMapClientTemplate().queryForList("getProjectWorkFlowDefineIds", (Object)roles);
        }
        return null;
    }

    public List<String> getWorkFlowDefineRoleIds(String workflowDefinitionId) {
        HashMap<String, String> mapParam = new HashMap<String, String>();
        mapParam.put("workflowDefinitionId", workflowDefinitionId);
        return super.getSqlMapClientTemplate().queryForList("getWorkFlowDefineRoleIds", mapParam);
    }
}

