/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.oa.common.utils;

import com.jacob.activeX.ActiveXComponent;
import com.jacob.com.Dispatch;
import java.io.File;

public class OfficeToPdf {
    private static final int wdFormatPDF = 17;
    private static final int xlTypePDF = 0;
    private static final int ppSaveAsPDF = 32;
    private static final int msoTrue = -1;
    private static final int msofalse = 0;

    public boolean convert2PDF(String inputFile, String pdfFile) {
        String suffix = OfficeToPdf.getFileSufix(inputFile);
        File file = new File(inputFile);
        if (!file.exists()) {
            System.out.println("\u6587\u4ef6\u4e0d\u5b58\u5728\uff01");
            return false;
        }
        if (suffix.equals("pdf")) {
            System.out.println("PDF not need to convert!");
            return false;
        }
        if (suffix.equals("doc") || suffix.equals("docx") || suffix.equals("txt")) {
            return this.word2PDF(inputFile, pdfFile);
        }
        if (suffix.equals("ppt") || suffix.equals("pptx")) {
            return this.ppt2PDF(inputFile, pdfFile);
        }
        if (suffix.equals("xls") || suffix.equals("xlsx")) {
            return this.excel2PDF(inputFile, pdfFile);
        }
        System.out.println("\u6587\u4ef6\u683c\u5f0f\u4e0d\u652f\u6301\u8f6c\u6362!");
        return false;
    }

    public static String getFileSufix(String fileName) {
        int splitIndex = fileName.lastIndexOf(".");
        return fileName.substring(splitIndex + 1);
    }

    public boolean word2PDF(String inputFile, String pdfFile) {
        try {
            ActiveXComponent app = new ActiveXComponent("Word.Application");
            app.setProperty("Visible", false);
            Dispatch docs = app.getProperty("Documents").toDispatch();
            Dispatch doc = Dispatch.call((Dispatch)docs, (String)"Open", (Object[])new Object[]{inputFile, false, true}).toDispatch();
            Dispatch.call((Dispatch)doc, (String)"ExportAsFixedFormat", (Object[])new Object[]{pdfFile, 17});
            Dispatch.call((Dispatch)doc, (String)"Close", (Object[])new Object[]{false});
            app.invoke("Quit", 0);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean excel2PDF(String inputFile, String pdfFile) {
        try {
            ActiveXComponent app = new ActiveXComponent("Excel.Application");
            app.setProperty("Visible", false);
            Dispatch excels = app.getProperty("Workbooks").toDispatch();
            Dispatch excel = Dispatch.call((Dispatch)excels, (String)"Open", (Object[])new Object[]{inputFile, false, true}).toDispatch();
            Dispatch.call((Dispatch)excel, (String)"ExportAsFixedFormat", (Object[])new Object[]{0, pdfFile});
            Dispatch.call((Dispatch)excel, (String)"Close", (Object[])new Object[]{false});
            app.invoke("Quit");
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean ppt2PDF(String inputFile, String pdfFile) {
        try {
            ActiveXComponent app = new ActiveXComponent("PowerPoint.Application");
            Dispatch ppts = app.getProperty("Presentations").toDispatch();
            Dispatch ppt = Dispatch.call((Dispatch)ppts, (String)"Open", (Object[])new Object[]{inputFile, true, true, false}).toDispatch();
            Dispatch.call((Dispatch)ppt, (String)"SaveAs", (Object[])new Object[]{pdfFile, 32});
            Dispatch.call((Dispatch)ppt, (String)"Close");
            app.invoke("Quit");
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void CorverImage(String imagePath) {
    }
}

