/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.oa.common.utils;

import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.google.common.io.BaseEncoding;
import com.gtis.oa.common.ex.AppException;
import com.gtis.oa.common.utils.Charsets;
import com.gtis.oa.common.utils.UUID;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public final class Codecs {
    private static HashFunction HF = Hashing.murmur3_128((int)"hp".hashCode());
    private static BaseEncoding BE = BaseEncoding.base64Url().omitPadding();

    public static byte[] hash(byte[] bytes) {
        return HF.hashBytes(bytes).asBytes();
    }

    public static String hash(String str) {
        return Codecs.encode(Codecs.hash(Codecs.bytes(str)));
    }

    public static String hash(String str, int len) {
        return StringUtils.left((String)Codecs.hash(str), (int)len);
    }

    public static String md5Hex(byte[] bytes) {
        return Hashing.md5().hashBytes(bytes).toString();
    }

    public static String md5Hex(String str) {
        return Codecs.md5Hex(Codecs.bytes(str));
    }

    public static String sha1Hex(byte[] bytes) {
        return Hashing.sha1().hashBytes(bytes).toString();
    }

    public static String sha1Hex(String str) {
        return Codecs.sha1Hex(Codecs.bytes(str));
    }

    public static String encode(byte[] bytes) {
        return BE.encode(bytes);
    }

    public static String encode(long l) {
        ByteBuffer buf = ByteBuffer.allocate(8);
        buf.putLong(l);
        return Codecs.encode(buf.array());
    }

    public static String encode(int i) {
        ByteBuffer buf = ByteBuffer.allocate(4);
        buf.putInt(i);
        return Codecs.encode(buf.array());
    }

    public static byte[] decode(String str) {
        return BE.decode((CharSequence)str);
    }

    public static byte[] xor(byte[] bytes, byte[] keyBytes) {
        int len = bytes.length;
        int keyLen = keyBytes.length;
        for (int i = 0; i < len; ++i) {
            bytes[i] = (byte)(bytes[i] ^ keyBytes[i % keyLen]);
        }
        return bytes;
    }

    public static String xorEncode(String str, String key) {
        return Codecs.encode(Codecs.xor(Codecs.bytes(str), Codecs.bytes(key)));
    }

    public static String xorDecode(String str, String key) {
        return Codecs.string(Codecs.xor(Codecs.decode(str), Codecs.bytes(key)));
    }

    public static String uuid() {
        return Codecs.encode(Codecs.hash(UUID.bytes()));
    }

    public static String uuid(int len) {
        return StringUtils.left((String)Codecs.encode(Codecs.hash(UUID.bytes())), (int)len);
    }

    public static byte[] bytes(String s) {
        if (s == null) {
            return ArrayUtils.EMPTY_BYTE_ARRAY;
        }
        try {
            return s.getBytes(Charsets.UTF8);
        }
        catch (UnsupportedEncodingException e) {
            throw new AppException(e);
        }
    }

    public static String string(byte[] bytes) {
        try {
            return new String(bytes, Charsets.UTF8);
        }
        catch (UnsupportedEncodingException e) {
            throw new AppException(e);
        }
    }
}

